/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.functional;

import java.util.function.Consumer;
import one.microstream.X;

public final class LimitedProcedure<E>
implements Consumer<E> {
    private final Consumer<? super E> procedure;
    private int skip;
    private int limit;

    public LimitedProcedure(Consumer<? super E> procedure, int skip, int limit) {
        this.procedure = X.notNull(procedure);
        this.skip = skip;
        this.limit = limit;
    }

    @Override
    public final void accept(E e) {
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        if (this.limit > 0) {
            this.procedure.accept(e);
            --this.limit;
            return;
        }
        throw X.BREAK();
    }
}

