/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.functional;

import java.util.function.Predicate;
import one.microstream.X;

public final class RangedPredicate<E>
implements Predicate<E> {
    private int offset;
    private int length;
    private final Predicate<? super E> predicate;

    public RangedPredicate(int offset, int length, Predicate<? super E> predicate) {
        this.offset = offset;
        this.length = length;
        this.predicate = predicate;
    }

    @Override
    public boolean test(E e) {
        if (this.offset > 0) {
            --this.offset;
            return false;
        }
        if (this.predicate.test(e)) {
            return true;
        }
        if (--this.length <= 0) {
            throw X.BREAK();
        }
        return false;
    }
}

