/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.memory;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.HashTable;
import one.microstream.collections.XArrays;
import one.microstream.exceptions.InstantiationRuntimeException;
import one.microstream.exceptions.MemoryException;
import one.microstream.functional.DefaultInstantiator;
import one.microstream.memory.BufferRegistry;
import one.microstream.memory.DirectBufferDeallocator;
import one.microstream.memory.MemoryAccessor;
import one.microstream.memory.MemoryAccessorReversing;
import one.microstream.memory.MemoryStatistics;
import one.microstream.memory.XMemory;
import one.microstream.reflect.XReflect;
import one.microstream.typing.XTypes;

public final class MemoryAccessorGeneric
implements MemoryAccessor {
    static final int SMALL_CHUNK_MAX_SLOT_COUNT = 127;
    static final int SMALL_CHUNK_SIZE_BITCOUNT = 10;
    static final int SMALL_CHUNK_CHAIN_BITCOUNT = 20;
    static final int SMALL_CHUNK_SIZE_BITSHIFT_COUNT = 20;
    static final int SMALL_CHUNK_CHAIN_BITSHIFT_COUNT = 0;
    static final int SMALL_CHUNK_SIZE_BITMASK = 0x3FF00000;
    static final int SMALL_CHUNK_CHAIN_BITMASK = 1048575;
    static final int SMALL_CHUNK_MAX_BUFFER_SIZE = 4096;
    static final int SMALL_CHUNK_MAX_SIZE = 1024;
    static final int SMALL_CHUNK_MAX_CHAIN_LENGTH = 0x100000;
    static final int SMALL_CHUNK_SIZE_4_SLOTS = 820;
    static final int SMALL_CHUNK_SIZE_5_SLOTS = 683;
    static final int SMALL_CHUNK_SIZE_6_SLOTS = 586;
    static final int SMALL_CHUNK_SIZE_7_SLOTS = 513;
    static final int SMALL_CHUNK_SIZE_8_SLOTS = 456;
    static final int SMALL_CHUNK_SIZE_M_SLOTS = 33;
    static final int SMALL_CHUNK_CHAIN_INCREMENT = 8;
    static final int SMALL_CHUNK_CHAIN_INITIAL_INDEX = 0;
    static final int SMALL_CHUNK_SLOTS_INITIAL_INDEX = 0;
    static final int SMALL_CHUNK_LOWEST_VALID_SIZE = 1;
    static final long IDENTIFIER_BITSHIFT_COUNT = 32L;
    static final long SMALL_CHUNK_SIZE_BOUND = 1025L;
    static final long BIG_CHUNK_SIZE_BOUND = 0x80000000L;
    static final long SIZE_TYPE_FLAG = 0x4000000000000000L;
    static final long REGISTERED_FLAG = 0x2000000000000000L;
    static final long LOWEST_VALID_ADDRESS = 1L;
    static final long BIG_CHUNK_TABLE_MAX_LENGTH = 0x1FFFFFFFL;
    static final int BIG_CHUNK_TABLE_INCREMENT = 64;
    static final int BIG_CHUNK_NO_FREE_SLOT_INDEX = Integer.MAX_VALUE;
    static final int REGISTERED_MAXIMUM_CAPACITY = 0x20000000;
    private final DefaultInstantiator defaultInstantiator;
    private final DirectBufferDeallocator directBufferDeallocator;
    private final MemoryAccessorReversing reversing = new MemoryAccessorReversing(this);
    private final HashTable<Class<?>, Field[]> objectFieldsRegistry = HashTable.New();
    private final ByteBuffer[][] smallChunkBufferChains = new ByteBuffer[1024][];
    private final byte[][] smallChunkBufferChainSizes = new byte[1024][];
    private final boolean[][][] smallChunkBufferSlotsChains = new boolean[1024][][];
    private ByteBuffer[] bigChunkBuffers = new ByteBuffer[64];
    private int firstFreeBigChunkBufferIndex = 0;
    private final BufferRegistry bufferRegistry = new BufferRegistry(0x20000000);

    private static int calculateSlotCount(int chunkSize) {
        if (chunkSize >= 456) {
            if (chunkSize >= 820) {
                return 4;
            }
            if (chunkSize >= 683) {
                return 5;
            }
            if (chunkSize >= 586) {
                return 6;
            }
            if (chunkSize >= 513) {
                return 7;
            }
            return 8;
        }
        if (chunkSize < 33) {
            return 127;
        }
        return 4096 / chunkSize;
    }

    private static long packSmallChunkAddress(int chunkSizeIndex, int chainIndex, int slotIndex) {
        return 0x4000000000000000L | ((long)MemoryAccessorGeneric.packSmallChunkIdentifier(chunkSizeIndex, chainIndex) << 32) + (long)(slotIndex * MemoryAccessorGeneric.toChunkSize(chunkSizeIndex));
    }

    private static int packSmallChunkIdentifier(int chunkSizeIndex, int chainIndex) {
        return chunkSizeIndex << 20 | chainIndex << 0;
    }

    private static int unpackSmallChunkSizeIndex(int packedSmallChunkIdentifier) {
        return packedSmallChunkIdentifier >>> 20;
    }

    private static int unpackSmallChunkChainIndex(int packedSmallChunkIdentifier) {
        return (packedSmallChunkIdentifier & 0xFFFFF) >>> 0;
    }

    private static long packBigChunkAddress(int bigChunkIndex) {
        return (long)(bigChunkIndex + 1) << 32;
    }

    private static long packRegisteredAddress(int registeredIndex) {
        return (long)registeredIndex << 32 | 0x2000000000000000L;
    }

    private static int unpackBufferPosition(long packedAddress) {
        return (int)packedAddress;
    }

    private static int unpackBufferLimit(long packedAddress) {
        return MemoryAccessorGeneric.isSmallChunkAddress(packedAddress) ? MemoryAccessorGeneric.unpackSmallChunkBufferLimit(packedAddress) : -1;
    }

    private static int unpackSmallChunkBufferLimit(long smallChunkPackedAddress) {
        int smallIdentifier = MemoryAccessorGeneric.unpackSmallChunkBufferIdentifier(smallChunkPackedAddress);
        int bufferPosition = MemoryAccessorGeneric.unpackBufferPosition(smallChunkPackedAddress);
        int chunkSize = MemoryAccessorGeneric.unpackSmallChunkSizeIndex(smallIdentifier) + 1;
        int slotIndex = bufferPosition / chunkSize;
        return (slotIndex + 1) * chunkSize;
    }

    private static boolean isSmallChunkAddress(long packedAddress) {
        return (packedAddress & 0x4000000000000000L) != 0L;
    }

    private static boolean isRegisteredAddress(long packedAddress) {
        return (packedAddress & 0x2000000000000000L) != 0L;
    }

    private static int unpackBigChunkBufferIndex(long packedAddress) {
        return (int)(packedAddress >>> 32) - 1;
    }

    private static int unpackRegisteredBufferIndex(long packedAddress) {
        return (int)((packedAddress ^ 0x2000000000000000L) >>> 32);
    }

    private static int unpackSmallChunkBufferIdentifier(long packedAddress) {
        return (int)((packedAddress ^ 0x4000000000000000L) >>> 32);
    }

    public static MemoryAccessorGeneric New() {
        return MemoryAccessorGeneric.New(DefaultInstantiator.Default());
    }

    public static MemoryAccessorGeneric New(DefaultInstantiator defaultInstantiator) {
        return MemoryAccessorGeneric.New(X.notNull(defaultInstantiator), DirectBufferDeallocator.NoOp());
    }

    public static MemoryAccessorGeneric New(DirectBufferDeallocator directBufferDeallocator) {
        return MemoryAccessorGeneric.New(DefaultInstantiator.Default(), X.notNull(directBufferDeallocator));
    }

    public static MemoryAccessorGeneric New(DefaultInstantiator defaultInstantiator, DirectBufferDeallocator directBufferDeallocator) {
        return new MemoryAccessorGeneric(X.notNull(defaultInstantiator), X.notNull(directBufferDeallocator));
    }

    MemoryAccessorGeneric(DefaultInstantiator defaultInstantiator, DirectBufferDeallocator directBufferDeallocator) {
        this.defaultInstantiator = defaultInstantiator;
        this.directBufferDeallocator = directBufferDeallocator;
    }

    private static ByteBuffer createBuffer(int capacity) {
        return XMemory.allocateDirectNative(capacity);
    }

    private long initializeSmallChunkBufferChain(int chunkSize) {
        ByteBuffer buffer;
        int chainLength = 8;
        boolean initChainIdx = false;
        boolean initSlotIdx = false;
        int slotCount = MemoryAccessorGeneric.calculateSlotCount(chunkSize);
        int chunkIdx = MemoryAccessorGeneric.toChunkSizeIndex(chunkSize);
        byte[] chainSizes = new byte[8];
        boolean[][] slotsChains = new boolean[8][];
        boolean[] slots = new boolean[slotCount];
        ByteBuffer[] bufferChain = new ByteBuffer[8];
        bufferChain[0] = buffer = MemoryAccessorGeneric.createBuffer(slotCount * chunkSize);
        chainSizes[0] = 1;
        slotsChains[0] = slots;
        slots[0] = true;
        this.smallChunkBufferChains[chunkIdx] = bufferChain;
        this.smallChunkBufferChainSizes[chunkIdx] = chainSizes;
        this.smallChunkBufferSlotsChains[chunkIdx] = slotsChains;
        return MemoryAccessorGeneric.packSmallChunkAddress(chunkIdx, 0, 0);
    }

    private static int toChunkSizeIndex(int chunkSize) {
        return chunkSize - 1;
    }

    private static int toChunkSize(int chunkSizeIndex) {
        return chunkSizeIndex + 1;
    }

    private static void validateChunkSize(int chunkSize) {
        if (chunkSize < 0) {
            throw new MemoryException("Invalid memory range: " + chunkSize);
        }
    }

    private long allocateMemorySmall(int chunkSize) {
        MemoryAccessorGeneric.validateChunkSize(chunkSize);
        if (chunkSize == 0) {
            return 0L;
        }
        byte[] index = this.smallChunkBufferChainSizes[MemoryAccessorGeneric.toChunkSizeIndex(chunkSize)];
        if (index == null) {
            return this.initializeSmallChunkBufferChain(chunkSize);
        }
        int slotCount = MemoryAccessorGeneric.calculateSlotCount(chunkSize);
        int i = 0;
        while (i < index.length) {
            if (index[i] < slotCount) {
                return this.addSmallChunk(chunkSize, i);
            }
            ++i;
        }
        this.enlargeSmallChunkBufferChain(chunkSize);
        return this.addSmallChunk(chunkSize, index.length);
    }

    private void ensureBuffer(int chunkSize, int chainPosition) {
        if (this.smallChunkBufferChainSizes[MemoryAccessorGeneric.toChunkSizeIndex(chunkSize)][chainPosition] == 0) {
            int chunkSizeIdx = MemoryAccessorGeneric.toChunkSizeIndex(chunkSize);
            int slotCount = MemoryAccessorGeneric.calculateSlotCount(chunkSize);
            this.smallChunkBufferChains[chunkSizeIdx][chainPosition] = MemoryAccessorGeneric.createBuffer(slotCount * chunkSize);
            this.smallChunkBufferSlotsChains[chunkSizeIdx][chainPosition] = new boolean[slotCount];
        }
    }

    private long addSmallChunk(int chunkSize, int chainPosition) {
        this.ensureBuffer(chunkSize, chainPosition);
        int chunkSizeIdx = MemoryAccessorGeneric.toChunkSizeIndex(chunkSize);
        boolean[] slots = this.smallChunkBufferSlotsChains[chunkSizeIdx][chainPosition];
        int slotIndex = 0;
        int i = 0;
        while (i < slots.length) {
            if (!slots[i]) {
                slotIndex = i;
                slots[slotIndex] = true;
                break;
            }
            ++i;
        }
        byte[] byArray = this.smallChunkBufferChainSizes[chunkSizeIdx];
        int n = chainPosition;
        byArray[n] = (byte)(byArray[n] + 1);
        return MemoryAccessorGeneric.packSmallChunkAddress(chunkSizeIdx, chainPosition, slotIndex);
    }

    private static int calculateIncreasedSmallChunkChainLength(int oldChainLength) {
        if (oldChainLength + 8 >= 0x100000) {
            throw new MemoryException("Memory allocation capacity exceeded.");
        }
        return oldChainLength + 8;
    }

    private static int calculateDecreasedSmallChunkChainLength(int oldChainLength, int trailingFreeElementCount) {
        int alignedDecrease = trailingFreeElementCount / 8 * 8;
        int newLength = oldChainLength - alignedDecrease;
        return newLength;
    }

    private void enlargeSmallChunkBufferChain(int chunkSize) {
        int chunkSizeIndex = MemoryAccessorGeneric.toChunkSizeIndex(chunkSize);
        int newLength = MemoryAccessorGeneric.calculateIncreasedSmallChunkChainLength(this.smallChunkBufferChains[chunkSizeIndex].length);
        this.rebuildSmallChunkChains(chunkSizeIndex, newLength);
    }

    private void rebuildSmallChunkChains(int chunkSizeIndex, int newLength) {
        this.smallChunkBufferChains[chunkSizeIndex] = XArrays.rebuild(this.smallChunkBufferChains[chunkSizeIndex], newLength);
        this.smallChunkBufferChainSizes[chunkSizeIndex] = XArrays.rebuild(this.smallChunkBufferChainSizes[chunkSizeIndex], newLength);
        this.smallChunkBufferSlotsChains[chunkSizeIndex] = (boolean[][])XArrays.rebuild(this.smallChunkBufferSlotsChains[chunkSizeIndex], newLength);
    }

    private void clearSmallChunkChains(int chunkSizeIndex) {
        this.smallChunkBufferChains[chunkSizeIndex] = null;
        this.smallChunkBufferChainSizes[chunkSizeIndex] = null;
        this.smallChunkBufferSlotsChains[chunkSizeIndex] = null;
    }

    private long allocateMemoryBig(int chunkSize) {
        return this.firstFreeBigChunkBufferIndex < Integer.MAX_VALUE ? this.registerBigChunkBuffer(chunkSize, this.firstFreeBigChunkBufferIndex) : this.enlargeBigChunkBufferTableAndRegister(chunkSize);
    }

    private long registerBigChunkBuffer(int chunkSize, int bigChunkIndex) {
        this.bigChunkBuffers[bigChunkIndex] = MemoryAccessorGeneric.createBuffer(chunkSize);
        this.seekNextFreeBigChunkIndex(bigChunkIndex);
        return MemoryAccessorGeneric.packBigChunkAddress(bigChunkIndex);
    }

    private void seekNextFreeBigChunkIndex(int usedBigChunkIndex) {
        ByteBuffer[] bigChunkBuffers = this.bigChunkBuffers;
        int freeIndex = Integer.MAX_VALUE;
        int i = usedBigChunkIndex + 1;
        while (i < bigChunkBuffers.length) {
            if (bigChunkBuffers[i] == null) {
                freeIndex = i;
                break;
            }
            ++i;
        }
        this.firstFreeBigChunkBufferIndex = freeIndex;
    }

    private long enlargeBigChunkBufferTableAndRegister(int chunkSize) {
        int bigChunkIndex = this.bigChunkBuffers.length;
        int newLength = MemoryAccessorGeneric.calculateIncreasedBigChunkTableLength(this.bigChunkBuffers.length);
        this.bigChunkBuffers = XArrays.rebuild(this.bigChunkBuffers, newLength);
        this.bigChunkBuffers[bigChunkIndex] = MemoryAccessorGeneric.createBuffer(chunkSize);
        this.firstFreeBigChunkBufferIndex = bigChunkIndex + 1;
        return MemoryAccessorGeneric.packBigChunkAddress(bigChunkIndex);
    }

    private static int calculateIncreasedBigChunkTableLength(int oldTableLength) {
        if ((long)(oldTableLength + 64) >= 0x1FFFFFFFL) {
            throw new MemoryException("Memory allocation capacity exceeded.");
        }
        return oldTableLength + 64;
    }

    private static int calculateDecreasedBigChunkTableLength(int oldTableLength, int trailingFreeElementCount) {
        int alignedDecrease = trailingFreeElementCount / 64 * 64;
        int newLength = oldTableLength - alignedDecrease;
        return Math.max(newLength, 64);
    }

    private static void validateAddress(long address) {
        if (address < 1L) {
            if (address == 0L) {
                throw new NullPointerException();
            }
            throw new MemoryException("Invalid address: " + address);
        }
    }

    private ByteBuffer getBuffer(long address) {
        MemoryAccessorGeneric.validateAddress(address);
        return MemoryAccessorGeneric.isSmallChunkAddress(address) ? this.getSmallChunkBuffer(MemoryAccessorGeneric.unpackSmallChunkBufferIdentifier(address)) : (MemoryAccessorGeneric.isRegisteredAddress(address) ? this.getRegisteredBuffer(MemoryAccessorGeneric.unpackRegisteredBufferIndex(address)) : this.getBigChunkBuffer(MemoryAccessorGeneric.unpackBigChunkBufferIndex(address)));
    }

    private ByteBuffer getSmallChunkBuffer(int identifier) {
        return this.smallChunkBufferChains[MemoryAccessorGeneric.unpackSmallChunkSizeIndex(identifier)][MemoryAccessorGeneric.unpackSmallChunkChainIndex(identifier)];
    }

    private ByteBuffer getBigChunkBuffer(int identifier) {
        return this.bigChunkBuffers[identifier];
    }

    private ByteBuffer getRegisteredBuffer(int identifier) {
        ByteBuffer buffer = this.bufferRegistry.lookupBuffer(identifier);
        if (buffer != null) {
            return buffer;
        }
        throw new RuntimeException("Buffer not or no longer registered: " + identifier);
    }

    public final boolean systemDeallocateDirectByteBuffer(ByteBuffer directByteBuffer) {
        XTypes.guaranteeDirectByteBuffer(directByteBuffer);
        return this.directBufferDeallocator.deallocateDirectBuffer(directByteBuffer);
    }

    @Override
    public final void guaranteeUsability() {
    }

    @Override
    public final synchronized long getDirectByteBufferAddress(ByteBuffer directBuffer) {
        int registeredIndex = this.bufferRegistry.ensureRegistered(directBuffer);
        return MemoryAccessorGeneric.packRegisteredAddress(registeredIndex);
    }

    @Override
    public final synchronized boolean deallocateDirectByteBuffer(ByteBuffer directBuffer) {
        if (directBuffer == null) {
            return false;
        }
        this.bufferRegistry.ensureRemoved(directBuffer);
        return this.systemDeallocateDirectByteBuffer(directBuffer);
    }

    @Override
    public final boolean isDirectByteBuffer(ByteBuffer byteBuffer) {
        return XTypes.isDirectByteBuffer(byteBuffer);
    }

    @Override
    public final ByteBuffer guaranteeDirectByteBuffer(ByteBuffer directBuffer) {
        return XTypes.guaranteeDirectByteBuffer(directBuffer);
    }

    @Override
    public final synchronized long allocateMemory(long bytes) {
        if (bytes < 1025L) {
            return this.allocateMemorySmall((int)bytes);
        }
        if (bytes < 0x80000000L) {
            return this.allocateMemoryBig((int)bytes);
        }
        throw new MemoryException("Desired memory range to be allocated of " + bytes + " exceeds technical limit of " + Integer.MAX_VALUE);
    }

    @Override
    public final synchronized long reallocateMemory(long address, long bytes) {
        this.freeMemory(address);
        return this.allocateMemory(bytes);
    }

    @Override
    public final synchronized void freeMemory(long address) {
        if (address < 1L) {
            if (address == 0L) {
                return;
            }
            throw new MemoryException("Invalid address: " + address);
        }
        if (MemoryAccessorGeneric.isSmallChunkAddress(address)) {
            this.freeSmallChunkMemory(address);
        } else if (MemoryAccessorGeneric.isRegisteredAddress(address)) {
            this.freeRegisteredBuffer(address);
        } else {
            this.freeBigChunkMemory(address);
        }
    }

    private static void validateProperSmallChunkAddressId(long address, int chunkOffset) {
        if (chunkOffset != 0) {
            throw new MemoryException("Not the base address of an allocated memory range: " + address + " (offset = " + chunkOffset + ")");
        }
    }

    private void freeSmallChunkMemory(long address) {
        int identifier = MemoryAccessorGeneric.unpackSmallChunkBufferIdentifier(address);
        int bufferPosition = MemoryAccessorGeneric.unpackBufferPosition(address);
        int chunkSizeIndex = MemoryAccessorGeneric.unpackSmallChunkSizeIndex(identifier);
        int chunkSize = chunkSizeIndex + 1;
        int chainIndex = MemoryAccessorGeneric.unpackSmallChunkChainIndex(identifier);
        int slotIndex = bufferPosition / chunkSize;
        int chunkOffset = bufferPosition - slotIndex * chunkSize;
        MemoryAccessorGeneric.validateProperSmallChunkAddressId(address, chunkOffset);
        boolean[] slots = this.lookupSlotsNonEmpty(chunkSizeIndex, chainIndex, slotIndex);
        byte[] chainSizes = this.lookupChainSizesNonZero(chunkSizeIndex, chainIndex);
        int n = chainIndex;
        chainSizes[n] = (byte)(chainSizes[n] - 1);
        if (chainSizes[n] == 0) {
            this.removeSmallChunkBuffer(chunkSizeIndex, chainIndex);
        } else {
            slots[slotIndex] = false;
        }
    }

    private void removeSmallChunkBuffer(int chunkSizeIndex, int chainIndex) {
        this.smallChunkBufferChains[chunkSizeIndex][chainIndex] = null;
        this.smallChunkBufferSlotsChains[chunkSizeIndex][chainIndex] = null;
        this.checkForSmallChunkBufferChainShrinking(chunkSizeIndex, chainIndex);
    }

    private void checkForSmallChunkBufferChainShrinking(int chunkSizeIndex, int chainIndex) {
        ByteBuffer[] bufferChain = this.smallChunkBufferChains[chunkSizeIndex];
        int i = chainIndex;
        while (i < bufferChain.length) {
            if (bufferChain[i] != null) {
                return;
            }
            ++i;
        }
        this.optimizeSmallChunkBufferChain(chunkSizeIndex, chainIndex);
    }

    private void optimizeSmallChunkBufferChain(int chunkSizeIndex, int chainIndex) {
        ByteBuffer[] bufferChain = this.smallChunkBufferChains[chunkSizeIndex];
        int highestNonNullIndex = -1;
        int i = chainIndex - 1;
        while (i >= 0) {
            if (bufferChain[i] != null) {
                highestNonNullIndex = i;
                break;
            }
            --i;
        }
        int freeElementCount = bufferChain.length - (highestNonNullIndex + 1);
        int newLength = MemoryAccessorGeneric.calculateDecreasedSmallChunkChainLength(bufferChain.length, freeElementCount);
        if (newLength < bufferChain.length) {
            if (newLength == 0) {
                this.clearSmallChunkChains(chunkSizeIndex);
            } else {
                this.rebuildSmallChunkChains(chunkSizeIndex, newLength);
            }
        }
    }

    public ByteBuffer[] lookupChainNonNull(int chunkSizeIndex, int chainIndex) {
        ByteBuffer[] bufferChain = this.lookupChain(chunkSizeIndex);
        if (bufferChain[chainIndex] == null) {
            throw new MemoryException("Inconsistency for chunkSize " + MemoryAccessorGeneric.toChunkSize(chunkSizeIndex));
        }
        return bufferChain;
    }

    public ByteBuffer[] lookupChain(int chunkSizeIndex) {
        ByteBuffer[] bufferChain = this.smallChunkBufferChains[chunkSizeIndex];
        if (bufferChain == null) {
            throw new MemoryException("Inconsistency for chunkSize " + MemoryAccessorGeneric.toChunkSize(chunkSizeIndex));
        }
        return bufferChain;
    }

    private byte[] lookupChainSizesNonZero(int chunkSizeIndex, int chainIndex) {
        byte[] chainSizes = this.lookupChainSizes(chunkSizeIndex);
        if (chainSizes[chainIndex] == 0) {
            throw new MemoryException("Inconsistency for chunkSize " + MemoryAccessorGeneric.toChunkSize(chunkSizeIndex));
        }
        return chainSizes;
    }

    private byte[] lookupChainSizes(int chunkSizeIndex) {
        byte[] chainSizes = this.smallChunkBufferChainSizes[chunkSizeIndex];
        if (chainSizes == null) {
            throw new MemoryException("Inconsistency for chunkSize " + MemoryAccessorGeneric.toChunkSize(chunkSizeIndex));
        }
        return chainSizes;
    }

    private boolean[] lookupSlots(int chunkSizeIndex, int chunkChainIndex) {
        boolean[][] slotsChain = this.smallChunkBufferSlotsChains[chunkSizeIndex];
        if (slotsChain == null) {
            throw new MemoryException("Invalid address");
        }
        boolean[] slots = slotsChain[chunkChainIndex];
        if (slots == null) {
            throw new MemoryException("Invalid address");
        }
        return slots;
    }

    private boolean[] lookupSlotsNonEmpty(int chunkSizeIndex, int chunkChainIndex, int slotIndex) {
        boolean[] slots = this.lookupSlots(chunkSizeIndex, chunkChainIndex);
        if (!slots[slotIndex]) {
            throw new MemoryException("Invalid address");
        }
        return slots;
    }

    private void freeRegisteredBuffer(long address) {
        ByteBuffer buffer = this.bufferRegistry.lookupBuffer(MemoryAccessorGeneric.unpackRegisteredBufferIndex(address));
        this.deallocateDirectByteBuffer(buffer);
    }

    private void freeBigChunkMemory(long address) {
        ByteBuffer[] bigChunkBuffers = this.bigChunkBuffers;
        int index = MemoryAccessorGeneric.unpackBigChunkBufferIndex(address);
        if (index < 0 || index >= bigChunkBuffers.length || bigChunkBuffers[index] == null) {
            throw new MemoryException("Invalid address");
        }
        bigChunkBuffers[index] = null;
        if (index < this.firstFreeBigChunkBufferIndex) {
            this.firstFreeBigChunkBufferIndex = index;
        }
        this.checkForBigChunkTableDecrease(index);
    }

    private void checkForBigChunkTableDecrease(int currentIndex) {
        ByteBuffer[] bigChunkBuffers = this.bigChunkBuffers;
        int freeTrailingElementCount = 0;
        int i = currentIndex;
        while (i < bigChunkBuffers.length) {
            if (bigChunkBuffers[i] != null) {
                return;
            }
            ++freeTrailingElementCount;
            ++i;
        }
        i = currentIndex;
        while (--i >= 0) {
            if (bigChunkBuffers[i] != null) break;
            ++freeTrailingElementCount;
        }
        int newLength = MemoryAccessorGeneric.calculateDecreasedBigChunkTableLength(bigChunkBuffers.length, freeTrailingElementCount);
        if (newLength != bigChunkBuffers.length) {
            this.bigChunkBuffers = XArrays.rebuild(this.bigChunkBuffers, newLength);
        }
    }

    @Override
    public final synchronized void fillMemory(long targetAddress, long length, byte value) {
        int intLength = X.checkArrayRange(length);
        int targetPosition = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int targetBound = MemoryAccessorGeneric.unpackBufferLimit(targetAddress);
        ByteBuffer targetBuffer = this.getBuffer(targetAddress);
        int targetLimit = MemoryAccessorGeneric.determineActualCopyLimit(targetBound, targetBuffer);
        XArrays.validateRange0toUpperBound(targetLimit, targetPosition, intLength);
        long targetCurrentPosLim = XMemory.getPositionLimit(targetBuffer);
        XMemory.setPositionLimit(targetBuffer, targetPosition, targetPosition + intLength);
        int bound = targetPosition + intLength;
        int i = targetPosition;
        while (i < bound) {
            targetBuffer.put(i, value);
            ++i;
        }
        XMemory.setPositionLimit(targetBuffer, targetCurrentPosLim);
    }

    @Override
    public final synchronized byte get_byte(long address) {
        return this.getBuffer(address).get(MemoryAccessorGeneric.unpackBufferPosition(address));
    }

    @Override
    public final synchronized boolean get_boolean(long address) {
        return XTypes.to_boolean(this.get_byte(address));
    }

    @Override
    public final synchronized short get_short(long address) {
        return this.getBuffer(address).getShort(MemoryAccessorGeneric.unpackBufferPosition(address));
    }

    @Override
    public final synchronized char get_char(long address) {
        return this.getBuffer(address).getChar(MemoryAccessorGeneric.unpackBufferPosition(address));
    }

    @Override
    public final synchronized int get_int(long address) {
        return this.getBuffer(address).getInt(MemoryAccessorGeneric.unpackBufferPosition(address));
    }

    @Override
    public final synchronized float get_float(long address) {
        return this.getBuffer(address).getFloat(MemoryAccessorGeneric.unpackBufferPosition(address));
    }

    @Override
    public final synchronized long get_long(long address) {
        return this.getBuffer(address).getLong(MemoryAccessorGeneric.unpackBufferPosition(address));
    }

    @Override
    public final synchronized double get_double(long address) {
        return this.getBuffer(address).getDouble(MemoryAccessorGeneric.unpackBufferPosition(address));
    }

    @Override
    public final synchronized byte get_byte(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getByte(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized boolean get_boolean(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getBoolean(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized short get_short(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getShort(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized char get_char(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getChar(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized int get_int(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getInt(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized float get_float(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getFloat(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized long get_long(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getLong(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized double get_double(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).getDouble(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized Object getObject(Object instance, long offset) {
        try {
            return this.objectField(instance.getClass(), (int)offset).get(instance);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_byte(long address, byte value) {
        this.getBuffer(address).put(MemoryAccessorGeneric.unpackBufferPosition(address), value);
    }

    @Override
    public final synchronized void set_boolean(long address, boolean value) {
        this.getBuffer(address).put(MemoryAccessorGeneric.unpackBufferPosition(address), XTypes.to_byte(value));
    }

    @Override
    public final synchronized void set_short(long address, short value) {
        this.getBuffer(address).putShort(MemoryAccessorGeneric.unpackBufferPosition(address), value);
    }

    @Override
    public final synchronized void set_char(long address, char value) {
        this.getBuffer(address).putChar(MemoryAccessorGeneric.unpackBufferPosition(address), value);
    }

    @Override
    public final synchronized void set_int(long address, int value) {
        this.getBuffer(address).putInt(MemoryAccessorGeneric.unpackBufferPosition(address), value);
    }

    @Override
    public final synchronized void set_float(long address, float value) {
        this.getBuffer(address).putFloat(MemoryAccessorGeneric.unpackBufferPosition(address), value);
    }

    @Override
    public final synchronized void set_long(long address, long value) {
        this.getBuffer(address).putLong(MemoryAccessorGeneric.unpackBufferPosition(address), value);
    }

    @Override
    public final synchronized void set_double(long address, double value) {
        this.getBuffer(address).putDouble(MemoryAccessorGeneric.unpackBufferPosition(address), value);
    }

    @Override
    public final synchronized void set_byte(Object instance, long offset, byte value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setByte(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_boolean(Object instance, long offset, boolean value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setBoolean(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_short(Object instance, long offset, short value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setShort(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_char(Object instance, long offset, char value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setChar(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_int(Object instance, long offset, int value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setInt(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_float(Object instance, long offset, float value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setFloat(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_long(Object instance, long offset, long value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setLong(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void set_double(Object instance, long offset, double value) {
        try {
            this.objectField(instance.getClass(), (int)offset).setDouble(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final synchronized void setObject(Object instance, long offset, Object value) {
        try {
            this.objectField(instance.getClass(), (int)offset).set(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public final void set_byteInBytes(byte[] bytes, int index, byte value) {
        XArrays.set_byteInBytes(bytes, index, value);
    }

    @Override
    public final void set_booleanInBytes(byte[] bytes, int index, boolean value) {
        XArrays.set_booleanInBytes(bytes, index, value);
    }

    @Override
    public final void set_shortInBytes(byte[] bytes, int index, short value) {
        XArrays.set_shortInBytes(bytes, index, XMemory.isBigEndianNativeOrder() ? Short.reverseBytes(value) : value);
    }

    @Override
    public final void set_charInBytes(byte[] bytes, int index, char value) {
        XArrays.set_charInBytes(bytes, index, XMemory.isBigEndianNativeOrder() ? Character.reverseBytes(value) : value);
    }

    @Override
    public final void set_intInBytes(byte[] bytes, int index, int value) {
        XArrays.set_intInBytes(bytes, index, XMemory.isBigEndianNativeOrder() ? Integer.reverseBytes(value) : value);
    }

    @Override
    public final void set_floatInBytes(byte[] bytes, int index, float value) {
        this.set_intInBytes(bytes, index, Float.floatToRawIntBits(value));
    }

    @Override
    public final void set_longInBytes(byte[] bytes, int index, long value) {
        XArrays.set_longInBytes(bytes, index, XMemory.isBigEndianNativeOrder() ? Long.reverseBytes(value) : value);
    }

    @Override
    public final void set_doubleInBytes(byte[] bytes, int index, double value) {
        this.set_longInBytes(bytes, index, Double.doubleToRawLongBits(value));
    }

    @Override
    public final synchronized void copyRange(long sourceAddress, long targetAddress, long length) {
        int intLength = X.checkArrayRange(length);
        int sourcePosition = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int targetPosition = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int sourceBound = MemoryAccessorGeneric.unpackBufferLimit(sourceAddress);
        int targetBound = MemoryAccessorGeneric.unpackBufferLimit(targetAddress);
        ByteBuffer sourceBuffer = this.getBuffer(sourceAddress);
        ByteBuffer targetBuffer = this.getBuffer(targetAddress);
        int sourceLimit = MemoryAccessorGeneric.determineActualCopyLimit(sourceBound, sourceBuffer);
        int targetLimit = MemoryAccessorGeneric.determineActualCopyLimit(targetBound, targetBuffer);
        XArrays.validateRange0toUpperBound(sourceLimit, sourcePosition, intLength);
        XArrays.validateRange0toUpperBound(targetLimit, targetPosition, intLength);
        if (sourceBuffer == targetBuffer) {
            this.copyRangeSameBuffer(sourcePosition, targetPosition, sourceLimit, targetLimit, intLength, sourceBuffer);
            return;
        }
        long sourceCurrentPosLim = XMemory.getPositionLimit(sourceBuffer);
        long targetCurrentPosLim = XMemory.getPositionLimit(targetBuffer);
        XMemory.setPositionLimit(sourceBuffer, sourcePosition, sourcePosition + intLength);
        XMemory.setPositionLimit(targetBuffer, targetPosition, targetPosition + intLength);
        targetBuffer.put(sourceBuffer);
        XMemory.setPositionLimit(sourceBuffer, sourceCurrentPosLim);
        XMemory.setPositionLimit(targetBuffer, targetCurrentPosLim);
    }

    private void copyRangeSameBuffer(int sourcePosition, int targetPosition, int sourceLimit, int targetLimit, int intLength, ByteBuffer sameBuffer) {
        long currentPosLim = XMemory.getPositionLimit(sameBuffer);
        XMemory.setPositionLimit(sameBuffer, sourcePosition, sourcePosition + intLength);
        ByteBuffer slice = sameBuffer.slice().order(sameBuffer.order());
        XMemory.setPositionLimit(sameBuffer, targetPosition, targetPosition + intLength);
        sameBuffer.put(slice);
        XMemory.setPositionLimit(sameBuffer, currentPosLim);
    }

    private static int determineActualCopyLimit(int definedLimit, ByteBuffer bb) {
        return definedLimit >= 0 ? definedLimit : bb.capacity();
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, byte[] target) {
        int sourcePosition = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int sourceBound = MemoryAccessorGeneric.unpackBufferLimit(sourceAddress);
        ByteBuffer sourceBuffer = this.getBuffer(sourceAddress);
        int sourceLimit = MemoryAccessorGeneric.determineActualCopyLimit(sourceBound, sourceBuffer);
        XArrays.validateRange0toUpperBound(sourceLimit, sourcePosition, target.length);
        long sourceCurrentPosLim = XMemory.getPositionLimit(sourceBuffer);
        XMemory.setPositionLimit(sourceBuffer, sourcePosition, sourcePosition + target.length);
        sourceBuffer.get(target);
        XMemory.setPositionLimit(sourceBuffer, sourceCurrentPosLim);
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, boolean[] target) {
        ByteBuffer buffer = this.getBuffer(sourceAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int i = 0;
        while (i < target.length) {
            target[i] = XTypes.to_boolean(buffer.get(position + i));
            ++i;
        }
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, short[] target) {
        ByteBuffer buffer = this.getBuffer(sourceAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int i = 0;
        while (i < target.length) {
            target[i] = buffer.getShort(position + i * 2);
            ++i;
        }
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, char[] target) {
        ByteBuffer buffer = this.getBuffer(sourceAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int i = 0;
        while (i < target.length) {
            target[i] = buffer.getChar(position + i * 2);
            ++i;
        }
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, int[] target) {
        ByteBuffer buffer = this.getBuffer(sourceAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int i = 0;
        while (i < target.length) {
            target[i] = buffer.getInt(position + i * 4);
            ++i;
        }
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, float[] target) {
        ByteBuffer buffer = this.getBuffer(sourceAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int i = 0;
        while (i < target.length) {
            target[i] = buffer.getFloat(position + i * 4);
            ++i;
        }
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, long[] target) {
        ByteBuffer buffer = this.getBuffer(sourceAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int i = 0;
        while (i < target.length) {
            target[i] = buffer.getLong(position + i * 8);
            ++i;
        }
    }

    @Override
    public final synchronized void copyRangeToArray(long sourceAddress, double[] target) {
        ByteBuffer buffer = this.getBuffer(sourceAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(sourceAddress);
        int i = 0;
        while (i < target.length) {
            target[i] = buffer.getDouble(position + i * 8);
            ++i;
        }
    }

    @Override
    public final synchronized void copyArrayToAddress(byte[] array, long targetAddress) {
        int targetPosition = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int targetBound = MemoryAccessorGeneric.unpackBufferLimit(targetAddress);
        ByteBuffer targetBuffer = this.getBuffer(targetAddress);
        int targetLimit = MemoryAccessorGeneric.determineActualCopyLimit(targetBound, targetBuffer);
        XArrays.validateRange0toUpperBound(targetLimit, targetPosition, array.length);
        long targetCurrentPosLim = XMemory.getPositionLimit(targetBuffer);
        XMemory.setPositionLimit(targetBuffer, targetPosition, targetPosition + array.length);
        targetBuffer.put(array);
        XMemory.setPositionLimit(targetBuffer, targetCurrentPosLim);
    }

    @Override
    public final synchronized void copyArrayToAddress(boolean[] array, long targetAddress) {
        ByteBuffer buffer = this.getBuffer(targetAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int i = 0;
        while (i < array.length) {
            buffer.put(position + i, XTypes.to_byte(array[i]));
            ++i;
        }
    }

    @Override
    public final synchronized void copyArrayToAddress(short[] array, long targetAddress) {
        ByteBuffer buffer = this.getBuffer(targetAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int i = 0;
        while (i < array.length) {
            buffer.putShort(position + i * 2, array[i]);
            ++i;
        }
    }

    @Override
    public final synchronized void copyArrayToAddress(char[] array, long targetAddress) {
        ByteBuffer buffer = this.getBuffer(targetAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int i = 0;
        while (i < array.length) {
            buffer.putChar(position + i * 2, array[i]);
            ++i;
        }
    }

    @Override
    public final synchronized void copyArrayToAddress(int[] array, long targetAddress) {
        ByteBuffer buffer = this.getBuffer(targetAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int i = 0;
        while (i < array.length) {
            buffer.putInt(position + i * 4, array[i]);
            ++i;
        }
    }

    @Override
    public final synchronized void copyArrayToAddress(float[] array, long targetAddress) {
        ByteBuffer buffer = this.getBuffer(targetAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int i = 0;
        while (i < array.length) {
            buffer.putFloat(position + i * 4, array[i]);
            ++i;
        }
    }

    @Override
    public final synchronized void copyArrayToAddress(long[] array, long targetAddress) {
        ByteBuffer buffer = this.getBuffer(targetAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int i = 0;
        while (i < array.length) {
            buffer.putLong(position + i * 8, array[i]);
            ++i;
        }
    }

    @Override
    public final synchronized void copyArrayToAddress(double[] array, long targetAddress) {
        ByteBuffer buffer = this.getBuffer(targetAddress);
        int position = MemoryAccessorGeneric.unpackBufferPosition(targetAddress);
        int i = 0;
        while (i < array.length) {
            buffer.putDouble(position + i * 8, array[i]);
            ++i;
        }
    }

    @Override
    public final synchronized long objectFieldOffset(Field field) {
        return this.objectFieldOffset(field.getDeclaringClass(), field);
    }

    public static final Class<?> determineMostSpecificDeclaringClass(Field[] fields) {
        if (XArrays.hasNoContent(fields)) {
            return null;
        }
        Class<?> c = fields[0].getDeclaringClass();
        int i = 1;
        while (i < fields.length) {
            if (fields[i].getDeclaringClass() != c && c.isAssignableFrom(fields[i].getDeclaringClass())) {
                c = fields[i].getDeclaringClass();
            }
            ++i;
        }
        return c;
    }

    @Override
    public final synchronized long[] objectFieldOffsets(Field ... fields) {
        Class<?> mostSpecificDeclaringClass = MemoryAccessorGeneric.determineMostSpecificDeclaringClass(fields);
        return this.objectFieldOffsets(mostSpecificDeclaringClass, fields);
    }

    @Override
    public final synchronized long objectFieldOffset(Class<?> objectClass, Field field) {
        Field[] objectFields = this.ensureRegisteredObjectFields(objectClass);
        return MemoryAccessorGeneric.objectFieldOffset(objectFields, field);
    }

    private Field[] ensureRegisteredObjectFields(Class<?> objectClass) {
        Field[] objectFields = this.objectFieldsRegistry.get(objectClass);
        if (objectFields != null) {
            return objectFields;
        }
        return this.registerCollectedObjectFields(objectClass);
    }

    private Field[] ensureRegisteredObjectFields(Class<?> objectClass, Field ... fields) {
        Object[] objectFields = this.objectFieldsRegistry.get(objectClass);
        if (objectFields != null) {
            if (fields != null && !Arrays.equals(fields, objectFields)) {
                throw new MemoryException("Inconsistent object class fields");
            }
            return objectFields;
        }
        return fields != null ? this.registerObjectFields(objectClass, fields) : this.registerCollectedObjectFields(objectClass);
    }

    private Field[] registerCollectedObjectFields(Class<?> objectClass) {
        Field[] fields = XReflect.collectInstanceFields(objectClass);
        this.registerObjectFields(objectClass, fields);
        return fields;
    }

    private Field[] registerObjectFields(Class<?> objectClass, Field[] fields) {
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            XReflect.setAccessible(objectClass, field);
            ++n2;
        }
        if (!this.objectFieldsRegistry.add(objectClass, fields)) {
            throw new MemoryException("Object fields already registered for " + objectClass);
        }
        return fields;
    }

    private Field objectField(Class<?> c, int offset) {
        Field[] objectFields = this.objectFieldsRegistry.get(c);
        MemoryAccessorGeneric.validateObjectFieldsNotNull(objectFields, c);
        if (offset >= 0 && offset < objectFields.length) {
            return objectFields[offset];
        }
        throw MemoryAccessorGeneric.createInvalidOffsetException(objectFields, c, offset);
    }

    private static void validateObjectFieldsNotNull(Field[] objectFields, Class<?> c) {
        if (objectFields == null) {
            throw new MemoryException("No object fields registered for " + c + ".");
        }
    }

    private static RuntimeException createInvalidOffsetException(Field[] objectFields, Class<?> c, int offset) {
        return new MemoryException("Unknown object field offset " + offset + " for " + c + ".");
    }

    static final long objectFieldOffset(Field[] objectFields, Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        String fieldName = field.getName();
        int i = 0;
        while (i < objectFields.length) {
            if (objectFields[i].getDeclaringClass() == declaringClass && objectFields[i].getName().equals(fieldName)) {
                return i;
            }
            ++i;
        }
        throw new MemoryException("Inconsistent object fields registration for " + declaringClass.getName() + "#" + fieldName);
    }

    @Override
    public final synchronized long[] objectFieldOffsets(Class<?> objectClass, Field ... fields) {
        Field[] objectFields = this.ensureRegisteredObjectFields(objectClass);
        long[] offsets = new long[fields.length];
        int i = 0;
        while (i < fields.length) {
            if (Modifier.isStatic(fields[i].getModifiers())) {
                throw new IllegalArgumentException("Not an object field: " + fields[i]);
            }
            offsets[i] = MemoryAccessorGeneric.objectFieldOffset(objectFields, fields[i]);
            ++i;
        }
        return offsets;
    }

    @Override
    public final synchronized void ensureClassInitialized(Class<?> c) {
        this.ensureRegisteredObjectFields(c);
    }

    @Override
    public final synchronized void ensureClassInitialized(Class<?> c, Iterable<Field> usedFields) {
        Field[] fields = BulkList.New(usedFields).toArray(Field.class);
        this.ensureRegisteredObjectFields(c, fields);
    }

    @Override
    public final synchronized <T> T instantiateBlank(Class<T> c) throws InstantiationRuntimeException {
        return this.defaultInstantiator.instantiate(c);
    }

    @Override
    public final synchronized MemoryStatistics createHeapMemoryStatistics() {
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        return MemoryStatistics.New(max, total, used);
    }

    @Override
    public final synchronized MemoryStatistics createNonHeapMemoryStatistics() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final synchronized MemoryAccessor toReversing() {
        return this.reversing;
    }
}

