/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.meta;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Supplier;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.BulkList;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingTable;
import one.microstream.concurrency.XThreads;
import one.microstream.io.XIO;
import one.microstream.memory.XMemory;
import one.microstream.reflect.XReflect;
import one.microstream.time.XTime;
import one.microstream.typing.KeyValue;

public final class XDebug {
    private static final transient int LINE_BUFFER_INITIAL_SIZE = 256;
    private static final transient int SOURCE_POSITION_PADDING = 64;
    private static final transient char[] TIME_SEPERATOR = new char[]{'>', ' '};

    public static String formatCommonTime(Date timestamp) {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(timestamp);
    }

    public static String formatNanoTime(long timestamp) {
        return new DecimalFormat("00,000,000,000").format(timestamp);
    }

    public static final void println(String s) {
        XDebug.println(s, 1);
    }

    public static final void print(String s) {
        XDebug.print(s, 1);
    }

    public static final void println(String s, int stackTraceCut) {
        StackTraceElement e = XThreads.getStackTraceElement(2 + stackTraceCut);
        System.out.println(XDebug.formatString(s, e));
    }

    public static final void print(String s, int stackTraceCut) {
        StackTraceElement e = XThreads.getStackTraceElement(2 + stackTraceCut);
        System.out.print(XDebug.formatString(s, e));
    }

    public static String formatString(String s, StackTraceElement e) {
        return VarString.New(256).padRight(XDebug.toMethodLink(e), 64, ' ').add(XDebug.formatCommonTime(XTime.now())).add(TIME_SEPERATOR).add(s).toString();
    }

    private static String toMethodLink(StackTraceElement e) {
        String s = e.toString();
        return s.substring(s.lastIndexOf(46, s.lastIndexOf(46) - 1));
    }

    public static final void printCollection(XGettingCollection<?> collection, String start, String separator, String end, Integer limit) {
        final char[] sepp = separator != null ? XChars.readChars(separator) : null;
        final VarString vs = VarString.New();
        if (start != null) {
            vs.add(start);
        }
        int vsOldLength = vs.length();
        if (limit == null) {
            collection.iterate(e -> {
                vs.add(e);
                if (sepp != null) {
                    vs.add(sepp);
                }
            });
        } else {
            collection.iterate(new Consumer<Object>(limit){
                private int lim;
                {
                    this.lim = n;
                }

                @Override
                public void accept(Object e) {
                    if (--this.lim <= 0) {
                        throw X.BREAK();
                    }
                    vs.add(e);
                    if (sepp != null) {
                        vs.add(sepp);
                    }
                }
            });
        }
        if (sepp != null && vs.length() > vsOldLength) {
            vs.deleteLast(sepp.length);
        }
        if (end != null) {
            vs.add(end);
        }
        System.out.println(vs.toString());
        System.out.flush();
    }

    public static final VarString assembleTable(final VarString vs, XGettingTable<?, ?> collection, String start, final String mapper, String separator, String end, Integer limit) {
        char[] sepp;
        char[] cArray = sepp = separator != null ? XChars.readChars(separator) : null;
        if (start != null) {
            vs.add(start);
        }
        int vcOldLength = vs.length();
        if (limit == null) {
            collection.iterate(kv -> {
                vs.add(kv.key());
                if (mapper != null) {
                    vs.add(mapper);
                }
                vs.add(kv.value());
                if (sepp != null) {
                    vs.add(sepp);
                }
            });
        } else {
            collection.iterate(new Consumer<KeyValue<?, ?>>(limit){
                private int lim;
                {
                    this.lim = n;
                }

                @Override
                public void accept(KeyValue<?, ?> e) {
                    if (--this.lim <= 0) {
                        throw X.BREAK();
                    }
                    vs.add(e.key());
                    if (mapper != null) {
                        vs.add(mapper);
                    }
                    vs.add(e.value());
                    if (sepp != null) {
                        vs.add(sepp);
                    }
                }
            });
        }
        if (sepp != null && vs.length() > vcOldLength) {
            vs.deleteLast(sepp.length);
        }
        if (end != null) {
            vs.add(end);
        }
        return vs;
    }

    public static final void printTable(XGettingTable<?, ?> collection, String start, String mapper, String separator, String end, Integer limit) {
        System.out.println(XDebug.assembleTable(VarString.New(), collection, start, mapper, separator, end, limit));
    }

    public static final void printArray(Object[] array, String start, String separator, String end, Integer limit) {
        char[] sepp = separator != null ? XChars.readChars(separator) : null;
        VarString vc = VarString.New();
        if (start != null) {
            vc.add(start);
        }
        int size = limit == null ? array.length : Math.min(array.length, limit);
        int i = 0;
        while (i < size) {
            vc.add(array[i]);
            if (sepp != null) {
                vc.add(sepp);
            }
            ++i;
        }
        if (size > 1 && sepp != null) {
            vc.deleteLast(sepp.length);
        }
        if (end != null) {
            vc.add(end);
        }
        System.out.println(vc.toString());
        System.out.flush();
    }

    public static <T> T printTime(Supplier<? extends T> logic) {
        return XDebug.internalPrintTime(logic, null, 1, 0, 0);
    }

    public static <T> T printTime(Supplier<? extends T> logic, String name) {
        return XDebug.internalPrintTime(logic, name, 1, 0, 0);
    }

    public static <T> T printTime(Supplier<? extends T> logic, int stackTraceDepth) {
        return XDebug.internalPrintTime(logic, null, 1, 2, stackTraceDepth);
    }

    public static <T> T printTime(Supplier<? extends T> logic, int stackTraceDepthStart, int stackTraceDepth) {
        return XDebug.internalPrintTime(logic, null, 1, stackTraceDepthStart + 1, stackTraceDepth);
    }

    public static <T> T printTime(Supplier<? extends T> logic, String name, int stackTraceDepth) {
        return XDebug.internalPrintTime(logic, name, 1, 2, stackTraceDepth);
    }

    public static <T> T printTime(Supplier<? extends T> logic, String name, int stackTraceDepthStart, int stackTraceDepth) {
        return XDebug.internalPrintTime(logic, name, 1, stackTraceDepthStart + 1, stackTraceDepth);
    }

    public static <T> T internalPrintTime(Supplier<? extends T> logic, String name, int stackTraceCallLevel, int stackTraceDepthStart, int stackTraceDepth) {
        long tStart = System.nanoTime();
        T result = logic.get();
        long tStop = System.nanoTime();
        XDebug.simplePrint(name, stackTraceCallLevel + 1, stackTraceDepthStart + 1, stackTraceDepth, tStart, tStop);
        return result;
    }

    public static void printTime(Runnable logic) {
        XDebug.internalPrintTime(logic, null, 1, 0, 0);
    }

    public static void printTime(Runnable logic, String name) {
        XDebug.internalPrintTime(logic, name, 1, 0, 0);
    }

    public static void printTime(Runnable logic, int stackTraceDepth) {
        XDebug.internalPrintTime(logic, null, 1, 2, stackTraceDepth);
    }

    public static void printTime(Runnable logic, int stackTraceDepthStart, int stackTraceDepth) {
        XDebug.internalPrintTime(logic, null, 1, stackTraceDepthStart + 1, stackTraceDepth);
    }

    public static void printTime(Runnable logic, String name, int stackTraceDepth) {
        XDebug.internalPrintTime(logic, name, 1, 2, stackTraceDepth);
    }

    public static void printTime(Runnable logic, String name, int stackTraceDepthStart, int stackTraceDepth) {
        XDebug.internalPrintTime(logic, name, 1, stackTraceDepthStart + 1, stackTraceDepth);
    }

    private static void internalPrintTime(Runnable logic, String name, int stackTraceCallLevel, int stackTraceDepthStart, int stackTraceDepth) {
        long tStart = System.nanoTime();
        logic.run();
        long tStop = System.nanoTime();
        XDebug.simplePrint(name, stackTraceCallLevel + 1, stackTraceDepthStart + 1, stackTraceDepth, tStart, tStop);
    }

    private static void simplePrint(String name, int stackTraceCallLevel, int stackTraceDepthStart, int stackTraceDepth, long tStart, long tStop) {
        StackTraceElement[] stacktrace = new Throwable().getStackTrace();
        StackTraceElement callLevelElement = stacktrace[stackTraceCallLevel + 1];
        VarString vs = VarString.New(XDebug.toMethodLink(callLevelElement)).blank();
        vs.add(new DecimalFormat("00,000,000,000").format(tStop - tStart)).add(" nanoseconds");
        if (name != null) {
            vs.add(" for ").add(name);
        }
        if (stackTraceDepth > 0) {
            vs.lf().add("Stacktrace: ");
            int stackTraceLimit = Math.min(stackTraceDepthStart + stackTraceDepth + 1, stacktrace.length);
            int i = stackTraceDepthStart + 1;
            while (i < stackTraceLimit) {
                vs.lf().add(XDebug.toMethodLink(stacktrace[i]));
                ++i;
            }
            vs.lf().add("/ Stacktrace");
        }
        System.out.println(vs);
    }

    public static void resetDirecory(Path target, Path source, boolean output) throws IOException {
        XDebug.deleteAllFiles(target, output);
        XDebug.copyFile(source, source, target);
    }

    public static final void deleteAllFiles(Path directory) {
        XDebug.deleteAllFiles(directory, true);
    }

    public static final void deleteAllFiles(Path directory, boolean output) {
        if (!XIO.unchecked.exists(directory)) {
            return;
        }
        BulkList<Path> entries = XIO.unchecked.listEntries(directory, BulkList.New());
        for (Path f : entries) {
            if (XIO.unchecked.isDirectory(f)) {
                XDebug.deleteAllFiles(f, output);
            }
            try {
                if (output) {
                    XDebug.println("Deleting " + f.toAbsolutePath());
                }
                Files.deleteIfExists(f);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot delete file: " + f, e);
            }
        }
    }

    public static void copyFile(Path sourceRoot, Path subject, Path targetRoot) throws IOException {
        if (XIO.unchecked.isDirectory(subject)) {
            XDebug.copyDirectory(sourceRoot, subject, targetRoot);
        } else {
            XDebug.copyActualFile(sourceRoot, subject, targetRoot);
        }
    }

    public static void copyDirectory(Path sourceRoot, Path subject, Path targetRoot) throws IOException {
        BulkList<Path> entries = XIO.unchecked.listEntries(targetRoot, BulkList.New());
        for (Path entry : entries) {
            XDebug.copyFile(sourceRoot, entry, targetRoot);
        }
    }

    public static void copyActualFile(Path sourceRoot, Path subject, Path targetRoot) throws IOException {
        String sourceRootPath = sourceRoot.toAbsolutePath().normalize().toString();
        String subjectPath = subject.toAbsolutePath().normalize().toString();
        Path sourceFile = subject;
        Path targetFile = XIO.Path(targetRoot, subjectPath.substring(sourceRootPath.length()));
        XIO.copyFile(sourceFile, targetFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static byte[] copyDirectByteBufferRange(ByteBuffer bb, int offset, int length) {
        long address = XMemory.getDirectByteBufferAddress(bb);
        byte[] data = new byte[length];
        XMemory.copyRangeToArray(address + (long)XArrays.validateArrayIndex(length, offset), data);
        return data;
    }

    public static byte[] copyDirectByteBuffer(ByteBuffer bb) {
        return XDebug.copyDirectByteBufferRange(bb, bb.position(), bb.limit());
    }

    public static void printDirectByteBuffer(ByteBuffer bb) {
        XDebug.println(Arrays.toString(XDebug.copyDirectByteBuffer(bb)));
    }

    public static void printInstanceSizeInfo(Class<?> c) {
        System.out.println(String.valueOf(XMemory.byteSizeInstance(c)) + " byte size of one instance of " + c.getName());
        XMemory.ensureClassInitialized(c);
        XReflect.iterateDeclaredFieldsUpwards(c, f -> {
            if (!Modifier.isStatic(f.getModifiers())) {
                System.out.println(String.valueOf(XMemory.objectFieldOffset(f)) + ": " + f.getName());
            }
        });
        System.out.println(String.valueOf(XMemory.byteSizeObjectHeader(c)) + " Object header size (" + XMemory.byteSizeArrayObject(0L) + " array header size)." + " Reference byte size = " + XMemory.byteSizeReference() + ".");
    }

    private XDebug() {
        throw new UnsupportedOperationException();
    }
}

