/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.time;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class XTime {
    private static final int MIN_MONTH = 1;
    private static final int MIN_DAY_IN_MONTH = 1;
    private static final int MIN_HOUR = 0;
    private static final int MIN_MINUTE = 0;
    private static final int MIN_SECOND = 0;
    private static final int MIN_MILLI = 0;
    private static final int MAX_MONTH = 12;
    private static final int MAX_DAY_IN_MONTH = 31;
    private static final int MAX_HOUR = 23;
    private static final int MAX_MINUTE = 59;
    private static final int MAX_SECOND = 59;
    private static final int MAX_MILLI = 999;

    public static final Date now() {
        return new Date();
    }

    public static final Date timestamp(int year, int month, int day, int hour, int minute, int second, int milliseconds) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid day: " + day);
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Invalid hour: " + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Invalid minute: " + minute);
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Invalid second: " + second);
        }
        if (milliseconds < 0 || milliseconds > 999) {
            throw new IllegalArgumentException("Invalid milliseconds: " + milliseconds);
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, milliseconds);
        return c.getTime();
    }

    public static final Date timestamp(int year, int month, int day, int hour, int minute, int second) {
        return XTime.timestamp(year, month, day, hour, minute, second, 0);
    }

    public static final Date date(int year, int month, int day) {
        return XTime.timestamp(year, month, day);
    }

    public static final Date timestamp(int year, int month, int day) {
        return XTime.timestamp(year, month, day, 0, 0, 0, 0);
    }

    public static final GregorianCalendar asGregCal(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return gc;
    }

    public static final GregorianCalendar asGregCal(long timestamp) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(timestamp);
        return gc;
    }

    public static final int currentYear() {
        return Calendar.getInstance().get(1);
    }

    public static final long calculateNanoTimeBudgetBound(long nanoTimeBudget) {
        long timeBudgetBound = System.nanoTime() + nanoTimeBudget;
        return timeBudgetBound >= 0L ? timeBudgetBound : Long.MAX_VALUE;
    }

    private XTime() {
        throw new UnsupportedOperationException();
    }
}

