/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import one.microstream.chars.XChars;

public interface BundleInfo {
    public String name();

    public Version version();

    public String vendor();

    public String builtBy();

    public Instant builtAt();

    public static BundleInfo LoadBase() {
        return BundleInfo.Load("microstream-base");
    }

    public static BundleInfo Load(String bundleName) {
        return new Provider.ManifestAndMavenBased(XChars.notEmpty(bundleName)).provideBundleInfo();
    }

    public static class Default
    implements BundleInfo {
        private final String name;
        private final Version version;
        private final String vendor;
        private final String builtBy;
        private final Instant builtAt;

        Default(String name, Version version, String vendor, String builtBy, Instant builtAt) {
            this.name = name;
            this.version = version;
            this.vendor = vendor;
            this.builtBy = builtBy;
            this.builtAt = builtAt;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Version version() {
            return this.version;
        }

        @Override
        public String vendor() {
            return this.vendor;
        }

        @Override
        public String builtBy() {
            return this.builtBy;
        }

        @Override
        public Instant builtAt() {
            return this.builtAt;
        }

        public String toString() {
            return "BundleInfo [name=" + this.name + ", version=" + this.version + ", vendor=" + this.vendor + ", builtBy=" + this.builtBy + ", builtAt=" + this.builtAt + "]";
        }
    }

    public static interface Provider {
        public BundleInfo provideBundleInfo();

        public static class ManifestAndMavenBased
        implements Provider {
            private final String bundleName;

            ManifestAndMavenBased(String bundleName) {
                this.bundleName = bundleName;
            }

            @Override
            public BundleInfo provideBundleInfo() {
                try {
                    Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
                    while (resources.hasMoreElements()) {
                        Manifest manifest = this.loadManifest(resources.nextElement());
                        Attributes attributes = manifest.getMainAttributes();
                        String name = attributes.getValue("Bundle-Name");
                        if (!this.bundleName.equals(name)) continue;
                        Properties pomProperties = this.loadPomProperties();
                        Version version = new Version.Parser.MavenVersionParser().parse(pomProperties.getProperty("version"));
                        String vendor = attributes.getValue("Bundle-Vendor");
                        String builtBy = attributes.getValue("built-by");
                        Instant builtAt = Instant.ofEpochMilli(Long.parseLong(attributes.getValue("Bnd-LastModified")));
                        return new Default(name, version, vendor, builtBy, builtAt);
                    }
                    Properties pomProperties = this.loadPomProperties();
                    String versionString = pomProperties.getProperty("version");
                    if (versionString != null) {
                        Version version = new Version.Parser.MavenVersionParser().parse(versionString);
                        return new Default(this.bundleName, version, "MicroStream", "MicroStream", Instant.now());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }

            private Manifest loadManifest(URL url) throws IOException {
                Throwable throwable = null;
                Object var3_4 = null;
                try (InputStream inputStream = url.openStream();){
                    return new Manifest(inputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }

            private Properties loadPomProperties() throws IOException {
                URL pomPropertiesUrl = Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/one.microstream/" + this.bundleName + "/pom.properties");
                Properties pomProperties = new Properties();
                Throwable throwable = null;
                Object var4_5 = null;
                try (InputStreamReader pomReader = new InputStreamReader(pomPropertiesUrl.openStream(), StandardCharsets.UTF_8);){
                    pomProperties.load(pomReader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return pomProperties;
            }
        }
    }

    public static interface Version {
        public String value();

        public Integer majorVersion();

        public Integer minorVersion();

        public Integer incrementalVersion();

        public Integer buildNumber();

        public String qualifier();

        default public boolean isSnapshot() {
            return this.value().endsWith("-SNAPSHOT");
        }

        public static class Default
        implements Version {
            private final String value;
            private final Integer majorVersion;
            private final Integer minorVersion;
            private final Integer incrementalVersion;
            private final Integer buildNumber;
            private final String qualifier;

            public Default(String value, Integer majorVersion, Integer minorVersion, Integer incrementalVersion, Integer buildNumber, String qualifier) {
                this.value = value;
                this.majorVersion = majorVersion;
                this.minorVersion = minorVersion;
                this.incrementalVersion = incrementalVersion;
                this.buildNumber = buildNumber;
                this.qualifier = qualifier;
            }

            @Override
            public String value() {
                return this.value;
            }

            @Override
            public Integer majorVersion() {
                return this.majorVersion;
            }

            @Override
            public Integer minorVersion() {
                return this.minorVersion;
            }

            @Override
            public Integer incrementalVersion() {
                return this.incrementalVersion;
            }

            @Override
            public Integer buildNumber() {
                return this.buildNumber;
            }

            @Override
            public String qualifier() {
                return this.qualifier;
            }

            public String toString() {
                return this.value;
            }
        }

        public static interface Parser {
            public Version parse(String var1);

            public static class MavenVersionParser
            implements Parser {
                MavenVersionParser() {
                }

                @Override
                public Version parse(String value) {
                    String part1;
                    Integer majorVersion = null;
                    Integer minorVersion = null;
                    Integer incrementalVersion = null;
                    Integer buildNumber = null;
                    String qualifier = null;
                    String part2 = null;
                    int dashIndex = value.indexOf(45);
                    if (dashIndex < 0) {
                        part1 = value;
                    } else {
                        part1 = value.substring(0, dashIndex);
                        part2 = value.substring(dashIndex + 1);
                    }
                    if (part2 != null) {
                        if (part2.length() == 1 || !part2.startsWith("0")) {
                            buildNumber = MavenVersionParser.tryParseInt(part2);
                            if (buildNumber == null) {
                                qualifier = part2;
                            }
                        } else {
                            qualifier = part2;
                        }
                    }
                    if (!part1.contains(".") && !part1.startsWith("0")) {
                        majorVersion = MavenVersionParser.tryParseInt(part1);
                        if (majorVersion == null) {
                            qualifier = value;
                            buildNumber = null;
                        }
                    } else {
                        boolean fallback = false;
                        StringTokenizer tokenizer = new StringTokenizer(part1, ".");
                        if (tokenizer.hasMoreTokens()) {
                            majorVersion = MavenVersionParser.getNextIntegerToken(tokenizer);
                            if (majorVersion == null) {
                                fallback = true;
                            }
                        } else {
                            fallback = true;
                        }
                        if (tokenizer.hasMoreTokens() && (minorVersion = MavenVersionParser.getNextIntegerToken(tokenizer)) == null) {
                            fallback = true;
                        }
                        if (tokenizer.hasMoreTokens() && (incrementalVersion = MavenVersionParser.getNextIntegerToken(tokenizer)) == null) {
                            fallback = true;
                        }
                        if (tokenizer.hasMoreTokens()) {
                            qualifier = tokenizer.nextToken();
                            fallback = MavenVersionParser.isDigits(qualifier);
                        }
                        if (part1.contains("..") || part1.startsWith(".") || part1.endsWith(".")) {
                            fallback = true;
                        }
                        if (fallback) {
                            qualifier = value;
                            majorVersion = null;
                            minorVersion = null;
                            incrementalVersion = null;
                            buildNumber = null;
                        }
                    }
                    return new Default(value, majorVersion, minorVersion, incrementalVersion, buildNumber, qualifier);
                }

                private static Integer getNextIntegerToken(StringTokenizer tok) {
                    return MavenVersionParser.tryParseInt(tok.nextToken());
                }

                private static Integer tryParseInt(String s) {
                    long longValue;
                    block4: {
                        if (!MavenVersionParser.isDigits(s)) {
                            return null;
                        }
                        try {
                            longValue = Long.parseLong(s);
                            if (longValue <= Integer.MAX_VALUE) break block4;
                            return null;
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                    return (int)longValue;
                }

                private static boolean isDigits(CharSequence cs) {
                    if (XChars.isEmpty(cs)) {
                        return false;
                    }
                    int length = cs.length();
                    int i = 0;
                    while (i < length) {
                        if (!Character.isDigit(cs.charAt(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
        }
    }
}

