/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.config;

import one.microstream.X;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XImmutableTable;
import one.microstream.util.config.AbstractConfig;
import one.microstream.util.config.ConfigFile;
import one.microstream.util.config.RootConfig;

public final class SubConfig
extends AbstractConfig {
    private final RootConfig parent;
    private XImmutableTable<String, String> overrideTable;
    private XImmutableTable<String, String> coalescedTable;

    SubConfig(RootConfig parent, String identifier, XGettingMap<String, String> customVariables, Character variableStarter, Character variableTerminator) {
        super(identifier, customVariables, variableStarter, variableTerminator);
        this.parent = X.notNull(parent);
    }

    SubConfig(RootConfig parent, String identifier, XGettingMap<String, String> customVariables) {
        super(identifier, customVariables);
        this.parent = X.notNull(parent);
    }

    SubConfig(RootConfig parent, String identifier) {
        super(identifier);
        this.parent = X.notNull(parent);
    }

    final void updateFromParent() {
        this.updateOverrideTable(this.overrideTable);
    }

    public final SubConfig updateOverrides(EqHashTable<String, ConfigFile> configFiles) {
        this.configFiles.clear();
        this.updateFiles(configFiles);
        return this.updateOverrideTable(this.compileEntries());
    }

    final SubConfig updateOverrideTable(XGettingTable<String, String> konditionsjahrTable) {
        EqHashTable coalesced = EqHashTable.New();
        ((EqHashTable)coalesced.putAll(this.parent.table())).putAll(konditionsjahrTable);
        this.coalescedTable = coalesced.immure();
        this.overrideTable = konditionsjahrTable.immure();
        return this;
    }

    @Override
    public final XGettingTable<String, String> table() {
        if (this.coalescedTable == null) {
            this.updateFromParent();
        }
        return this.coalescedTable;
    }
}

