/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.traversing;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.ConstHashEnum;
import one.microstream.collections.ConstHashTable;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingMap;
import one.microstream.collections.types.XGettingSet;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XMap;
import one.microstream.collections.types.XReplacingBag;
import one.microstream.collections.types.XSet;
import one.microstream.collections.types.XTable;
import one.microstream.util.traversing.MutationListener;
import one.microstream.util.traversing.ObjectGraphTraverser;
import one.microstream.util.traversing.OpenAdressingMiniSet;
import one.microstream.util.traversing.TraversalAcceptor;
import one.microstream.util.traversing.TraversalFieldSelector;
import one.microstream.util.traversing.TraversalFilter;
import one.microstream.util.traversing.TraversalMode;
import one.microstream.util.traversing.TraversalMutator;
import one.microstream.util.traversing.TraversalPredicateFull;
import one.microstream.util.traversing.TraversalPredicateLeaf;
import one.microstream.util.traversing.TraversalPredicateNode;
import one.microstream.util.traversing.TraversalPredicateSkip;
import one.microstream.util.traversing.TraversalReferenceHandlerProvider;
import one.microstream.util.traversing.TraverserArray;
import one.microstream.util.traversing.TraverserCollectionOld;
import one.microstream.util.traversing.TraverserReflective;
import one.microstream.util.traversing.TraverserXCollectionNonReplacing;
import one.microstream.util.traversing.TraverserXCollectionReplacing;
import one.microstream.util.traversing.TraverserXMapNonReplacing;
import one.microstream.util.traversing.TraverserXMapReplacing;
import one.microstream.util.traversing.TypeTraverser;
import one.microstream.util.traversing.TypeTraverserProvider;

public interface ObjectGraphTraverserBuilder {
    public ObjectGraphTraverser buildObjectGraphTraverser();

    public TraversalFilter<TraversalPredicateSkip> skip();

    public TraversalFilter<TraversalPredicateNode> node();

    public TraversalFilter<TraversalPredicateLeaf> leaf();

    public TraversalFilter<TraversalPredicateFull> full();

    public XTable<Object, TypeTraverser<?>> traversersPerInstance();

    public XTable<Class<?>, TypeTraverser<?>> traversersPerConcreteType();

    public XTable<Class<?>, TypeTraverser<?>> traversersPerPolymorphType();

    public TraversalFieldSelector fieldSelector();

    public Predicate<? super Field> fieldPredicate();

    public Function<XGettingCollection<Object>, XSet<Object>> alreadyHandledProvider();

    public TypeTraverser.Creator typeTraverserCreator();

    public TraversalAcceptor acceptor();

    public Predicate<Object> acceptorPredicate();

    public Consumer<Object> acceptorLogic();

    public TraversalMutator mutator();

    public Predicate<Object> mutatorPredicate();

    public Function<Object, ?> mutatorLogic();

    public MutationListener mutationListener();

    public TraversalMode traversalMode();

    public TraversalReferenceHandlerProvider referenceHandlerProvider();

    public Object[] roots();

    public ObjectGraphTraverserBuilder fieldSelector(TraversalFieldSelector var1);

    public ObjectGraphTraverserBuilder fieldPredicate(Predicate<? super Field> var1);

    public ObjectGraphTraverserBuilder alreadyHandledProvider(Function<XGettingCollection<Object>, XSet<Object>> var1);

    public ObjectGraphTraverserBuilder typeTraverserCreator(TypeTraverser.Creator var1);

    public ObjectGraphTraverserBuilder acceptor(TraversalAcceptor var1);

    public ObjectGraphTraverserBuilder acceptorPredicate(Predicate<Object> var1);

    public ObjectGraphTraverserBuilder acceptorLogic(Consumer<Object> var1);

    public ObjectGraphTraverserBuilder mutator(TraversalMutator var1);

    public ObjectGraphTraverserBuilder mutatorPredicate(Predicate<Object> var1);

    public ObjectGraphTraverserBuilder mutatorLogic(Function<Object, Object> var1);

    public ObjectGraphTraverserBuilder mutationListener(MutationListener var1);

    public ObjectGraphTraverserBuilder traversalMode(TraversalMode var1);

    public ObjectGraphTraverserBuilder referenceHandlerProvider(TraversalReferenceHandlerProvider var1);

    public ObjectGraphTraverserBuilder roots(Object ... var1);

    default public ObjectGraphTraverserBuilder modeNode() {
        return this.traversalMode(new TraversalMode.Node());
    }

    default public ObjectGraphTraverserBuilder modeFull() {
        return this.traversalMode(new TraversalMode.Full());
    }

    default public ObjectGraphTraverserBuilder modeLeaf() {
        return this.traversalMode(new TraversalMode.Leaf());
    }

    default public ObjectGraphTraverserBuilder apply(Consumer<Object> logic) {
        return this.apply((Predicate<Object>)null, logic);
    }

    public ObjectGraphTraverserBuilder apply(Predicate<Object> var1, Consumer<Object> var2);

    public <T> ObjectGraphTraverserBuilder apply(Class<T> var1, Consumer<? super T> var2);

    default public ObjectGraphTraverserBuilder mutate(Function<Object, Object> logic) {
        return this.mutate((Predicate<Object>)null, logic);
    }

    public ObjectGraphTraverserBuilder mutate(Predicate<Object> var1, Function<Object, ?> var2);

    public <T> ObjectGraphTraverserBuilder mutate(Class<T> var1, Function<? super T, ?> var2);

    public ObjectGraphTraverserBuilder initializerLogic(Runnable var1);

    public Runnable initializerLogic();

    public ObjectGraphTraverserBuilder finalizerLogic(Runnable var1);

    public Runnable finalizerLogic();

    default public ObjectGraphTraverserBuilder root(Object root) {
        return this.roots(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> ObjectGraphTraverserBuilder registerTraverser(Object instance, TypeTraverser<T> traverser) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this;
        synchronized (objectGraphTraverserBuilder) {
            this.traversersPerInstance().add(instance, traverser);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> ObjectGraphTraverserBuilder registerTraverserForType(Class<? extends T> type, TypeTraverser<T> traverser) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this;
        synchronized (objectGraphTraverserBuilder) {
            this.traversersPerConcreteType().add(type, traverser);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> ObjectGraphTraverserBuilder registerTraverserForTypePolymorphic(Class<? extends T> type, TypeTraverser<T> traverser) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this;
        synchronized (objectGraphTraverserBuilder) {
            this.traversersPerPolymorphType().add(type, traverser);
        }
        return this;
    }

    public TraversalReferenceHandlerProvider provideReferenceHandlerProvider();

    public TraversalAcceptor provideAcceptor();

    public TraversalMutator provideMutator();

    public XGettingSet<Object> provideSkippedInstances();

    public Predicate<Object> predicateHandle();

    public ObjectGraphTraverserBuilder predicateHandle(Predicate<Object> var1);

    public static XGettingSet<Class<?>> defaultSkipTypesConcrete() {
        return ConstHashEnum.New(Byte.class, Boolean.class, Short.class, Character.class, Integer.class, Float.class, Long.class, Double.class, Instant.class, String.class, StringBuilder.class, StringBuffer.class, Class.class, Field.class, Method.class);
    }

    public static XGettingEnum<Class<?>> defaultSkipTypesPolymorphic() {
        return ConstHashEnum.New(BigInteger.class, BigDecimal.class, Date.class, File.class, Thread.class, OutputStream.class, InputStream.class, FileChannel.class, ByteBuffer.class, Throwable.class);
    }

    public static XGettingTable<Class<?>, TypeTraverser<?>> defaultPolymorphTypeTraversers() {
        return ConstHashTable.New(X.KeyValue(XMap.class, new TraverserXMapReplacing()), X.KeyValue(XGettingMap.class, new TraverserXMapNonReplacing()), X.KeyValue(XReplacingBag.class, new TraverserXCollectionReplacing()), X.KeyValue(XGettingCollection.class, new TraverserXCollectionNonReplacing()), X.KeyValue(Collection.class, new TraverserCollectionOld()), X.KeyValue(Object[].class, new TraverserArray()));
    }

    public static XGettingTable<Class<?>, TypeTraverser<?>> defaultConcreteTypeTraversers() {
        return ConstHashTable.New();
    }

    public static ObjectGraphTraverserBuilder New() {
        return new Default();
    }

    public static class Default
    implements ObjectGraphTraverserBuilder {
        private final TraversalFilter<TraversalPredicateSkip> skip = TraversalFilter.New(this);
        private final TraversalFilter<TraversalPredicateNode> node = TraversalFilter.New(this);
        private final TraversalFilter<TraversalPredicateLeaf> leaf = TraversalFilter.New(this);
        private final TraversalFilter<TraversalPredicateFull> full = TraversalFilter.New(this);
        private final HashTable<Object, TypeTraverser<?>> traversersPerInstance;
        private final HashTable<Class<?>, TypeTraverser<?>> traversersPerConcreteType;
        private final HashTable<Class<?>, TypeTraverser<?>> traversersPerPolymorphType;
        private TraversalFieldSelector fieldSelector;
        private Predicate<? super Field> fieldPredicate;
        private Function<XGettingCollection<Object>, XSet<Object>> alreadyHandledProvider;
        private TypeTraverser.Creator typeTraverserCreator;
        private TraversalAcceptor acceptor;
        private Predicate<Object> acceptorPredicate;
        private Consumer<Object> acceptorLogic;
        private TraversalMutator mutator;
        private Predicate<Object> mutatorPredicate;
        private Function<Object, ?> mutatorLogic;
        private MutationListener mutationListener;
        private TraversalMode traversalMode;
        private TraversalReferenceHandlerProvider referenceHandlerProvider;
        private Object[] roots;
        private Predicate<Object> predicateHandle;
        private Runnable initializerLogic;
        private Runnable finalizerLogic;

        Default() {
            this.skip().types(ObjectGraphTraverserBuilder.defaultSkipTypesConcrete());
            this.skip().typesPolymorphic(ObjectGraphTraverserBuilder.defaultSkipTypesPolymorphic());
            this.traversersPerInstance = HashTable.New();
            this.traversersPerConcreteType = HashTable.New(ObjectGraphTraverserBuilder.defaultConcreteTypeTraversers());
            this.traversersPerPolymorphType = HashTable.New(ObjectGraphTraverserBuilder.defaultPolymorphTypeTraversers());
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder initializerLogic(Runnable logic) {
            this.initializerLogic = logic;
            return this;
        }

        @Override
        public synchronized Runnable initializerLogic() {
            return this.initializerLogic;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder finalizerLogic(Runnable logic) {
            this.finalizerLogic = logic;
            return this;
        }

        @Override
        public synchronized Runnable finalizerLogic() {
            return this.finalizerLogic;
        }

        @Override
        public synchronized Predicate<Object> predicateHandle() {
            return this.predicateHandle;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder predicateHandle(Predicate<Object> predicate) {
            this.predicateHandle = predicate;
            return this;
        }

        @Override
        public synchronized TraversalFilter<TraversalPredicateSkip> skip() {
            return this.skip;
        }

        @Override
        public synchronized TraversalFilter<TraversalPredicateNode> node() {
            return this.node;
        }

        @Override
        public synchronized TraversalFilter<TraversalPredicateLeaf> leaf() {
            return this.leaf;
        }

        @Override
        public synchronized TraversalFilter<TraversalPredicateFull> full() {
            return this.full;
        }

        public synchronized HashTable<Object, TypeTraverser<?>> traversersPerInstance() {
            return this.traversersPerInstance;
        }

        public synchronized HashTable<Class<?>, TypeTraverser<?>> traversersPerConcreteType() {
            return this.traversersPerConcreteType;
        }

        public synchronized HashTable<Class<?>, TypeTraverser<?>> traversersPerPolymorphType() {
            return this.traversersPerPolymorphType;
        }

        @Override
        public synchronized TraversalFieldSelector fieldSelector() {
            return this.fieldSelector;
        }

        @Override
        public synchronized Predicate<? super Field> fieldPredicate() {
            return this.fieldPredicate;
        }

        @Override
        public synchronized Function<XGettingCollection<Object>, XSet<Object>> alreadyHandledProvider() {
            return this.alreadyHandledProvider;
        }

        @Override
        public synchronized TypeTraverser.Creator typeTraverserCreator() {
            return this.typeTraverserCreator;
        }

        @Override
        public synchronized TraversalAcceptor acceptor() {
            return this.acceptor;
        }

        @Override
        public synchronized Predicate<Object> acceptorPredicate() {
            return this.acceptorPredicate;
        }

        @Override
        public synchronized Consumer<Object> acceptorLogic() {
            return this.acceptorLogic;
        }

        @Override
        public synchronized TraversalMutator mutator() {
            return this.mutator;
        }

        @Override
        public synchronized Predicate<Object> mutatorPredicate() {
            return this.mutatorPredicate;
        }

        @Override
        public synchronized Function<Object, ?> mutatorLogic() {
            return this.mutatorLogic;
        }

        @Override
        public synchronized MutationListener mutationListener() {
            return this.mutationListener;
        }

        @Override
        public synchronized TraversalMode traversalMode() {
            return this.traversalMode;
        }

        @Override
        public synchronized TraversalReferenceHandlerProvider referenceHandlerProvider() {
            return this.referenceHandlerProvider;
        }

        @Override
        public synchronized Object[] roots() {
            return this.roots;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder fieldSelector(TraversalFieldSelector fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder fieldPredicate(Predicate<? super Field> traversableFieldSelector) {
            this.fieldPredicate = traversableFieldSelector;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder alreadyHandledProvider(Function<XGettingCollection<Object>, XSet<Object>> alreadyHandledProvider) {
            this.alreadyHandledProvider = alreadyHandledProvider;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder typeTraverserCreator(TypeTraverser.Creator typeTraverserCreator) {
            this.typeTraverserCreator = typeTraverserCreator;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder acceptor(TraversalAcceptor acceptor) {
            this.acceptor = acceptor;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder acceptorPredicate(Predicate<Object> acceptorPredicate) {
            this.acceptorPredicate = acceptorPredicate;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder acceptorLogic(Consumer<Object> acceptorLogic) {
            this.acceptorLogic = acceptorLogic;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder mutator(TraversalMutator mutator) {
            this.mutator = mutator;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder mutatorPredicate(Predicate<Object> mutatorPredicate) {
            this.mutatorPredicate = mutatorPredicate;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder mutatorLogic(Function<Object, Object> mutatorLogic) {
            this.mutatorLogic = mutatorLogic;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder mutationListener(MutationListener mutationListener) {
            this.mutationListener = mutationListener;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder traversalMode(TraversalMode traversalMode) {
            this.traversalMode = traversalMode;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder referenceHandlerProvider(TraversalReferenceHandlerProvider referenceHandlerProvider) {
            this.referenceHandlerProvider = referenceHandlerProvider;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder roots(Object ... roots) {
            this.roots = roots;
            return this;
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder mutate(Predicate<Object> predicate, Function<Object, ?> logic) {
            this.mutatorPredicate = predicate;
            this.mutatorLogic = logic;
            return this;
        }

        @Override
        public synchronized <T> ObjectGraphTraverserBuilder mutate(Class<T> type, Function<? super T, ?> logic) {
            return this.mutate(type::isInstance, (Object instance) -> logic.apply((Object)type.cast(instance)));
        }

        @Override
        public synchronized ObjectGraphTraverserBuilder apply(Predicate<Object> predicate, Consumer<Object> logic) {
            this.acceptorPredicate = predicate;
            this.acceptorLogic = logic;
            return this;
        }

        @Override
        public synchronized <T> ObjectGraphTraverserBuilder apply(Class<T> type, Consumer<? super T> logic) {
            return this.apply(type::isInstance, (Object instance) -> logic.accept((Object)type.cast(instance)));
        }

        protected synchronized TypeTraverserProvider provideTypeTraverserProvider() {
            return TypeTraverserProvider.New(this.provideTypeTraverserCreator(), this.traversersPerInstance(), this.traversersPerConcreteType(), this.traversersPerPolymorphType());
        }

        protected synchronized MutationListener provideMutationListener() {
            return this.mutationListener;
        }

        public synchronized ObjectGraphTraverserBuilder setMutationListener(MutationListener mutationListener) {
            this.mutationListener = mutationListener;
            return this;
        }

        protected synchronized Function<XGettingCollection<Object>, XSet<Object>> provideAlreadyHandledProvider() {
            if (this.alreadyHandledProvider != null) {
                return this.alreadyHandledProvider;
            }
            return OpenAdressingMiniSet::New;
        }

        @Override
        public synchronized TraversalAcceptor provideAcceptor() {
            if (this.acceptor != null) {
                return this.acceptor;
            }
            if (this.acceptorLogic != null) {
                return this.acceptorPredicate != null ? TraversalAcceptor.New(this.acceptorPredicate, this.acceptorLogic) : TraversalAcceptor.New(this.acceptorLogic);
            }
            return null;
        }

        @Override
        public synchronized TraversalMutator provideMutator() {
            if (this.mutator != null) {
                return this.mutator;
            }
            if (this.mutatorLogic != null) {
                return this.mutatorPredicate != null ? TraversalMutator.New(this.mutatorPredicate, this.mutatorLogic) : TraversalMutator.New(this.mutatorLogic);
            }
            return null;
        }

        protected synchronized TraversalFieldSelector provideTraversableFieldSelector() {
            if (this.fieldSelector != null) {
                return this.fieldSelector;
            }
            if (this.fieldPredicate != null) {
                return TraversalFieldSelector.New(this.fieldPredicate);
            }
            return null;
        }

        protected synchronized TypeTraverser.Creator provideTypeTraverserCreator() {
            if (this.typeTraverserCreator == null) {
                this.typeTraverserCreator = TraverserReflective.Creator(this.provideTraversableFieldSelector());
            }
            return this.typeTraverserCreator;
        }

        @Override
        public synchronized TraversalReferenceHandlerProvider provideReferenceHandlerProvider() {
            if (this.referenceHandlerProvider != null) {
                return this.referenceHandlerProvider;
            }
            return TraversalReferenceHandlerProvider.New();
        }

        @Override
        public synchronized XGettingSet<Object> provideSkippedInstances() {
            return this.skip().instances();
        }

        protected synchronized TraversalPredicateSkip providePredicateSkip() {
            TraversalPredicateSkip explicitPredicate = this.skip.predicate();
            if (explicitPredicate != null) {
                return explicitPredicate;
            }
            return this.skip.isEmpty() ? null : TraversalPredicateSkip.New(this.skip.customPredicate(), this.skip.types().immure(), this.skip.typesPolymorphic().immure());
        }

        protected synchronized TraversalPredicateFull providePredicateFull() {
            TraversalPredicateFull explicitPredicate = this.full.predicate();
            if (explicitPredicate != null) {
                return explicitPredicate;
            }
            return this.full.isEmpty() ? null : TraversalPredicateFull.New((XGettingSet<Object>)((Object)this.full.instances().immure()), this.full.customPredicate(), this.full.types().immure(), this.full.typesPolymorphic().immure());
        }

        protected synchronized TraversalPredicateNode providePredicateNode() {
            TraversalPredicateNode explicitPredicate = this.node.predicate();
            if (explicitPredicate != null) {
                return explicitPredicate;
            }
            return this.node.isEmpty() ? null : TraversalPredicateNode.New((XGettingSet<Object>)((Object)this.node.instances().immure()), this.node.customPredicate(), this.node.types().immure(), this.node.typesPolymorphic().immure());
        }

        protected synchronized TraversalPredicateLeaf providePredicateLeaf() {
            TraversalPredicateLeaf explicitPredicate = this.leaf.predicate();
            if (explicitPredicate != null) {
                return explicitPredicate;
            }
            return this.leaf.isEmpty() ? null : TraversalPredicateLeaf.New((XGettingSet<Object>)((Object)this.leaf.instances().immure()), this.leaf.customPredicate(), this.leaf.types().immure(), this.leaf.typesPolymorphic().immure());
        }

        protected synchronized TraversalMode provideTraversalMode() {
            return this.traversalMode != null ? this.traversalMode : new TraversalMode.Full();
        }

        @Override
        public synchronized ObjectGraphTraverser buildObjectGraphTraverser() {
            return ObjectGraphTraverser.New(this.roots(), this.provideSkippedInstances(), this.provideAlreadyHandledProvider(), this.provideReferenceHandlerProvider(), this.provideTypeTraverserProvider(), this.providePredicateSkip(), this.providePredicateNode(), this.providePredicateLeaf(), this.providePredicateFull(), this.predicateHandle(), this.provideAcceptor(), this.provideMutator(), this.provideMutationListener(), this.provideTraversalMode(), this.initializerLogic(), this.finalizerLogic());
        }
    }
}

