/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.traversing;

import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.HashEnum;
import one.microstream.collections.types.XEnum;
import one.microstream.collections.types.XSet;
import one.microstream.util.traversing.ObjectGraphTraverserBuilder;
import one.microstream.util.traversing.TraversalPredicate;

public interface TraversalFilter<P extends TraversalPredicate> {
    public ObjectGraphTraverserBuilder builder();

    public XSet<Object> instances();

    public XSet<Class<?>> types();

    public XEnum<Class<?>> typesPolymorphic();

    public P predicate();

    public Predicate<Object> customPredicate();

    public boolean isEmpty();

    public ObjectGraphTraverserBuilder setPredicate(P var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder instance(Object instance) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            this.instances().add(instance);
        }
        return this.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder instances(Object ... instances) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            this.instances().addAll(instances);
        }
        return this.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder instances(Iterable<?> instances) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            XSet<Object> is = this.instances();
            for (Object instance : instances) {
                is.add(instance);
            }
        }
        return this.builder();
    }

    public ObjectGraphTraverserBuilder custom(Predicate<Object> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder type(Class<?> type) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            this.types().add(type);
        }
        return this.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder types(Class<?> ... types) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            this.types().addAll((Object[])types);
        }
        return this.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder types(Iterable<Class<?>> types) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            XSet<Class<?>> ts = this.types();
            for (Class<?> type : types) {
                ts.add(type);
            }
        }
        return this.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder typePolymorphic(Class<?> type) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            this.typesPolymorphic().add(type);
        }
        return this.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder typesPolymorphic(Class<?> ... types) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            this.typesPolymorphic().addAll((Object[])types);
        }
        return this.builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ObjectGraphTraverserBuilder typesPolymorphic(Iterable<Class<?>> types) {
        ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
        synchronized (objectGraphTraverserBuilder) {
            XEnum<Class<?>> tps = this.typesPolymorphic();
            for (Class<?> type : types) {
                tps.add(type);
            }
        }
        return this.builder();
    }

    public static <P extends TraversalPredicate> Default<P> New(ObjectGraphTraverserBuilder builder) {
        return new Default(X.notNull(builder));
    }

    public static final class Default<P extends TraversalPredicate>
    implements TraversalFilter<P> {
        private final ObjectGraphTraverserBuilder builder;
        private final XSet<Object> instances;
        private final XSet<Class<?>> types;
        private final XEnum<Class<?>> typesPolymorphic;
        private P predicate;
        private Predicate<Object> customPredicate;

        public Default(ObjectGraphTraverserBuilder builder) {
            this.builder = builder;
            this.instances = HashEnum.New();
            this.types = HashEnum.New();
            this.typesPolymorphic = HashEnum.New();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                return this.instances.isEmpty() && this.types.isEmpty() && this.typesPolymorphic.isEmpty() && this.customPredicate == null;
            }
        }

        @Override
        public ObjectGraphTraverserBuilder builder() {
            return this.builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XSet<Object> instances() {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                return this.instances;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XSet<Class<?>> types() {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                return this.types;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XEnum<Class<?>> typesPolymorphic() {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                return this.typesPolymorphic;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public P predicate() {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                return this.predicate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Predicate<Object> customPredicate() {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                return this.customPredicate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectGraphTraverserBuilder setPredicate(P predicate) {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                this.predicate = predicate;
            }
            return this.builder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectGraphTraverserBuilder custom(Predicate<Object> customPredicate) {
            ObjectGraphTraverserBuilder objectGraphTraverserBuilder = this.builder();
            synchronized (objectGraphTraverserBuilder) {
                this.customPredicate = customPredicate;
            }
            return this.builder();
        }
    }
}

