/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.traversing;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import one.microstream.collections.HashEnum;
import one.microstream.reflect.XReflect;
import one.microstream.util.traversing.AbstractTraversalSkipSignal;
import one.microstream.util.traversing.MutationListener;
import one.microstream.util.traversing.TraversalAcceptor;
import one.microstream.util.traversing.TraversalEnqueuer;
import one.microstream.util.traversing.TraversalFieldSelector;
import one.microstream.util.traversing.TraversalMutator;
import one.microstream.util.traversing.TraverserNoOp;
import one.microstream.util.traversing.TypeTraverser;

public final class TraverserReflective<T>
implements TypeTraverser<T> {
    private final Class<T> type;
    private final Field[] fields;

    TraverserReflective(Class<T> type, Field[] fields) {
        this.type = type;
        this.fields = fields;
    }

    public final Class<T> type() {
        return this.type;
    }

    private static void storeToField(Field field, Object instance, Object value) {
        XReflect.setFieldValue(field, instance, value);
    }

    @Override
    public final void traverseReferences(T instance, TraversalEnqueuer enqueuer) {
        Field[] fields = this.fields;
        int length = fields.length;
        int i = 0;
        while (i < length) {
            enqueuer.enqueue(XReflect.getFieldValue(fields[i], instance));
            ++i;
        }
    }

    @Override
    public final void traverseReferences(T instance, TraversalEnqueuer enqueuer, TraversalAcceptor acceptor) {
        Field[] fields = this.fields;
        int length = fields.length;
        try {
            int i = 0;
            while (i < length) {
                Object current = XReflect.getFieldValue(fields[i], instance);
                if (acceptor.acceptReference(current, instance)) {
                    enqueuer.enqueue(current);
                }
                ++i;
            }
        }
        catch (AbstractTraversalSkipSignal abstractTraversalSkipSignal) {
            // empty catch block
        }
    }

    @Override
    public final void traverseReferences(T instance, TraversalEnqueuer enqueuer, TraversalMutator mutator, MutationListener mutationListener) {
        Field[] fields = this.fields;
        int length = fields.length;
        try {
            int i = 0;
            while (i < length) {
                Object current = XReflect.getFieldValue(fields[i], instance);
                enqueuer.enqueue(current);
                Object returned = mutator.mutateReference(current, instance);
                if (returned != current) {
                    if (mutationListener != null && mutationListener.registerChange(instance, current, returned)) {
                        enqueuer.enqueue(returned);
                    }
                    TraverserReflective.storeToField(fields[i], instance, returned);
                }
                ++i;
            }
        }
        catch (AbstractTraversalSkipSignal abstractTraversalSkipSignal) {
            // empty catch block
        }
    }

    @Override
    public final void traverseReferences(T instance, TraversalEnqueuer enqueuer, TraversalAcceptor acceptor, TraversalMutator mutator, MutationListener mutationListener) {
        Field[] fields = this.fields;
        int length = fields.length;
        try {
            int i = 0;
            while (i < length) {
                Object returned;
                Object current = XReflect.getFieldValue(fields[i], instance);
                if (acceptor.acceptReference(current, instance)) {
                    enqueuer.enqueue(current);
                }
                if ((returned = mutator.mutateReference(current, instance)) != current) {
                    if (mutationListener != null && mutationListener.registerChange(instance, current, returned)) {
                        enqueuer.enqueue(returned);
                    }
                    TraverserReflective.storeToField(fields[i], instance, returned);
                }
                ++i;
            }
        }
        catch (AbstractTraversalSkipSignal abstractTraversalSkipSignal) {
            // empty catch block
        }
    }

    @Override
    public final void traverseReferences(T instance, TraversalAcceptor acceptor) {
        Field[] fields = this.fields;
        int length = fields.length;
        try {
            int i = 0;
            while (i < length) {
                acceptor.acceptReference(XReflect.getFieldValue(fields[i], instance), instance);
                ++i;
            }
        }
        catch (AbstractTraversalSkipSignal abstractTraversalSkipSignal) {
            // empty catch block
        }
    }

    @Override
    public final void traverseReferences(T instance, TraversalMutator mutator, MutationListener mutationListener) {
        Field[] fields = this.fields;
        int length = fields.length;
        try {
            int i = 0;
            while (i < length) {
                Object current = XReflect.getFieldValue(fields[i], instance);
                Object returned = mutator.mutateReference(current, instance);
                if (returned != current) {
                    if (mutationListener != null) {
                        mutationListener.registerChange(instance, current, returned);
                    }
                    TraverserReflective.storeToField(fields[i], instance, returned);
                }
                ++i;
            }
        }
        catch (AbstractTraversalSkipSignal abstractTraversalSkipSignal) {
            // empty catch block
        }
    }

    @Override
    public final void traverseReferences(T instance, TraversalAcceptor acceptor, TraversalMutator mutator, MutationListener mutationListener) {
        Field[] fields = this.fields;
        int length = fields.length;
        try {
            int i = 0;
            while (i < length) {
                Object current = XReflect.getFieldValue(fields[i], instance);
                acceptor.acceptReference(current, instance);
                Object returned = mutator.mutateReference(current, instance);
                if (returned != current) {
                    if (mutationListener != null) {
                        mutationListener.registerChange(instance, current, returned);
                    }
                    TraverserReflective.storeToField(fields[i], instance, returned);
                }
                ++i;
            }
        }
        catch (AbstractTraversalSkipSignal abstractTraversalSkipSignal) {
            // empty catch block
        }
    }

    public static Creator Creator() {
        return TraverserReflective.Creator(null);
    }

    public static Creator Creator(TraversalFieldSelector fieldSelector) {
        return new Creator(fieldSelector != null ? fieldSelector : TraversalFieldSelector.New(XReflect::isReference));
    }

    public static final class Creator
    implements TypeTraverser.Creator {
        private final TraversalFieldSelector fieldSelector;

        Creator(TraversalFieldSelector fieldSelector) {
            this.fieldSelector = fieldSelector;
        }

        private final Field[] collectFields(Class<?> type) {
            HashEnum<Field> selectedFields = HashEnum.New();
            XReflect.iterateDeclaredFieldsUpwards(type, field -> {
                if (XReflect.isInstanceField(field) && this.fieldSelector.test(type, (Field)field)) {
                    selectedFields.prepend((Field)field);
                }
            });
            AccessibleObject[] fields = selectedFields.toArray(Field.class);
            AccessibleObject.setAccessible(fields, true);
            return fields;
        }

        protected final <T> TypeTraverser<T> internalCreateTraverser(Class<T> type) {
            Field[] collectedFields = this.collectFields(type);
            return collectedFields.length != 0 ? new TraverserReflective<T>(type, collectedFields) : TraverserNoOp.New(type);
        }

        @Override
        public final <T> TypeTraverser<T> createTraverser(Class<T> type) {
            return this.internalCreateTraverser(type);
        }
    }
}

