/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.xcsv;

import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.functional._charProcedure;
import one.microstream.util.xcsv.XCSV;
import one.microstream.util.xcsv.XCsvConfiguration;
import one.microstream.util.xcsv.XCsvVarStringLiteralEscapingAssembler;

public interface XCsvAssembler {
    public void addRowValueNull();

    public void addRowValueSimple(byte var1);

    public void addRowValueSimple(boolean var1);

    public void addRowValueSimple(short var1);

    public void addRowValueSimple(char var1);

    public void addRowValueSimple(int var1);

    public void addRowValueSimple(float var1);

    public void addRowValueSimple(long var1);

    public void addRowValueSimple(double var1);

    public void addRowValueSimple(CharSequence var1);

    public void addRowValueSimple(Boolean var1);

    public void addRowValueDelimited(CharSequence var1);

    public void completeRow();

    public void completeRows();

    public static Builder<VarString> Builder() {
        return Builder.Default.New();
    }

    public static interface Builder<O> {
        public XCsvConfiguration configuration();

        public String valueSeperatorPrefix();

        public String valueSeperatorSuffix();

        public String lineSeparatorPrefix();

        public String lineSeparatorSuffix();

        public Builder<O> setConfiguration(XCsvConfiguration var1);

        public Builder<O> setValueSeperatorPrefix(String var1);

        public Builder<O> setValueSeperatorSuffix(String var1);

        public Builder<O> setLineSeparatorPrefix(String var1);

        public Builder<O> setlLineSeparatorSuffix(String var1);

        public XCsvAssembler buildRowAssembler(O var1);

        public static final class Default
        implements Builder<VarString> {
            private XCsvConfiguration configuration;
            private String valueSeparatorPrefix;
            private String valueSeparatorSuffix;
            private String lineSeparatorPrefix;
            private String lineSeparatorSuffix;

            public static final Default New() {
                return new Default(XCSV.configurationDefault(), "", "", "", "");
            }

            Default(XCsvConfiguration configuration, String valueSeparatorPrefix, String valueSeparatorSuffix, String lineSeparatorPrefix, String lineSeparatorSuffix) {
                this.configuration = X.notNull(configuration);
                this.valueSeparatorPrefix = X.notNull(valueSeparatorPrefix);
                this.valueSeparatorSuffix = X.notNull(valueSeparatorSuffix);
                this.lineSeparatorPrefix = X.notNull(lineSeparatorPrefix);
                this.lineSeparatorSuffix = X.notNull(lineSeparatorSuffix);
            }

            @Override
            public final XCsvConfiguration configuration() {
                return this.configuration;
            }

            @Override
            public final String valueSeperatorPrefix() {
                return this.valueSeparatorPrefix;
            }

            @Override
            public final String valueSeperatorSuffix() {
                return this.valueSeparatorSuffix;
            }

            @Override
            public final String lineSeparatorPrefix() {
                return this.lineSeparatorPrefix;
            }

            @Override
            public final String lineSeparatorSuffix() {
                return this.lineSeparatorSuffix;
            }

            @Override
            public final Builder<VarString> setConfiguration(XCsvConfiguration configuration) {
                this.configuration = X.notNull(configuration);
                return this;
            }

            @Override
            public final Builder<VarString> setValueSeperatorPrefix(String separatorPrefix) {
                this.valueSeparatorPrefix = X.notNull(separatorPrefix);
                return this;
            }

            @Override
            public final Builder<VarString> setValueSeperatorSuffix(String separatorSuffix) {
                this.valueSeparatorSuffix = X.notNull(separatorSuffix);
                return this;
            }

            @Override
            public final Builder<VarString> setLineSeparatorPrefix(String separatorPrefix) {
                this.lineSeparatorPrefix = X.notNull(separatorPrefix);
                return this;
            }

            @Override
            public final Builder<VarString> setlLineSeparatorSuffix(String separatorSuffix) {
                this.lineSeparatorSuffix = X.notNull(separatorSuffix);
                return this;
            }

            @Override
            public XCsvAssembler buildRowAssembler(VarString vs) {
                return one.microstream.util.xcsv.XCsvAssembler$Default.New(this.configuration, vs, this.valueSeparatorPrefix, this.valueSeparatorSuffix, this.lineSeparatorPrefix, this.lineSeparatorSuffix);
            }
        }
    }

    public static final class Default
    implements XCsvAssembler {
        final VarString vs;
        final char delimiter;
        final char[] valueSeparator;
        final char[] lineSeparator;
        final _charProcedure assembler;

        public static final Default New(XCsvConfiguration xcsvConfig, VarString vs, String valueSeparatorPrefix, String valueSeparatorSuffix, String lineSeparatorPrefix, String lineSeparatorSuffix) {
            return new Default(X.notNull(vs), xcsvConfig.literalDelimiter(), xcsvConfig.valueSeparator(valueSeparatorPrefix, valueSeparatorSuffix).toCharArray(), xcsvConfig.lineSeparator(lineSeparatorPrefix, lineSeparatorSuffix).toCharArray(), XCsvVarStringLiteralEscapingAssembler.New(xcsvConfig, vs));
        }

        public static final Default New(XCsvConfiguration xcsvConfig, VarString vs) {
            return new Default(X.notNull(vs), xcsvConfig.literalDelimiter(), new char[]{xcsvConfig.valueSeparator()}, new char[]{xcsvConfig.lineSeparator()}, XCsvVarStringLiteralEscapingAssembler.New(xcsvConfig, vs));
        }

        public static final Default New(XCsvConfiguration xcsvConfig) {
            return Default.New(xcsvConfig, VarString.New());
        }

        Default(VarString vs, char delimiter, char[] valueSeparator, char[] lineSeparator, _charProcedure assembler) {
            this.vs = vs;
            this.valueSeparator = valueSeparator;
            this.delimiter = delimiter;
            this.lineSeparator = lineSeparator;
            this.assembler = assembler;
        }

        private void separate() {
            this.vs.add(this.valueSeparator);
        }

        @Override
        public final void addRowValueNull() {
            this.separate();
        }

        @Override
        public final void addRowValueSimple(byte value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(boolean value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(short value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(char value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(int value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(float value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(long value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(double value) {
            this.vs.add(value);
            this.separate();
        }

        @Override
        public final void addRowValueSimple(Boolean value) {
            if (value != null) {
                this.vs.add(value);
            }
            this.separate();
        }

        @Override
        public final void addRowValueSimple(CharSequence value) {
            if (value != null) {
                this.vs.add(value);
            }
            this.separate();
        }

        @Override
        public final void addRowValueDelimited(CharSequence value) {
            if (value != null) {
                this.vs.add(this.delimiter);
                XChars.iterate(value, this.assembler);
                this.vs.add(this.delimiter);
            }
            this.separate();
        }

        @Override
        public final void completeRow() {
            if (!this.vs.endsWith(this.valueSeparator)) {
                return;
            }
            this.vs.deleteLast(this.valueSeparator.length).add(this.lineSeparator);
        }

        @Override
        public final void completeRows() {
            if (!this.vs.endsWith(this.lineSeparator)) {
                return;
            }
            this.vs.deleteLast(this.lineSeparator.length);
        }
    }
}

