/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.xcsv;

import one.microstream.X;
import one.microstream.chars.StringTable;
import one.microstream.collections.LimitList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XImmutableSequence;
import one.microstream.typing.KeyValue;
import one.microstream.typing.XTypes;
import one.microstream.util.xcsv.XCsvConfiguration;

public interface XCsvContent {
    public String name();

    public XGettingSequence<? extends KeyValue<String, StringTable>> segments();

    public XCsvConfiguration configuration();

    @FunctionalInterface
    public static interface Builder<D> {
        public XCsvContent build(String var1, D var2);
    }

    public static final class Default
    implements XCsvContent {
        final String name;
        final XImmutableSequence<? extends KeyValue<String, StringTable>> segments;
        final XCsvConfiguration configuration;

        public static final Default New(String name, XGettingSequence<? extends KeyValue<String, StringTable>> segments, XCsvConfiguration configuration) {
            return new Default(name, segments, configuration);
        }

        public static final Default NewTranslated(String name, XGettingSequence<? extends StringTable> segments, XCsvConfiguration configuration) {
            LimitList<KeyValue<String, StringTable>> translated = new LimitList<KeyValue<String, StringTable>>(XTypes.to_int(segments.size()));
            for (StringTable stringTable : segments) {
                translated.add(X.KeyValue(stringTable.name(), stringTable));
            }
            return Default.New(name, translated, configuration);
        }

        private Default(String name, XGettingSequence<? extends KeyValue<String, StringTable>> segments, XCsvConfiguration configuration) {
            this.name = name;
            this.segments = segments.immure();
            this.configuration = configuration;
        }

        @Override
        public final String name() {
            return this.name;
        }

        @Override
        public final XGettingSequence<? extends KeyValue<String, StringTable>> segments() {
            return this.segments;
        }

        @Override
        public final XCsvConfiguration configuration() {
            return this.configuration;
        }
    }
}

