/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.xcsv;

import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XGettingList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XSequence;
import one.microstream.typing.XTypes;
import one.microstream.util.xcsv.XCsvEntityParser;
import one.microstream.util.xcsv.XCsvRowCollector;

public final class XCsvEntityCollector<T>
implements XCsvRowCollector {
    private final XCsvEntityParser.Abstract<T> parser;
    private final XSequence<? super T> rows;
    private final BulkList<String> row;

    public XCsvEntityCollector(XCsvEntityParser.Abstract<T> parser, XSequence<? super T> rows) {
        this.parser = X.notNull(parser);
        this.rows = X.notNull(rows);
        this.row = new BulkList();
    }

    @Override
    public final void beginTable(String tableName, XGettingSequence<String> columnNames, XGettingList<String> columnTypes) {
        this.parser.beginTable(tableName, columnNames, columnTypes);
    }

    @Override
    public final void accept(char[] data, int offset, int length) {
        this.row.add(data == null ? null : new String(data, offset, length));
    }

    @Override
    public void completeRow() {
        T entity;
        try {
            this.parser.validateRow(this.row);
        }
        catch (Exception e) {
            throw new RuntimeException("Row validation failed at row " + this.rows.size(), e);
        }
        try {
            entity = this.parser.apply(this.row);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Exception while parsing row " + XTypes.to_int(this.rows.size()), e);
        }
        this.rows.add(entity);
        this.row.clear();
    }

    @Override
    public final void completeTable() {
        this.row.clear();
        this.parser.completeTable();
    }

    public final XSequence<? super T> rows() {
        return this.rows;
    }
}

