/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.io.Serializable;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import one.microstream.X;
import one.microstream.cache.types.CacheConfiguration;
import one.microstream.cache.types.CacheConfigurationPropertyNames;
import one.microstream.cache.types.CacheStore;
import one.microstream.cache.types.CachingProvider;
import one.microstream.chars.XChars;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationLoader;
import one.microstream.configuration.types.ConfigurationParser;
import one.microstream.configuration.types.ConfigurationParserIni;
import one.microstream.configuration.types.ConfigurationParserXml;
import one.microstream.storage.embedded.configuration.types.EmbeddedStorageFoundationCreatorConfigurationBased;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;

public interface CacheConfigurationBuilderConfigurationBased {
    public CacheConfiguration.Builder<?, ?> buildCacheConfiguration(Configuration var1);

    public <K, V> CacheConfiguration.Builder<K, V> buildCacheConfiguration(Configuration var1, CacheConfiguration.Builder<K, V> var2);

    public static CacheConfigurationBuilderConfigurationBased New() {
        return new Default(ClassResolver.New());
    }

    public static CacheConfigurationBuilderConfigurationBased New(ClassResolver classResolver) {
        return new Default((ClassResolver)X.notNull((Object)classResolver));
    }

    @FunctionalInterface
    public static interface ClassResolver {
        public Class<?> loadClass(String var1) throws ClassNotFoundException;

        public static ClassResolver New() {
            return Class::forName;
        }
    }

    public static class Default
    implements CacheConfigurationBuilderConfigurationBased,
    CacheConfigurationPropertyNames {
        private final ClassResolver classResolver;

        Default(ClassResolver classResolver) {
            this.classResolver = classResolver;
        }

        @Override
        public CacheConfiguration.Builder<?, ?> buildCacheConfiguration(Configuration configuration) {
            CacheConfiguration.Builder<?, ?> builder = CacheConfiguration.Builder(this.getClass(configuration, "key-type"), this.getClass(configuration, "value-type"));
            return this.buildCacheConfiguration(configuration, builder);
        }

        @Override
        public <K, V> CacheConfiguration.Builder<K, V> buildCacheConfiguration(Configuration configuration, CacheConfiguration.Builder<K, V> builder) {
            configuration.opt("expiry-policy-factory").ifPresent(value -> {
                CacheConfiguration.Builder builder2 = builder.expiryPolicyFactory(this.valueAsFactory((String)value));
            });
            configuration.opt("eviction-manager-factory").ifPresent(value -> {
                CacheConfiguration.Builder builder2 = builder.evictionManagerFactory(this.valueAsFactory((String)value));
            });
            configuration.optBoolean("store-by-value").ifPresent(value -> {
                CacheConfiguration.Builder builder2 = builder.storeByValue((boolean)value);
            });
            configuration.optBoolean("statistics-enabled").ifPresent(value -> {
                CacheConfiguration.Builder builder2 = builder.enableStatistics((boolean)value);
            });
            configuration.optBoolean("management-enabled").ifPresent(value -> {
                CacheConfiguration.Builder builder2 = builder.enableManagement((boolean)value);
            });
            CacheStore cacheStore = this.buildCacheStore(configuration);
            if (cacheStore != null) {
                builder.cacheLoaderFactory((Factory & Serializable)() -> cacheStore).cacheWriterFactory((Factory & Serializable)() -> cacheStore).readThrough(configuration.optBoolean("read-through").orElse(true)).writeThrough(configuration.optBoolean("write-through").orElse(true));
            } else {
                configuration.opt("cache-loader-factory").ifPresent(value -> builder.cacheLoaderFactory(this.valueAsFactory((String)value)).readThrough(configuration.optBoolean("read-through").orElse(true)));
                configuration.opt("cache-writer-factory").ifPresent(value -> builder.cacheWriterFactory(this.valueAsFactory((String)value)).writeThrough(configuration.optBoolean("write-through").orElse(true)));
            }
            return builder;
        }

        private <K, V> CacheStore<K, V> buildCacheStore(Configuration configuration) {
            String resourceName;
            Configuration storageConfiguration = configuration.child("storage");
            if (storageConfiguration == null && !XChars.isEmpty((CharSequence)(resourceName = configuration.get("storage-configuration-resource-name")))) {
                storageConfiguration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((String)resourceName), (ConfigurationParser)(resourceName.toLowerCase().endsWith(".xml") ? ConfigurationParserXml.New() : ConfigurationParserIni.New()));
            }
            if (storageConfiguration != null) {
                EmbeddedStorageManager storageManager = EmbeddedStorageFoundationCreatorConfigurationBased.New((Configuration)storageConfiguration).createEmbeddedStorageFoundation().createEmbeddedStorageManager();
                String cacheKey = storageConfiguration.opt("key").orElse(CachingProvider.defaultURI() + "::cache");
                return CacheStore.New(cacheKey, storageManager);
            }
            return null;
        }

        private Class<?> getClass(Configuration configuration, String key) {
            String name = configuration.opt(key).orElse(null);
            try {
                return XChars.isEmpty((CharSequence)name) ? Object.class : this.classResolver.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }

        private <T> Factory<T> valueAsFactory(String value) {
            try {
                return (Factory)Factory.class.cast(this.classResolver.loadClass(value).newInstance());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }
}

