/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;
import one.microstream.cache.types.Unwrappable;

public class CacheEvent<K, V>
extends CacheEntryEvent<K, V>
implements Unwrappable {
    private final K key;
    private final V value;
    private final V oldValue;
    private final boolean oldValueAvailable;

    CacheEvent(Cache<K, V> source, EventType eventType, K key, V value) {
        this((Cache<K, Object>)source, eventType, key, value, null, false);
    }

    CacheEvent(Cache<K, V> source, EventType eventType, K key, V value, V oldValue) {
        this(source, eventType, key, value, oldValue, true);
    }

    CacheEvent(Cache<K, V> source, EventType eventType, K key, V value, V oldValue, boolean oldValueAvailable) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.oldValueAvailable = oldValueAvailable;
    }

    public Cache<K, V> getCache() {
        return super.getSource();
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public V getOldValue() throws UnsupportedOperationException {
        return this.isOldValueAvailable() ? (V)this.oldValue : null;
    }

    public boolean isOldValueAvailable() {
        return this.oldValueAvailable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return Unwrappable.Static.unwrap(this, clazz);
    }
}

