/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;

public interface CacheStatisticsMXBean
extends javax.cache.management.CacheStatisticsMXBean {
    public void increaseCacheRemovals(long var1);

    public void increaseCacheExpiries(long var1);

    public void increaseCachePuts(long var1);

    public void increaseCacheHits(long var1);

    public void increaseCacheMisses(long var1);

    public void increaseCacheEvictions(long var1);

    public void addGetTimeNano(long var1);

    public void addPutTimeNano(long var1);

    public void addRemoveTimeNano(long var1);

    public static class Default
    implements CacheStatisticsMXBean {
        private static final long NANOSECONDS_IN_A_MICROSECOND = 1000L;
        private final transient LongSupplier sizeSupplier;
        private final AtomicLong cacheRemovals = new AtomicLong();
        private final AtomicLong cacheExpiries = new AtomicLong();
        private final AtomicLong cachePuts = new AtomicLong();
        private final AtomicLong cacheHits = new AtomicLong();
        private final AtomicLong cacheMisses = new AtomicLong();
        private final AtomicLong cacheEvictions = new AtomicLong();
        private final AtomicLong cachePutTimeTakenNanos = new AtomicLong();
        private final AtomicLong cacheGetTimeTakenNanos = new AtomicLong();
        private final AtomicLong cacheRemoveTimeTakenNanos = new AtomicLong();

        Default(LongSupplier sizeSupplier) {
            this.sizeSupplier = sizeSupplier;
        }

        public void clear() {
            this.cachePuts.set(0L);
            this.cacheMisses.set(0L);
            this.cacheRemovals.set(0L);
            this.cacheExpiries.set(0L);
            this.cacheHits.set(0L);
            this.cacheEvictions.set(0L);
            this.cacheGetTimeTakenNanos.set(0L);
            this.cachePutTimeTakenNanos.set(0L);
            this.cacheRemoveTimeTakenNanos.set(0L);
        }

        public long getEntryCount() {
            return this.sizeSupplier.getAsLong();
        }

        public long getCacheHits() {
            return this.cacheHits.longValue();
        }

        public float getCacheHitPercentage() {
            long hits = this.getCacheHits();
            return hits == 0L ? 0.0f : (float)hits / (float)this.getCacheGets() * 100.0f;
        }

        public long getCacheMisses() {
            return this.cacheMisses.longValue();
        }

        public float getCacheMissPercentage() {
            long misses = this.getCacheMisses();
            return misses == 0L ? 0.0f : (float)misses / (float)this.getCacheGets() * 100.0f;
        }

        public long getCacheGets() {
            return this.getCacheHits() + this.getCacheMisses();
        }

        public long getCachePuts() {
            return this.cachePuts.longValue();
        }

        public long getCacheRemovals() {
            return this.cacheRemovals.longValue();
        }

        public long getCacheEvictions() {
            return this.cacheEvictions.longValue();
        }

        public float getAverageGetTime() {
            long cacheGetTimeTakenNanos = this.cacheGetTimeTakenNanos.longValue();
            long cacheGets = this.getCacheGets();
            return cacheGetTimeTakenNanos == 0L || cacheGets == 0L ? 0L : cacheGetTimeTakenNanos / cacheGets / 1000L;
        }

        public float getAveragePutTime() {
            long cachePutTimeTakenNanos = this.cachePutTimeTakenNanos.longValue();
            long cacheGets = this.getCacheGets();
            return cachePutTimeTakenNanos == 0L || cacheGets == 0L ? 0L : cachePutTimeTakenNanos / cacheGets / 1000L;
        }

        public float getAverageRemoveTime() {
            long cacheRemoveTimeTakenNanos = this.cacheRemoveTimeTakenNanos.longValue();
            long cacheGets = this.getCacheGets();
            return cacheRemoveTimeTakenNanos == 0L || cacheGets == 0L ? 0L : cacheRemoveTimeTakenNanos / cacheGets / 1000L;
        }

        @Override
        public void increaseCacheRemovals(long number) {
            this.cacheRemovals.getAndAdd(number);
        }

        @Override
        public void increaseCacheExpiries(long number) {
            this.cacheExpiries.getAndAdd(number);
        }

        @Override
        public void increaseCachePuts(long number) {
            this.cachePuts.getAndAdd(number);
        }

        @Override
        public void increaseCacheHits(long number) {
            this.cacheHits.getAndAdd(number);
        }

        @Override
        public void increaseCacheMisses(long number) {
            this.cacheMisses.getAndAdd(number);
        }

        @Override
        public void increaseCacheEvictions(long number) {
            this.cacheEvictions.getAndAdd(number);
        }

        @Override
        public void addGetTimeNano(long duration) {
            if (this.cacheGetTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
                this.cacheGetTimeTakenNanos.addAndGet(duration);
            } else {
                this.clear();
                this.cacheGetTimeTakenNanos.set(duration);
            }
        }

        @Override
        public void addPutTimeNano(long duration) {
            if (this.cachePutTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
                this.cachePutTimeTakenNanos.addAndGet(duration);
            } else {
                this.clear();
                this.cachePutTimeTakenNanos.set(duration);
            }
        }

        @Override
        public void addRemoveTimeNano(long duration) {
            if (this.cacheRemoveTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
                this.cacheRemoveTimeTakenNanos.addAndGet(duration);
            } else {
                this.clear();
                this.cacheRemoveTimeTakenNanos.set(duration);
            }
        }
    }
}

