/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.util.Comparator;
import java.util.Random;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.cache.types.CacheTable;
import one.microstream.cache.types.CachedValue;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XEnum;
import one.microstream.reference._intReference;
import one.microstream.typing.KeyValue;

@FunctionalInterface
public interface EvictionPolicy {
    public Iterable<KeyValue<Object, CachedValue>> pickEntriesToEvict(CacheTable var1);

    public static Predicate<CacheTable> MaxCacheSizePredicate(long maxCacheSize) {
        return cache -> cache.size() >= maxCacheSize;
    }

    public static Comparator<KeyValue<Object, CachedValue>> LeastRecentlyUsedComparator() {
        return (kv1, kv2) -> Long.compare(((CachedValue)kv1.value()).accessTime(), ((CachedValue)kv2.value()).accessTime());
    }

    public static Comparator<KeyValue<Object, CachedValue>> LeastFrequentlyUsedComparator() {
        return (kv1, kv2) -> Long.compare(((CachedValue)kv1.value()).accessCount(), ((CachedValue)kv2.value()).accessCount());
    }

    public static Comparator<KeyValue<Object, CachedValue>> BiggestObjectsComparator() {
        return (kv1, kv2) -> Long.compare(((CachedValue)kv2.value()).byteSizeEstimate(), ((CachedValue)kv1.value()).byteSizeEstimate());
    }

    public static int DefaultElementCount() {
        return 4;
    }

    public static EvictionPolicy LeastRecentlyUsed(long maxCacheSize) {
        return EvictionPolicy.LeastRecentlyUsed(EvictionPolicy.DefaultElementCount(), maxCacheSize);
    }

    public static EvictionPolicy LeastRecentlyUsed(int elementCount, long maxCacheSize) {
        return EvictionPolicy.LeastRecentlyUsed(() -> elementCount, EvictionPolicy.MaxCacheSizePredicate(maxCacheSize), null);
    }

    public static EvictionPolicy LeastRecentlyUsed(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission) {
        return EvictionPolicy.Sampling(elementCount, evictionNecessity, evictionPermission, EvictionPolicy.LeastRecentlyUsedComparator());
    }

    public static EvictionPolicy LeastFrequentlyUsed(long maxCacheSize) {
        return EvictionPolicy.LeastFrequentlyUsed(EvictionPolicy.DefaultElementCount(), maxCacheSize);
    }

    public static EvictionPolicy LeastFrequentlyUsed(int elementCount, long maxCacheSize) {
        return EvictionPolicy.LeastFrequentlyUsed(() -> elementCount, EvictionPolicy.MaxCacheSizePredicate(maxCacheSize), null);
    }

    public static EvictionPolicy LeastFrequentlyUsed(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission) {
        return EvictionPolicy.Sampling(elementCount, evictionNecessity, evictionPermission, EvictionPolicy.LeastFrequentlyUsedComparator());
    }

    public static EvictionPolicy BiggestObjects(int elementCount, long maxCacheSize) {
        return EvictionPolicy.BiggestObjects(() -> elementCount, EvictionPolicy.MaxCacheSizePredicate(maxCacheSize), null);
    }

    public static EvictionPolicy BiggestObjects(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission) {
        return EvictionPolicy.Sampling(elementCount, evictionNecessity, evictionPermission, EvictionPolicy.BiggestObjectsComparator());
    }

    public static EvictionPolicy FirstInFirstOut(int elementCount, long maxCacheSize) {
        return EvictionPolicy.FirstInFirstOut(() -> elementCount, EvictionPolicy.MaxCacheSizePredicate(maxCacheSize), null);
    }

    public static EvictionPolicy FirstInFirstOut(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission) {
        return EvictionPolicy.Searching(elementCount, evictionNecessity, evictionPermission);
    }

    public static EvictionPolicy Sampling(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission, Comparator<KeyValue<Object, CachedValue>> comparator) {
        return new Sampling(elementCount, evictionNecessity, evictionPermission, comparator);
    }

    public static EvictionPolicy Searching(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission) {
        return new Searching(elementCount, evictionNecessity, evictionPermission);
    }

    public static class Sampling
    implements EvictionPolicy {
        static final int MAX_SAMPLE_COUNT = 10;
        static final int SAMPLE_THRESHOLD = 10000;
        static final int MIN_SAMPLE_SIZE = 15;
        static final int MAX_SAMPLE_SIZE = 100;
        static final double SAMPLE_SIZE_FACTOR = 0.002;
        private final _intReference elementCount;
        private final Predicate<CacheTable> evictionNecessity;
        private final Predicate<KeyValue<Object, CachedValue>> evictionPermission;
        private final Comparator<KeyValue<Object, CachedValue>> comparator;
        private final Random random;

        Sampling(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission, Comparator<KeyValue<Object, CachedValue>> comparator) {
            this.elementCount = (_intReference)X.notNull((Object)elementCount);
            this.evictionNecessity = evictionNecessity;
            this.evictionPermission = evictionPermission != null ? evictionPermission : kv -> true;
            this.comparator = (Comparator)X.notNull(comparator);
            this.random = new Random();
        }

        @Override
        public Iterable<KeyValue<Object, CachedValue>> pickEntriesToEvict(CacheTable cacheTable) {
            if (this.evictionNecessity != null && !this.evictionNecessity.test(cacheTable)) {
                return null;
            }
            int elementCount = this.elementCount.get();
            if (elementCount <= 0) {
                throw new RuntimeException("Illegal element count for eviction: " + elementCount + " <= 0");
            }
            if (elementCount == 1) {
                int sample = 0;
                while (sample < 10) {
                    KeyValue<Object, CachedValue> entryToEvict = this.sample(cacheTable);
                    if (entryToEvict != null && this.evictionPermission.test(entryToEvict)) {
                        return X.Constant(entryToEvict);
                    }
                    ++sample;
                }
            } else {
                int sample = 0;
                while (sample < 10) {
                    EqHashEnum entriesToEvict = EqHashEnum.NewCustom((int)elementCount);
                    int i = 0;
                    while (i < elementCount) {
                        KeyValue<Object, CachedValue> entryToEvict = this.sample(cacheTable);
                        if (entryToEvict != null && this.evictionPermission.test(entryToEvict)) {
                            entriesToEvict.add(entryToEvict);
                        }
                        ++i;
                    }
                    if (!entriesToEvict.isEmpty()) {
                        return entriesToEvict;
                    }
                    ++sample;
                }
            }
            return null;
        }

        private KeyValue<Object, CachedValue> sample(CacheTable cacheTable) {
            int cacheSize = X.checkArrayRange((long)cacheTable.size());
            if (cacheSize < 10000) {
                return cacheTable.min(this.comparator);
            }
            int optSampleSize = (int)((double)cacheSize * 0.002);
            int sampleSize = optSampleSize < 15 ? 15 : (optSampleSize > 100 ? 100 : optSampleSize);
            int offset = this.random.nextInt(cacheSize - sampleSize - 1);
            return cacheTable.rangeMin(offset, sampleSize, this.comparator);
        }
    }

    public static class Searching
    implements EvictionPolicy {
        private final _intReference elementCount;
        private final Predicate<CacheTable> evictionNecessity;
        private final Predicate<KeyValue<Object, CachedValue>> evictionPermission;

        Searching(_intReference elementCount, Predicate<CacheTable> evictionNecessity, Predicate<KeyValue<Object, CachedValue>> evictionPermission) {
            this.elementCount = (_intReference)X.notNull((Object)elementCount);
            this.evictionNecessity = evictionNecessity;
            this.evictionPermission = evictionPermission != null ? evictionPermission : kv -> true;
        }

        @Override
        public Iterable<KeyValue<Object, CachedValue>> pickEntriesToEvict(CacheTable cacheTable) {
            if (this.evictionNecessity != null && !this.evictionNecessity.test(cacheTable)) {
                return null;
            }
            int elementCount = this.elementCount.get();
            if (elementCount <= 0) {
                throw new RuntimeException("Illegal element count for eviction: " + elementCount + " <= 0");
            }
            EqHashEnum entriesToEvict = EqHashEnum.NewCustom((int)elementCount);
            cacheTable.iterate(arg_0 -> this.lambda$1((XEnum)entriesToEvict, elementCount, arg_0));
            return entriesToEvict;
        }

        private /* synthetic */ void lambda$1(XEnum xEnum, int n, KeyValue kv) {
            if (this.evictionPermission.test((KeyValue<Object, CachedValue>)kv)) {
                xEnum.add((Object)kv);
                if (xEnum.size() >= (long)n) {
                    throw X.BREAK();
                }
            }
        }
    }
}

