/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.processor.MutableEntry;
import one.microstream.X;
import one.microstream.cache.types.CachedValue;
import one.microstream.cache.types.ObjectConverter;
import one.microstream.cache.types.Unwrappable;

public interface MutableCacheEntry<K, V>
extends MutableEntry<K, V>,
Unwrappable {
    public Operation getOperation();

    @Override
    default public <T> T unwrap(Class<T> clazz) {
        return Unwrappable.Static.unwrap(this, clazz);
    }

    public static <K, V> MutableCacheEntry<K, V> New(ObjectConverter converter, K key, CachedValue cachedValue, long now, CacheLoader<K, V> cacheLoader) {
        return new Default<K, V>(converter, key, cachedValue, now, cacheLoader);
    }

    public static class Default<K, V>
    implements MutableCacheEntry<K, V> {
        private final K key;
        private final CachedValue cachedValue;
        private final ObjectConverter converter;
        private final long now;
        private final CacheLoader<K, V> cacheLoader;
        private V value;
        private Operation operation;

        Default(ObjectConverter converter, K key, CachedValue cachedValue, long now, CacheLoader<K, V> cacheLoader) {
            this.converter = converter;
            this.key = key;
            this.cachedValue = cachedValue;
            this.operation = Operation.NONE;
            this.value = null;
            this.now = now;
            this.cacheLoader = cacheLoader;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            if (this.operation == Operation.NONE) {
                if (this.cachedValue == null || this.cachedValue.isExpiredAt(this.now)) {
                    this.value = null;
                } else if (this.value == null) {
                    Object internalValue = this.cachedValue.value(this.now);
                    this.value = internalValue == null ? null : this.converter.externalize(internalValue);
                    Object v0 = this.value;
                }
            }
            if (this.value != null) {
                if (this.operation == Operation.NONE) {
                    this.operation = Operation.ACCESS;
                }
            } else if (this.cacheLoader != null) {
                try {
                    this.value = this.cacheLoader.load(this.key);
                    if (this.value != null) {
                        this.operation = Operation.LOAD;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof CacheLoaderException)) {
                        throw new CacheLoaderException("Exception in CacheLoader", (Throwable)e);
                    }
                    throw e;
                }
            }
            return this.value;
        }

        public boolean exists() {
            return this.value != null || this.operation == Operation.NONE && this.cachedValue != null && !this.cachedValue.isExpiredAt(this.now);
        }

        public void remove() {
            this.operation = this.operation == Operation.CREATE || this.operation == Operation.LOAD ? Operation.NONE : Operation.REMOVE;
            this.value = null;
        }

        public void setValue(V value) {
            X.notNull(value);
            this.operation = this.cachedValue == null || this.cachedValue.isExpiredAt(this.now) ? Operation.CREATE : Operation.UPDATE;
            this.value = value;
        }

        @Override
        public Operation getOperation() {
            return this.operation;
        }
    }

    public static enum Operation {
        NONE,
        ACCESS,
        CREATE,
        LOAD,
        REMOVE,
        UPDATE;

    }
}

