/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import one.microstream.cache.types.SerializedObject;
import one.microstream.cache.types.Serializer;

public interface ObjectConverter {
    public <T> Object internalize(T var1);

    public <T> T externalize(Object var1);

    public static ObjectConverter ByReference() {
        return new ByReference();
    }

    public static ObjectConverter ByValue(Serializer serializer) {
        return new ByValue(serializer);
    }

    public static class ByReference
    implements ObjectConverter {
        ByReference() {
        }

        @Override
        public <T> Object internalize(T value) {
            return value;
        }

        @Override
        public <T> T externalize(Object internal) {
            return (T)internal;
        }
    }

    public static class ByValue
    implements ObjectConverter {
        private final Serializer serializer;

        ByValue(Serializer serializer) {
            this.serializer = serializer;
        }

        @Override
        public <T> Object internalize(T value) {
            return SerializedObject.New(value.hashCode(), this.serializer.write(value));
        }

        @Override
        public <T> T externalize(Object internal) {
            return (T)this.serializer.read(((SerializedObject)internal).serializedData());
        }
    }
}

