/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.cache.types.CacheConfiguration;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.BinaryPersistence;
import one.microstream.persistence.binary.types.BinaryPersistenceFoundation;
import one.microstream.persistence.exceptions.PersistenceExceptionTransfer;
import one.microstream.persistence.types.PersistenceContextDispatcher;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceSource;
import one.microstream.persistence.types.PersistenceTarget;
import one.microstream.persistence.types.PersistenceTypeDictionaryCreator;
import one.microstream.persistence.types.PersistenceTypeDictionaryManager;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.persistence.types.Persister;
import one.microstream.storage.types.Database;
import one.microstream.util.traversing.ObjectGraphTraverser;

public interface Serializer
extends Closeable {
    public Binary write(Object var1);

    public Object read(Binary var1);

    @Override
    public void close();

    public static Serializer get(ClassLoader classLoader) {
        return Static.get(classLoader, CacheConfiguration.DefaultSerializerFieldPredicate());
    }

    public static Serializer get(ClassLoader classLoader, Predicate<? super Field> fieldPredicate) {
        return Static.get(classLoader, fieldPredicate);
    }

    public static class Default
    implements Serializer {
        private final Predicate<? super Field> fieldPredicate;
        private PersistenceManager<Binary> persistenceManager;
        private ObjectGraphTraverser typeHandlerEnsurer;
        private Binary input;
        private Binary output;

        Default(Predicate<? super Field> fieldPredicate) {
            this.fieldPredicate = fieldPredicate;
        }

        @Override
        public synchronized Binary write(Object object) {
            this.lazyInit();
            this.typeHandlerEnsurer.traverse(object);
            this.persistenceManager.store(object);
            return this.output;
        }

        @Override
        public synchronized Object read(Binary data) {
            this.lazyInit();
            this.input = data;
            return this.persistenceManager.get();
        }

        @Override
        public synchronized void close() {
            if (this.persistenceManager != null) {
                this.persistenceManager.objectRegistry().truncateAll();
                this.persistenceManager.close();
                this.persistenceManager = null;
                this.input = null;
                this.output = null;
                this.typeHandlerEnsurer = null;
            }
        }

        private void lazyInit() {
            if (this.persistenceManager == null) {
                PersistenceSourceBinary source = () -> X.Constant((Object)this.input);
                PersistenceTargetBinary target = data -> {
                    Binary binary = this.output = data;
                };
                BinaryPersistenceFoundation foundation = (BinaryPersistenceFoundation)((BinaryPersistenceFoundation)((BinaryPersistenceFoundation)((BinaryPersistenceFoundation)BinaryPersistence.Foundation().setPersister((Persister)Database.New((String)Serializer.class.getName()))).setPersistenceSource((PersistenceSource)source)).setPersistenceTarget((PersistenceTarget)target)).setContextDispatcher((PersistenceContextDispatcher)PersistenceContextDispatcher.LocalObjectRegistration());
                foundation.setTypeDictionaryManager(PersistenceTypeDictionaryManager.Transient((PersistenceTypeDictionaryCreator)foundation.getTypeDictionaryCreator()));
                PersistenceTypeHandlerManager typeHandlerManager = foundation.getTypeHandlerManager();
                typeHandlerManager.initialize();
                this.persistenceManager = foundation.createPersistenceManager();
                Consumer<Object> objectAcceptor = obj -> {
                    if (obj != null) {
                        typeHandlerManager.ensureTypeHandler(obj);
                    }
                };
                this.typeHandlerEnsurer = ObjectGraphTraverser.Builder().modeFull().fieldPredicate(this.fieldPredicate).acceptorLogic(objectAcceptor).buildObjectGraphTraverser();
            } else {
                this.persistenceManager.objectRegistry().clearAll();
            }
        }

        static interface PersistenceSourceBinary
        extends PersistenceSource<Binary> {
            default public XGettingCollection<? extends Binary> readByObjectIds(PersistenceIdSet[] oids) throws PersistenceExceptionTransfer {
                return null;
            }
        }

        static interface PersistenceTargetBinary
        extends PersistenceTarget<Binary> {
            default public boolean isWritable() {
                return true;
            }
        }
    }

    public static class Static {
        private static final WeakHashMap<ClassLoader, Serializer> cache = new WeakHashMap();

        static synchronized Serializer get(ClassLoader classLoader, Predicate<? super Field> fieldPredicate) {
            return cache.computeIfAbsent(classLoader, cl -> new Default(fieldPredicate));
        }

        private Static() {
            throw new Error();
        }
    }
}

