/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import one.microstream.X;
import one.microstream.cache.types.CacheConfiguration;
import one.microstream.cache.types.CacheConfigurationMXBean;
import one.microstream.cache.types.CacheEntry;
import one.microstream.cache.types.CacheEntryListenerRegistration;
import one.microstream.cache.types.CacheEvent;
import one.microstream.cache.types.CacheEventDispatcher;
import one.microstream.cache.types.CacheManager;
import one.microstream.cache.types.CacheStatisticsMXBean;
import one.microstream.cache.types.CacheStore;
import one.microstream.cache.types.CacheTable;
import one.microstream.cache.types.CacheValueValidator;
import one.microstream.cache.types.CachedValue;
import one.microstream.cache.types.EntryProcessorResult;
import one.microstream.cache.types.EvictionManager;
import one.microstream.cache.types.MBeanServerUtils;
import one.microstream.cache.types.MutableCacheEntry;
import one.microstream.cache.types.ObjectConverter;
import one.microstream.cache.types.Unwrappable;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XIterable;
import one.microstream.collections.types.XList;
import one.microstream.exceptions.IORuntimeException;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.util.Serializer;
import one.microstream.persistence.binary.util.SerializerFoundation;
import one.microstream.reference.Reference;
import one.microstream.reflect.ClassLoaderProvider;
import one.microstream.typing.KeyValue;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface Cache<K, V>
extends javax.cache.Cache<K, V>,
Unwrappable {
    public CacheManager getCacheManager();

    public CacheConfiguration<K, V> getConfiguration();

    public long size();

    default public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, true);
    }

    default public void putAll(Map<? extends K, ? extends V> map, boolean replaceExistingValues) {
        this.putAll(map, replaceExistingValues, true);
    }

    public void putAll(Map<? extends K, ? extends V> var1, boolean var2, boolean var3);

    public void setManagementEnabled(boolean var1);

    public void setStatisticsEnabled(boolean var1);

    public void evict(Iterable<KeyValue<Object, CachedValue>> var1);

    @Override
    default public <T> T unwrap(Class<T> clazz) {
        return Unwrappable.Static.unwrap(this, clazz);
    }

    public static <K, V> Cache<K, V> New(String name, CacheManager manager, CacheConfiguration<K, V> configuration) {
        return new Default<K, V>(name, manager, configuration);
    }

    public static class Default<K, V>
    implements Cache<K, V> {
        private static final Logger logger = Logging.getLogger(Default.class);
        private final String name;
        private final CacheManager manager;
        private final CacheConfiguration<K, V> configuration;
        private final CacheValueValidator keyValidator;
        private final CacheValueValidator valueValidator;
        private final ObjectConverter objectConverter;
        private final CacheLoader<K, V> cacheLoader;
        private final CacheWriter<K, V> cacheWriter;
        private final ExpiryPolicy expiryPolicy;
        private final EvictionManager<K, V> evictionManager;
        private final CacheTable cacheTable;
        private final XList<CacheEntryListenerRegistration<K, V>> listenerRegistrations;
        private final ExecutorService executorService;
        private final CacheConfigurationMXBean cacheConfigurationMXBean;
        private final CacheStatisticsMXBean cacheStatisticsMXBean;
        private final AtomicBoolean isStatisticsEnabled = new AtomicBoolean();
        private final AtomicBoolean isClosed = new AtomicBoolean();

        Default(String name, CacheManager manager, CacheConfiguration<K, V> configuration) {
            this.name = name;
            this.manager = manager;
            this.configuration = configuration;
            this.objectConverter = configuration.isStoreByValue() ? ObjectConverter.ByValue((Serializer<Binary>)Serializer.Binary((SerializerFoundation)configuration.getSerializerFoundation().setClassLoaderProvider(ClassLoaderProvider.New((ClassLoader)Thread.currentThread().getContextClassLoader())))) : ObjectConverter.ByReference();
            Factory expiryPolicyFactory = (Factory)X.coalesce((Object)configuration.getExpiryPolicyFactory(), CacheConfiguration.DefaultExpiryPolicyFactory());
            this.expiryPolicy = expiryPolicyFactory != null ? (ExpiryPolicy)expiryPolicyFactory.create() : null;
            Factory evictionManagerFactory = (Factory)X.coalesce(configuration.getEvictionManagerFactory(), CacheConfiguration.DefaultEvictionManagerFactory());
            this.evictionManager = evictionManagerFactory != null ? (EvictionManager)evictionManagerFactory.create() : null;
            Factory cacheLoaderFactory = configuration.getCacheLoaderFactory();
            this.cacheLoader = cacheLoaderFactory != null ? (CacheLoader)cacheLoaderFactory.create() : null;
            Factory cacheWriterFactory = configuration.getCacheWriterFactory();
            this.cacheWriter = cacheWriterFactory != null ? (CacheWriter)cacheWriterFactory.create() : null;
            this.keyValidator = CacheValueValidator.New("key", configuration.getKeyType());
            this.valueValidator = CacheValueValidator.New("value", configuration.getValueType());
            this.cacheTable = CacheTable.New();
            this.listenerRegistrations = X.synchronize((XList)BulkList.New());
            this.executorService = Executors.newFixedThreadPool(1);
            this.cacheConfigurationMXBean = new CacheConfigurationMXBean.Default(this.configuration);
            this.cacheStatisticsMXBean = new CacheStatisticsMXBean.Default(this::size);
            configuration.getCacheEntryListenerConfigurations().forEach(this::createAndRegisterCacheEntryListener);
            if (configuration.isManagementEnabled()) {
                this.setManagementEnabled(true);
            }
            if (configuration.isStatisticsEnabled()) {
                this.setStatisticsEnabled(true);
            }
            if (this.evictionManager != null) {
                this.evictionManager.install(this, this.cacheTable);
            }
            logger.debug("MicroStream Cache '{}' created with following configuration:\n{}", (Object)name, configuration);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public CacheManager getCacheManager() {
            return this.manager;
        }

        @Override
        public CacheConfiguration<K, V> getConfiguration() {
            return this.configuration;
        }

        public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
            if (clazz.isInstance(this.configuration)) {
                return (C)((Configuration)clazz.cast(this.configuration));
            }
            throw new IllegalArgumentException("Unsupported configuration type: " + clazz.getName());
        }

        private void updateConfiguration(Consumer<MutableConfiguration<K, V>> c) {
            if (this.configuration instanceof MutableConfiguration) {
                c.accept((MutableConfiguration)this.configuration);
            }
        }

        public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
            X.notNull(cacheEntryListenerConfiguration);
            this.updateConfiguration(c -> {
                MutableConfiguration mutableConfiguration = c.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            });
            this.createAndRegisterCacheEntryListener(cacheEntryListenerConfiguration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createAndRegisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
            XList<CacheEntryListenerRegistration<K, V>> xList = this.listenerRegistrations;
            synchronized (xList) {
                this.listenerRegistrations.add(CacheEntryListenerRegistration.New(cacheEntryListenerConfiguration));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
            X.notNull(cacheEntryListenerConfiguration);
            this.updateConfiguration(c -> {
                MutableConfiguration mutableConfiguration = c.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            });
            XList<CacheEntryListenerRegistration<K, V>> xList = this.listenerRegistrations;
            synchronized (xList) {
                this.listenerRegistrations.removeBy(reg -> cacheEntryListenerConfiguration.equals(reg.getConfiguration()));
            }
        }

        public boolean isClosed() {
            return this.isClosed.get();
        }

        public synchronized void close() {
            if (this.isClosed.get()) {
                return;
            }
            this.isClosed.set(true);
            this.manager.removeCache(this.name);
            if (this.evictionManager != null) {
                this.evictionManager.uninstall(this, this.cacheTable);
            }
            this.setStatisticsEnabled(false);
            this.setManagementEnabled(false);
            this.closeIfCloseable(this.cacheLoader);
            this.closeIfCloseable(this.cacheWriter);
            this.closeIfCloseable(this.expiryPolicy);
            this.listenerRegistrations.forEach(reg -> this.closeIfCloseable(reg.getCacheEntryListener()));
            this.listenerRegistrations.clear();
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
            this.cacheTable.clear();
            logger.debug("MicroStream Cache '{}' closed", (Object)this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size() {
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                return this.cacheTable.size();
            }
        }

        public V get(K key) {
            this.ensureOpen();
            this.keyValidator.validate(key);
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object value = this.getValue(key, eventDispatcher, null);
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            return value;
        }

        public Map<K, V> getAll(Set<? extends K> keys) {
            this.ensureOpen();
            keys.forEach(this.keyValidator::validate);
            HashMap result = new HashMap(keys.size());
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            for (K key : keys) {
                Object value = this.getValue(key, eventDispatcher, null);
                if (value == null) continue;
                result.put(key, value);
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(K key) {
            this.ensureOpen();
            this.keyValidator.validate(key);
            Object internalKey = this.objectConverter.internalize(key);
            long now = System.currentTimeMillis();
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                return cachedValue != null && !cachedValue.isExpiredAt(now);
            }
        }

        public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
            this.ensureOpen();
            if (this.cacheLoader != null) {
                keys.forEach(this.keyValidator::validate);
                this.submit(() -> this.loadAllInternal(keys, replaceExistingValues, completionListener));
            } else if (completionListener != null) {
                completionListener.onCompletion();
            }
        }

        private void loadAllInternal(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
            block8: {
                try {
                    Map loaded;
                    ArrayList<K> keysToLoad = new ArrayList<K>();
                    for (K key : keys) {
                        if (!replaceExistingValues && this.containsKey(key)) continue;
                        keysToLoad.add(key);
                    }
                    try {
                        loaded = this.cacheLoader.loadAll(keysToLoad);
                    }
                    catch (CacheLoaderException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new CacheLoaderException((Throwable)e);
                    }
                    for (Object key : keysToLoad) {
                        if (loaded.get(key) != null) continue;
                        loaded.remove(key);
                    }
                    this.putAll(loaded, replaceExistingValues, false);
                    if (completionListener != null) {
                        completionListener.onCompletion();
                    }
                }
                catch (Exception e) {
                    if (completionListener == null) break block8;
                    completionListener.onException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            this.ensureOpen();
            this.keyValidator.validate(key);
            this.valueValidator.validate(value);
            AtomicBoolean isStatisticsEnabled = this.isStatisticsEnabled;
            long start = isStatisticsEnabled.get() ? System.nanoTime() : 0L;
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            int putCount = 0;
            long now = System.currentTimeMillis();
            ObjectConverter objectConverter = this.objectConverter;
            Object internalKey = objectConverter.internalize(key);
            Object internalValue = objectConverter.internalize(value);
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                boolean isExpired;
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (isExpired) {
                    this.processExpiries(key, internalKey, eventDispatcher, objectConverter.externalize(cachedValue.value()));
                }
                CacheEntry<K, V> entry = CacheEntry.New(key, value);
                if (cachedValue == null || isExpired) {
                    cachedValue = CachedValue.New(internalValue, now, this.expiryForCreation().getAdjustedTime(now));
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(key, internalKey, eventDispatcher, objectConverter.externalize(cachedValue.value()));
                    } else {
                        this.writeCacheEntry(entry);
                        this.putValue(key, value, internalKey, cachedValue, eventDispatcher);
                        ++putCount;
                    }
                } else {
                    Object oldValue = objectConverter.externalize(cachedValue.value(now));
                    this.updateExpiryForUpdate(cachedValue, now);
                    cachedValue.value(internalValue, now);
                    this.writeCacheEntry(entry);
                    ++putCount;
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryUpdatedListener.class, new CacheEvent<K, V>(this, EventType.UPDATED, key, value, oldValue));
                    }
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled.get() && putCount > 0) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                cacheStatisticsMXBean.increaseCachePuts(putCount);
                cacheStatisticsMXBean.addPutTimeNano(System.nanoTime() - start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V getAndPut(K key, V value) {
            V result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            this.valueValidator.validate(value);
            AtomicBoolean isStatisticsEnabled = this.isStatisticsEnabled;
            long start = isStatisticsEnabled.get() ? System.nanoTime() : 0L;
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            int putCount = 0;
            long now = System.currentTimeMillis();
            Object internalKey = this.objectConverter.internalize(key);
            Object internalValue = this.objectConverter.internalize(value);
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                boolean isExpired;
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (isExpired) {
                    this.processExpiries(key, internalKey, eventDispatcher, this.objectConverter.externalize(cachedValue.value()));
                }
                CacheEntry<K, V> entry = CacheEntry.New(key, value);
                if (cachedValue == null || isExpired) {
                    result = null;
                    cachedValue = CachedValue.New(internalValue, now, this.expiryForCreation().getAdjustedTime(now));
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(key, internalKey, eventDispatcher, this.objectConverter.externalize(cachedValue.value()));
                    } else {
                        this.putValue(key, value, internalKey, cachedValue, eventDispatcher);
                        this.writeCacheEntry(entry);
                        ++putCount;
                    }
                } else {
                    Object t = this.objectConverter.externalize(cachedValue.value(now));
                    result = (V)t;
                    Object oldValue = t;
                    this.updateExpiryForUpdate(cachedValue, now);
                    cachedValue.value(internalValue, now);
                    this.writeCacheEntry(entry);
                    ++putCount;
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryUpdatedListener.class, new CacheEvent<K, V>(this, EventType.UPDATED, key, value, oldValue));
                    }
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled.get()) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                if (result == null) {
                    cacheStatisticsMXBean.increaseCacheMisses(1L);
                } else {
                    cacheStatisticsMXBean.increaseCacheHits(1L);
                }
                cacheStatisticsMXBean.addGetTimeNano(System.nanoTime() - start);
                if (putCount > 0) {
                    cacheStatisticsMXBean.increaseCachePuts(putCount);
                    cacheStatisticsMXBean.addPutTimeNano(System.nanoTime() - start);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map, boolean replaceExistingValues, boolean useWriteThrough) {
            this.ensureOpen();
            map.keySet().forEach(this.keyValidator::validate);
            map.values().forEach(this.valueValidator::validate);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            int putCount = 0;
            CacheEventDispatcher<Object, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            CacheWriterException exception = null;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                boolean isWriteThrough = this.cacheWriter != null && this.configuration.isWriteThrough() && useWriteThrough;
                ArrayList<CacheEntry<K, V>> entriesToWrite = new ArrayList<CacheEntry<K, V>>();
                HashSet<K> keysToPut = new HashSet<K>();
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    K key = entry.getKey();
                    V value = entry.getValue();
                    keysToPut.add(key);
                    if (!isWriteThrough) continue;
                    entriesToWrite.add(CacheEntry.New(key, value));
                }
                if (isWriteThrough) {
                    try {
                        this.cacheWriter.writeAll(entriesToWrite);
                    }
                    catch (CacheWriterException cacheWriterException) {
                        exception = cacheWriterException;
                    }
                    catch (Exception exception2) {
                        exception = new CacheWriterException((Throwable)exception2);
                    }
                    for (Cache.Entry entry : entriesToWrite) {
                        keysToPut.remove(entry.getKey());
                    }
                }
                for (Object object : keysToPut) {
                    boolean isExpired;
                    V value = map.get(object);
                    Object internalKey = this.objectConverter.internalize(object);
                    Object internalValue = this.objectConverter.internalize(value);
                    CachedValue cachedValue = this.cacheTable.get(internalKey);
                    boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                    if (cachedValue == null || isExpired) {
                        if (isExpired) {
                            this.processExpiries(object, internalKey, eventDispatcher, this.objectConverter.externalize(cachedValue.value()));
                        }
                        if ((cachedValue = CachedValue.New(internalValue, now, this.expiryForCreation().getAdjustedTime(now))).isExpiredAt(now)) {
                            this.processExpiries(object, internalKey, eventDispatcher, value);
                            continue;
                        }
                        this.putValue(object, value, internalKey, cachedValue, eventDispatcher);
                        if (!useWriteThrough) continue;
                        ++putCount;
                        continue;
                    }
                    if (!replaceExistingValues) continue;
                    Object oldValue = this.objectConverter.externalize(cachedValue.value());
                    this.updateExpiryForUpdate(cachedValue, now);
                    cachedValue.value(internalValue, now);
                    if (useWriteThrough) {
                        ++putCount;
                    }
                    if (eventDispatcher == null) continue;
                    eventDispatcher.addEvent(CacheEntryUpdatedListener.class, new CacheEvent<Object, V>(this, EventType.UPDATED, object, value, oldValue));
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<Object, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled && putCount > 0) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                cacheStatisticsMXBean.increaseCachePuts(putCount);
                cacheStatisticsMXBean.addPutTimeNano(System.nanoTime() - start);
            }
            if (exception != null) {
                throw exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean putIfAbsent(K key, V value) {
            boolean result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            this.valueValidator.validate(value);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            Object internalValue = this.objectConverter.internalize(value);
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                boolean isExpired;
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (cachedValue == null || isExpired) {
                    CacheEntry<K, V> entry = CacheEntry.New(key, value);
                    this.writeCacheEntry(entry);
                    if (isExpired) {
                        this.processExpiries(key, internalKey, eventDispatcher, this.objectConverter.externalize(cachedValue.value()));
                    }
                    if ((cachedValue = CachedValue.New(internalValue, now, this.expiryForCreation().getAdjustedTime(now))).isExpiredAt(now)) {
                        this.processExpiries(key, internalKey, eventDispatcher, value);
                        result = false;
                    } else {
                        this.putValue(key, value, internalKey, cachedValue, eventDispatcher);
                        result = true;
                    }
                } else {
                    result = false;
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                if (result) {
                    cacheStatisticsMXBean.increaseCachePuts(1L);
                    cacheStatisticsMXBean.increaseCacheMisses(1L);
                    cacheStatisticsMXBean.addPutTimeNano(System.nanoTime() - start);
                } else {
                    cacheStatisticsMXBean.increaseCacheHits(1L);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(K key) {
            boolean result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, Object> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                CachedValue cachedValue;
                block9: {
                    this.deleteCacheEntry(key);
                    cachedValue = this.cacheTable.get(internalKey);
                    if (cachedValue != null) break block9;
                    return false;
                }
                if (cachedValue.isExpiredAt(now)) {
                    result = false;
                } else {
                    this.cacheTable.remove(internalKey);
                    Object value = this.objectConverter.externalize(cachedValue.value());
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent(this, EventType.REMOVED, key, value, value));
                    }
                    result = true;
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, Object>>)this.listenerRegistrations);
            }
            if (result && isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                cacheStatisticsMXBean.increaseCacheRemovals(1L);
                cacheStatisticsMXBean.addRemoveTimeNano(System.nanoTime() - start);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(K key, V oldValue) {
            boolean result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            this.valueValidator.validate(oldValue);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            boolean hit = false;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                } else {
                    Object oldInternalValue;
                    hit = true;
                    Object internalValue = cachedValue.value();
                    if (internalValue.equals(oldInternalValue = this.objectConverter.internalize(oldValue))) {
                        this.deleteCacheEntry(key);
                        this.cacheTable.remove(internalKey);
                        if (eventDispatcher != null) {
                            eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent<K, V>(this, EventType.REMOVED, key, oldValue, oldValue));
                        }
                        result = true;
                    } else {
                        this.updateExpiryForAccess(cachedValue, now);
                        result = false;
                    }
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                long duration = System.nanoTime() - start;
                if (result) {
                    cacheStatisticsMXBean.increaseCacheRemovals(1L);
                    cacheStatisticsMXBean.addRemoveTimeNano(duration);
                }
                cacheStatisticsMXBean.addGetTimeNano(duration);
                if (hit) {
                    cacheStatisticsMXBean.increaseCacheHits(1L);
                } else {
                    cacheStatisticsMXBean.increaseCacheMisses(1L);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V getAndRemove(K key) {
            Object result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                this.deleteCacheEntry(key);
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = null;
                } else {
                    this.cacheTable.remove(internalKey);
                    result = this.objectConverter.externalize(cachedValue.value(now));
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent<K, Object>(this, EventType.REMOVED, key, result, result));
                    }
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                long duration = System.nanoTime() - start;
                cacheStatisticsMXBean.addGetTimeNano(duration);
                if (result != null) {
                    cacheStatisticsMXBean.increaseCacheHits(1L);
                    cacheStatisticsMXBean.increaseCacheRemovals(1L);
                    cacheStatisticsMXBean.addRemoveTimeNano(duration);
                } else {
                    cacheStatisticsMXBean.increaseCacheMisses(1L);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(K key, V oldValue, V newValue) {
            boolean result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            this.valueValidator.validate(newValue);
            this.valueValidator.validate(oldValue);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            long hitCount = 0L;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                } else {
                    ++hitCount;
                    Object oldInternalValue = this.objectConverter.internalize(oldValue);
                    if (cachedValue.value().equals(oldInternalValue)) {
                        CacheEntry<K, V> entry = CacheEntry.New(key, newValue);
                        this.writeCacheEntry(entry);
                        this.updateExpiryForUpdate(cachedValue, now);
                        cachedValue.value(this.objectConverter.internalize(newValue), now);
                        if (eventDispatcher != null) {
                            eventDispatcher.addEvent(CacheEntryUpdatedListener.class, new CacheEvent<K, V>(this, EventType.UPDATED, key, newValue, oldValue));
                        }
                        result = true;
                    } else {
                        this.updateExpiryForAccess(cachedValue, now);
                        result = false;
                    }
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                long duration = System.nanoTime() - start;
                if (result) {
                    cacheStatisticsMXBean.increaseCachePuts(1L);
                    cacheStatisticsMXBean.addPutTimeNano(duration);
                }
                cacheStatisticsMXBean.addGetTimeNano(duration);
                if (hitCount == 1L) {
                    cacheStatisticsMXBean.increaseCacheHits(hitCount);
                } else {
                    cacheStatisticsMXBean.increaseCacheMisses(1L);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(K key, V value) {
            boolean result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            this.valueValidator.validate(value);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                } else {
                    Object oldValue = this.objectConverter.externalize(cachedValue.value());
                    CacheEntry<K, V> entry = CacheEntry.New(key, value);
                    this.writeCacheEntry(entry);
                    this.updateExpiryForUpdate(cachedValue, now);
                    Object newInternalValue = this.objectConverter.internalize(value);
                    cachedValue.value(newInternalValue, now);
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryUpdatedListener.class, new CacheEvent<K, V>(this, EventType.UPDATED, key, value, oldValue));
                    }
                    result = true;
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                long duration = System.nanoTime() - start;
                cacheStatisticsMXBean.addGetTimeNano(duration);
                if (result) {
                    cacheStatisticsMXBean.increaseCachePuts(1L);
                    cacheStatisticsMXBean.increaseCacheHits(1L);
                    cacheStatisticsMXBean.addPutTimeNano(duration);
                } else {
                    cacheStatisticsMXBean.increaseCacheMisses(1L);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V getAndReplace(K key, V value) {
            V result;
            this.ensureOpen();
            this.keyValidator.validate(key);
            this.valueValidator.validate(value);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = null;
                } else {
                    Object oldValue = this.objectConverter.externalize(cachedValue.value());
                    CacheEntry<K, V> entry = CacheEntry.New(key, value);
                    this.writeCacheEntry(entry);
                    this.updateExpiryForUpdate(cachedValue, now);
                    cachedValue.value(this.objectConverter.internalize(value), now);
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryUpdatedListener.class, new CacheEvent<K, V>(this, EventType.UPDATED, key, value, oldValue));
                    }
                    result = (V)oldValue;
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                long duration = System.nanoTime() - start;
                cacheStatisticsMXBean.addGetTimeNano(duration);
                if (result != null) {
                    cacheStatisticsMXBean.increaseCachePuts(1L);
                    cacheStatisticsMXBean.increaseCacheHits(1L);
                    cacheStatisticsMXBean.addPutTimeNano(duration);
                } else {
                    cacheStatisticsMXBean.increaseCacheMisses(1L);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll(Set<? extends K> keys) {
            this.ensureOpen();
            keys.forEach(this.keyValidator::validate);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, Object> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            HashSet<K> cacheWriterKeys = new HashSet<K>();
            HashSet<K> deletedKeys = new HashSet<K>();
            cacheWriterKeys.addAll(keys);
            CacheWriterException exception = null;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                if (this.cacheWriter != null && this.configuration.isWriteThrough()) {
                    try {
                        this.cacheWriter.deleteAll(cacheWriterKeys);
                    }
                    catch (CacheWriterException e) {
                        exception = e;
                    }
                    catch (Exception e) {
                        exception = new CacheWriterException((Throwable)e);
                    }
                    for (K key : keys) {
                        Object internalKey;
                        CachedValue cachedValue;
                        if (cacheWriterKeys.contains(key) || (cachedValue = this.cacheTable.remove(internalKey = this.objectConverter.internalize(key))) == null) continue;
                        deletedKeys.add(key);
                        Object value = this.objectConverter.externalize(cachedValue.value());
                        if (cachedValue.isExpiredAt(now)) {
                            this.processExpiries(key, internalKey, eventDispatcher, value);
                            continue;
                        }
                        if (eventDispatcher == null) continue;
                        eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent(this, EventType.REMOVED, key, value, value));
                    }
                } else {
                    for (K key : keys) {
                        Object internalKey = this.objectConverter.internalize(key);
                        CachedValue cachedValue = this.cacheTable.remove(internalKey);
                        if (cachedValue == null) continue;
                        deletedKeys.add(key);
                        Object value = this.objectConverter.externalize(cachedValue.value());
                        if (cachedValue.isExpiredAt(now)) {
                            this.processExpiries(key, internalKey, eventDispatcher, value);
                            continue;
                        }
                        if (eventDispatcher == null) continue;
                        eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent(this, EventType.REMOVED, key, value, value));
                    }
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, Object>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                this.cacheStatisticsMXBean.increaseCacheRemovals(deletedKeys.size());
            }
            if (exception != null) {
                throw exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            this.ensureOpen();
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            int removed = 0;
            long now = System.currentTimeMillis();
            CacheEventDispatcher<Object, Object> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            CacheWriterException exception = null;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                Set keysToDelete;
                HashSet keys = new HashSet();
                this.cacheTable.keys().forEach(key -> {
                    boolean bl = keys.add(this.objectConverter.externalize(key));
                });
                if (this.cacheWriter != null && this.configuration.isWriteThrough()) {
                    keysToDelete = new HashSet(keys);
                    if (keysToDelete.size() > 0) {
                        try {
                            this.cacheWriter.deleteAll(keysToDelete);
                        }
                        catch (CacheWriterException e) {
                            exception = e;
                        }
                        catch (Exception e) {
                            exception = new CacheWriterException((Throwable)e);
                        }
                    }
                } else {
                    keysToDelete = Collections.emptySet();
                }
                for (Object key2 : keys) {
                    if (keysToDelete.contains(key2)) continue;
                    Object internalKey = this.objectConverter.internalize(key2);
                    CachedValue cachedValue = this.cacheTable.remove(internalKey);
                    Object value = this.objectConverter.externalize(cachedValue.value());
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(key2, internalKey, eventDispatcher, value);
                        continue;
                    }
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent(this, EventType.REMOVED, key2, value, value));
                    }
                    ++removed;
                }
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<Object, Object>>)this.listenerRegistrations);
            }
            if (isStatisticsEnabled) {
                this.cacheStatisticsMXBean.increaseCacheRemovals(removed);
            }
            if (exception != null) {
                throw exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.ensureOpen();
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                this.cacheTable.clear();
            }
        }

        public Iterator<Cache.Entry<K, V>> iterator() {
            this.ensureOpen();
            if (this.cacheLoader instanceof CacheStore) {
                Iterator keys = ((CacheStore)this.cacheLoader).keys();
                CacheEventDispatcher eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
                return new EntryIterator(new KeyToValueIterator(keys, eventDispatcher));
            }
            return new EntryIterator(this.cacheTable.iterator());
        }

        @Override
        public void setStatisticsEnabled(boolean enabled) {
            this.isStatisticsEnabled.set(enabled);
            this.updateConfiguration(c -> {
                MutableConfiguration mutableConfiguration = c.setStatisticsEnabled(enabled);
            });
            this.updateCacheObjectRegistration(enabled, this.cacheStatisticsMXBean, MBeanServerUtils.MBeanType.CacheStatistics);
        }

        @Override
        public void setManagementEnabled(boolean enabled) {
            this.updateConfiguration(c -> {
                MutableConfiguration mutableConfiguration = c.setManagementEnabled(enabled);
            });
            this.updateCacheObjectRegistration(enabled, this.cacheConfigurationMXBean, MBeanServerUtils.MBeanType.CacheConfiguration);
        }

        private void updateCacheObjectRegistration(boolean enabled, Object bean, MBeanServerUtils.MBeanType beanType) {
            if (enabled) {
                MBeanServerUtils.registerCacheObject(this, bean, beanType);
            } else {
                MBeanServerUtils.unregisterCacheObject(this, bean, beanType);
            }
        }

        public <T> Map<K, javax.cache.processor.EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
            this.ensureOpen();
            keys.forEach(this.keyValidator::validate);
            X.notNull(entryProcessor);
            HashMap map = new HashMap();
            for (K key : keys) {
                EntryProcessorResult result = null;
                try {
                    T t = this.invoke(key, entryProcessor, arguments);
                    result = t == null ? null : EntryProcessorResult.New(t);
                }
                catch (Exception e) {
                    result = EntryProcessorResult.New(e);
                }
                if (result == null) continue;
                map.put(key, result);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
            this.ensureOpen();
            this.keyValidator.validate(key);
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            X.notNull(entryProcessor);
            long now = System.currentTimeMillis();
            CacheEventDispatcher<K, V> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            Object internalKey = this.objectConverter.internalize(key);
            Object result = null;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                boolean isExpired;
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (isExpired) {
                    this.processExpiries(key, internalKey, eventDispatcher, this.objectConverter.externalize(cachedValue.value()));
                }
                if (isStatisticsEnabled) {
                    CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                    if (cachedValue == null || isExpired) {
                        cacheStatisticsMXBean.increaseCacheMisses(1L);
                    } else {
                        cacheStatisticsMXBean.increaseCacheHits(1L);
                    }
                    long nanoTime = System.nanoTime();
                    cacheStatisticsMXBean.addGetTimeNano(nanoTime - start);
                    start = nanoTime;
                }
                MutableCacheEntry<K, V> entry = MutableCacheEntry.New(this.objectConverter, key, cachedValue, now, this.configuration.isReadThrough() ? this.cacheLoader : null);
                try {
                    result = entryProcessor.process(entry, arguments);
                }
                catch (CacheException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new EntryProcessorException((Throwable)e);
                }
                this.finishInvocation(key, internalKey, cachedValue, entry, start, now, eventDispatcher, isStatisticsEnabled);
            }
            if (eventDispatcher != null) {
                eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<K, V>>)this.listenerRegistrations);
            }
            return (T)result;
        }

        private void finishInvocation(K key, Object internalKey, CachedValue cachedValue, MutableCacheEntry<K, V> entry, long start, long now, CacheEventDispatcher<K, V> eventDispatcher, boolean isStatisticsEnabled) {
            switch (entry.getOperation()) {
                case ACCESS: {
                    this.updateExpiryForAccess(cachedValue, now);
                    break;
                }
                case CREATE: 
                case LOAD: {
                    this.finishInvocationCreateLoad(key, internalKey, entry, start, now, eventDispatcher, isStatisticsEnabled);
                    break;
                }
                case UPDATE: {
                    this.finishInvocationUpdate(key, entry, cachedValue, start, now, eventDispatcher, isStatisticsEnabled);
                    break;
                }
                case REMOVE: {
                    this.finishInvocationRemove(key, internalKey, cachedValue, start, eventDispatcher, isStatisticsEnabled);
                }
            }
        }

        private void finishInvocationCreateLoad(K key, Object internalKey, MutableCacheEntry<K, V> entry, long start, long now, CacheEventDispatcher<K, V> eventDispatcher, boolean isStatisticsEnabled) {
            CachedValue cachedValue;
            CacheEntry<K, Object> e = CacheEntry.New(key, entry.getValue());
            if (entry.getOperation() == MutableCacheEntry.Operation.CREATE) {
                this.writeCacheEntry(e);
            }
            if ((cachedValue = CachedValue.New(this.objectConverter.internalize(entry.getValue()), now, this.expiryForCreation().getAdjustedTime(now))).isExpiredAt(now)) {
                Object previousValue = this.objectConverter.externalize(cachedValue.value());
                this.processExpiries(key, internalKey, eventDispatcher, previousValue);
            } else {
                this.putValue(key, entry.getValue(), internalKey, cachedValue, eventDispatcher);
                if (isStatisticsEnabled && entry.getOperation() == MutableCacheEntry.Operation.CREATE) {
                    CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                    cacheStatisticsMXBean.increaseCachePuts(1L);
                    cacheStatisticsMXBean.addPutTimeNano(System.nanoTime() - start);
                }
            }
        }

        private void finishInvocationUpdate(K key, MutableCacheEntry<K, V> entry, CachedValue cachedValue, long start, long now, CacheEventDispatcher<K, V> eventDispatcher, boolean isStatisticsEnabled) {
            Object oldValue = this.objectConverter.externalize(cachedValue.value());
            CacheEntry<K, Object> e = CacheEntry.New(key, entry.getValue());
            this.writeCacheEntry(e);
            this.updateExpiryForUpdate(cachedValue, now);
            cachedValue.value(this.objectConverter.internalize(entry.getValue()), now);
            if (eventDispatcher != null) {
                eventDispatcher.addEvent(CacheEntryUpdatedListener.class, new CacheEvent<K, Object>(this, EventType.UPDATED, key, entry.getValue(), oldValue));
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                cacheStatisticsMXBean.increaseCachePuts(1L);
                cacheStatisticsMXBean.addPutTimeNano(System.nanoTime() - start);
            }
        }

        private void finishInvocationRemove(K key, Object internalKey, CachedValue cachedValue, long start, CacheEventDispatcher<K, V> eventDispatcher, boolean isStatisticsEnabled) {
            this.deleteCacheEntry(key);
            Object oldValue = cachedValue == null ? null : (Object)this.objectConverter.externalize(cachedValue.value());
            this.cacheTable.remove(internalKey);
            if (eventDispatcher != null) {
                eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent<K, Object>(this, EventType.REMOVED, key, oldValue, oldValue));
            }
            if (isStatisticsEnabled) {
                CacheStatisticsMXBean cacheStatisticsMXBean = this.cacheStatisticsMXBean;
                cacheStatisticsMXBean.increaseCacheRemovals(1L);
                cacheStatisticsMXBean.addRemoveTimeNano(System.nanoTime() - start);
            }
        }

        private void ensureOpen() {
            if (this.isClosed.get()) {
                throw new IllegalStateException("Cache is closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private V getValue(K key, CacheEventDispatcher<K, V> eventDispatcher, Reference<CachedValue> cachedValueReference) {
            boolean isStatisticsEnabled = this.isStatisticsEnabled.get();
            long start = isStatisticsEnabled ? System.nanoTime() : 0L;
            long now = System.currentTimeMillis();
            Object internalKey = this.objectConverter.internalize(key);
            V value = null;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                boolean isExpired;
                CachedValue cachedValue = this.cacheTable.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (cachedValue == null || isExpired) {
                    if (isExpired) {
                        this.processExpiries(key, internalKey, eventDispatcher, this.objectConverter.externalize(cachedValue.value()));
                    }
                    if (isStatisticsEnabled) {
                        this.cacheStatisticsMXBean.increaseCacheMisses(1L);
                    }
                    if ((value = this.loadCacheEntry(key, value)) != null) {
                        cachedValue = CachedValue.New(this.objectConverter.internalize(value), now, this.expiryForCreation().getAdjustedTime(now));
                        if (cachedValue.isExpiredAt(now)) {
                            value = null;
                        } else {
                            this.putValue(key, value, internalKey, cachedValue, eventDispatcher);
                        }
                    }
                } else {
                    value = (V)this.objectConverter.externalize(cachedValue.value(now));
                    this.updateExpiryForAccess(cachedValue, now);
                    if (isStatisticsEnabled) {
                        this.cacheStatisticsMXBean.increaseCacheHits(1L);
                    }
                }
                if (cachedValueReference != null) {
                    cachedValueReference.set((Object)cachedValue);
                }
            }
            if (isStatisticsEnabled) {
                this.cacheStatisticsMXBean.addGetTimeNano(System.nanoTime() - start);
            }
            return value;
        }

        private void putValue(K key, V value, Object internalKey, CachedValue cachedValue, CacheEventDispatcher<K, V> eventDispatcher) {
            this.cacheTable.put(internalKey, cachedValue);
            if (eventDispatcher != null) {
                eventDispatcher.addEvent(CacheEntryCreatedListener.class, new CacheEvent<K, V>(this, EventType.CREATED, key, value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evict(Iterable<KeyValue<Object, CachedValue>> entriesToEvict) {
            long evictionCount = 0L;
            CacheEventDispatcher<Object, Object> eventDispatcher = this.listenerRegistrations.size() > 0L ? CacheEventDispatcher.New() : null;
            CacheTable cacheTable = this.cacheTable;
            synchronized (cacheTable) {
                for (KeyValue<Object, CachedValue> entryToEvict : entriesToEvict) {
                    this.cacheTable.remove(entryToEvict.key());
                    Object evictedKey = this.objectConverter.externalize(entryToEvict.key());
                    Object evictedValue = this.objectConverter.externalize(((CachedValue)entryToEvict.value()).value());
                    this.deleteCacheEntry(evictedKey);
                    if (eventDispatcher != null) {
                        eventDispatcher.addEvent(CacheEntryRemovedListener.class, new CacheEvent(this, EventType.REMOVED, evictedKey, evictedValue, evictedValue));
                    }
                    ++evictionCount;
                }
            }
            if (this.isStatisticsEnabled.get() && evictionCount > 0L) {
                if (eventDispatcher != null) {
                    eventDispatcher.dispatch((XIterable<CacheEntryListenerRegistration<Object, Object>>)this.listenerRegistrations);
                }
                this.cacheStatisticsMXBean.increaseCacheEvictions(evictionCount);
            }
        }

        private void updateExpiryForAccess(CachedValue cachedValue, long now) {
            try {
                Duration duration = this.expiryPolicy.getExpiryForAccess();
                if (duration != null) {
                    cachedValue.expiryTime(duration.getAdjustedTime(now));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void updateExpiryForUpdate(CachedValue cachedValue, long now) {
            try {
                Duration duration = this.expiryPolicy.getExpiryForUpdate();
                if (duration != null) {
                    cachedValue.expiryTime(duration.getAdjustedTime(now));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void processExpiries(K key, Object internalKey, CacheEventDispatcher<K, V> eventDispatcher, V expiredValue) {
            this.cacheTable.remove(internalKey);
            if (eventDispatcher != null) {
                eventDispatcher.addEvent(CacheEntryExpiredListener.class, new CacheEvent<K, V>(this, EventType.EXPIRED, key, expiredValue, expiredValue));
            }
        }

        private Duration expiryForCreation() {
            try {
                return this.expiryPolicy.getExpiryForCreation();
            }
            catch (Throwable t) {
                return Duration.ETERNAL;
            }
        }

        private void submit(Runnable task) {
            this.executorService.submit(task);
        }

        private V loadCacheEntry(K key, V value) {
            if (this.cacheLoader != null && this.configuration.isReadThrough()) {
                try {
                    return (V)this.cacheLoader.load(key);
                }
                catch (CacheLoaderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CacheLoaderException((Throwable)e);
                }
            }
            return value;
        }

        private void writeCacheEntry(CacheEntry<K, V> entry) {
            if (this.cacheWriter != null && this.configuration.isWriteThrough()) {
                try {
                    this.cacheWriter.write(entry);
                }
                catch (CacheWriterException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CacheWriterException((Throwable)e);
                }
            }
        }

        private void deleteCacheEntry(K key) {
            if (this.cacheWriter != null && this.configuration.isWriteThrough()) {
                try {
                    this.cacheWriter.delete(key);
                }
                catch (CacheWriterException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CacheWriterException((Throwable)e);
                }
            }
        }

        private void closeIfCloseable(Object obj) {
            if (obj instanceof Closeable) {
                try {
                    ((Closeable)obj).close();
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        }

        private final class EntryIterator
        implements Iterator<Cache.Entry<K, V>> {
            private final Iterator<KeyValue<Object, CachedValue>> iterator;
            private CacheEntry<K, V> nextEntry;
            private CacheEntry<K, V> lastEntry;
            private final long now;
            private final boolean isStatisticsEnabled;

            EntryIterator(Iterator<KeyValue<Object, CachedValue>> iterator) {
                this.iterator = iterator;
                this.nextEntry = null;
                this.lastEntry = null;
                this.now = System.currentTimeMillis();
                this.isStatisticsEnabled = Default.this.isStatisticsEnabled.get();
            }

            private void fetch() {
                long start = this.isStatisticsEnabled ? System.nanoTime() : 0L;
                ObjectConverter objectConverter = Default.this.objectConverter;
                while (this.nextEntry == null && this.iterator.hasNext()) {
                    KeyValue<Object, CachedValue> entry = this.iterator.next();
                    CachedValue cachedValue = (CachedValue)entry.value();
                    Object key = objectConverter.externalize(entry.key());
                    try {
                        if (cachedValue.isExpiredAt(this.now)) continue;
                        Object value = objectConverter.externalize(cachedValue.value(this.now));
                        this.nextEntry = CacheEntry.New(key, value);
                        try {
                            Default.this.updateExpiryForAccess(cachedValue, this.now);
                        }
                        catch (Throwable throwable) {}
                    }
                    finally {
                        if (this.isStatisticsEnabled && this.nextEntry != null) {
                            CacheStatisticsMXBean cacheStatisticsMXBean = Default.this.cacheStatisticsMXBean;
                            cacheStatisticsMXBean.increaseCacheHits(1L);
                            cacheStatisticsMXBean.addGetTimeNano(System.nanoTime() - start);
                        }
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.nextEntry == null) {
                    this.fetch();
                }
                return this.nextEntry != null;
            }

            @Override
            public Cache.Entry<K, V> next() {
                if (this.hasNext()) {
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = null;
                    return this.lastEntry;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.lastEntry == null) {
                    throw new IllegalStateException("Must progress to the next entry to remove");
                }
                long start = this.isStatisticsEnabled ? System.nanoTime() : 0L;
                int cacheRemovals = 0;
                try {
                    Default.this.deleteCacheEntry(this.lastEntry.getKey());
                    this.iterator.remove();
                    ++cacheRemovals;
                    if (Default.this.listenerRegistrations.size() > 0L) {
                        CacheEventDispatcher.New().addEvent(CacheEntryRemovedListener.class, new CacheEvent<Object, Object>(Default.this, EventType.REMOVED, this.lastEntry.getKey(), this.lastEntry.getValue(), this.lastEntry.getValue())).dispatch((XIterable<CacheEntryListenerRegistration<Object, Object>>)Default.this.listenerRegistrations);
                    }
                }
                finally {
                    this.lastEntry = null;
                    if (this.isStatisticsEnabled && cacheRemovals > 0) {
                        CacheStatisticsMXBean cacheStatisticsMXBean = Default.this.cacheStatisticsMXBean;
                        cacheStatisticsMXBean.increaseCacheRemovals(cacheRemovals);
                        cacheStatisticsMXBean.addRemoveTimeNano(System.nanoTime() - start);
                    }
                }
            }
        }

        private final class KeyToValueIterator
        implements Iterator<KeyValue<Object, CachedValue>> {
            private final Iterator<K> keyIterator;
            private final CacheEventDispatcher<K, V> eventDispatcher;
            private final Reference<CachedValue> cachedValueReference;

            KeyToValueIterator(Iterator<K> keyIterator, CacheEventDispatcher<K, V> eventDispatcher) {
                this.keyIterator = keyIterator;
                this.eventDispatcher = eventDispatcher;
                this.cachedValueReference = X.Reference(null);
            }

            @Override
            public boolean hasNext() {
                return this.keyIterator.hasNext();
            }

            @Override
            public KeyValue<Object, CachedValue> next() {
                Object key = this.keyIterator.next();
                Default.this.getValue(key, this.eventDispatcher, (Reference<CachedValue>)this.cachedValueReference);
                return KeyValue.New(key, (Object)((CachedValue)this.cachedValueReference.get()));
            }
        }
    }
}

