/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import one.microstream.X;
import one.microstream.cache.exceptions.CacheConfigurationIoException;
import one.microstream.cache.exceptions.CacheConfigurationNotFoundException;
import one.microstream.chars.XChars;

@Deprecated
@FunctionalInterface
public interface CacheConfigurationLoader {
    public String loadConfiguration();

    public static String load(String path) {
        URL url;
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(path) : CacheConfigurationLoader.class.getResource(path);
        if (url != null) {
            return CacheConfigurationLoader.loadFromUrl(url);
        }
        try {
            url = new URL(path);
            return CacheConfigurationLoader.loadFromUrl(url);
        }
        catch (MalformedURLException e) {
            File file = new File(path);
            if (file.exists()) {
                return CacheConfigurationLoader.loadFromFile(file);
            }
            return null;
        }
    }

    public static String load(String path, Charset charset) {
        URL url;
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(path) : CacheConfigurationLoader.class.getResource(path);
        if (url != null) {
            return CacheConfigurationLoader.loadFromUrl(url, charset);
        }
        try {
            url = new URL(path);
            return CacheConfigurationLoader.loadFromUrl(url, charset);
        }
        catch (MalformedURLException e) {
            File file = new File(path);
            if (file.exists()) {
                return CacheConfigurationLoader.loadFromFile(file, charset);
            }
            return null;
        }
    }

    public static String loadFromPath(Path path) {
        return CacheConfigurationLoader.loadFromPath(path, Defaults.defaultCharset());
    }

    public static String loadFromPath(Path path, Charset charset) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                return CacheConfigurationLoader.FromInputStream(in, charset).loadConfiguration();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CacheConfigurationNotFoundException(e);
        }
    }

    public static String loadFromFile(File file) {
        return CacheConfigurationLoader.loadFromFile(file, Defaults.defaultCharset());
    }

    public static String loadFromFile(File file, Charset charset) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(file);){
                return CacheConfigurationLoader.FromInputStream(in, charset).loadConfiguration();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CacheConfigurationNotFoundException(e);
        }
    }

    public static String loadFromUrl(URL url) {
        return CacheConfigurationLoader.loadFromUrl(url, Defaults.defaultCharset());
    }

    public static String loadFromUrl(URL url, Charset charset) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = url.openStream();){
                return CacheConfigurationLoader.FromInputStream(in, charset).loadConfiguration();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CacheConfigurationNotFoundException(e);
        }
    }

    public static CacheConfigurationLoader FromInputStream(InputStream inputStream) {
        return CacheConfigurationLoader.FromInputStream(inputStream, Defaults.defaultCharset());
    }

    public static CacheConfigurationLoader FromInputStream(InputStream inputStream, Charset charset) {
        return new InputStreamConfigurationLoader((InputStream)X.notNull((Object)inputStream), (Charset)X.notNull((Object)charset));
    }

    public static interface Defaults {
        public static Charset defaultCharset() {
            return StandardCharsets.UTF_8;
        }
    }

    public static class InputStreamConfigurationLoader
    implements CacheConfigurationLoader {
        private final InputStream inputStream;
        private final Charset charset;

        InputStreamConfigurationLoader(InputStream inputStream, Charset charset) {
            this.inputStream = inputStream;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            try {
                return XChars.readStringFromInputStream((InputStream)this.inputStream, (Charset)this.charset);
            }
            catch (IOException e) {
                throw new CacheConfigurationIoException(e);
            }
        }
    }
}

