/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.util.Map;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import one.microstream.X;
import one.microstream.cache.types.CacheConfiguration;
import one.microstream.cache.types.CacheConfigurationPropertyNames;
import one.microstream.cache.types.CacheLoaderWriterFactories;
import one.microstream.storage.configuration.Configuration;
import one.microstream.storage.configuration.ConfigurationPropertyParser;

@Deprecated
public interface CacheConfigurationPropertyParser {
    public <K, V> void parseProperties(Map<String, String> var1, CacheConfiguration.Builder<K, V> var2);

    public static CacheConfigurationPropertyParser New() {
        return CacheConfigurationPropertyParser.New(ClassResolver.Default());
    }

    public static CacheConfigurationPropertyParser New(ClassResolver classResolver) {
        return new Default((ClassResolver)X.notNull((Object)classResolver));
    }

    @FunctionalInterface
    public static interface ClassResolver {
        public Class<?> loadClass(String var1) throws ClassNotFoundException;

        public static ClassResolver Default() {
            return Class::forName;
        }
    }

    public static class Default
    implements CacheConfigurationPropertyParser,
    CacheConfigurationPropertyNames {
        private final ClassResolver classResolver;

        Default(ClassResolver classResolver) {
            this.classResolver = classResolver;
        }

        @Override
        public <K, V> void parseProperties(Map<String, String> properties, CacheConfiguration.Builder<K, V> builder) {
            properties.entrySet().forEach(kv -> this.parseProperty((String)kv.getKey(), (String)kv.getValue(), builder));
            if (properties.get("storage-configuration-resource-name") == null) {
                this.processStorageProperties(properties, builder);
            }
        }

        protected <K, V> void parseProperty(String name, String value, CacheConfiguration.Builder<K, V> builder) {
            switch (name) {
                case "storage-configuration-resource-name": {
                    Configuration storageConfiguration = Configuration.Load((String)value);
                    if (storageConfiguration == null) {
                        throw new CacheException("Storage configuration not found: " + value);
                    }
                    CacheLoaderWriterFactories factories = CacheLoaderWriterFactories.New(storageConfiguration);
                    builder.cacheLoaderFactory(factories.loaderFactory()).cacheWriterFactory(factories.writerFactory()).writeThrough().readThrough();
                    break;
                }
                case "cache-loader-factory": {
                    builder.cacheLoaderFactory(this.valueAsFactory(value));
                    break;
                }
                case "cache-writer-factory": {
                    builder.cacheWriterFactory(this.valueAsFactory(value));
                    break;
                }
                case "expiry-policy-factory": {
                    builder.expiryPolicyFactory(this.valueAsFactory(value));
                    break;
                }
                case "eviction-manager-factory": {
                    builder.evictionManagerFactory(this.valueAsFactory(value));
                    break;
                }
                case "read-through": {
                    builder.readThrough(Boolean.valueOf(value));
                    break;
                }
                case "write-through": {
                    builder.writeThrough(Boolean.valueOf(value));
                    break;
                }
                case "store-by-value": {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.storeByValue();
                        break;
                    }
                    builder.storeByReference();
                    break;
                }
                case "statistics-enabled": {
                    if (!Boolean.valueOf(value).booleanValue()) break;
                    builder.enableStatistics();
                    break;
                }
                case "management-enabled": {
                    if (!Boolean.valueOf(value).booleanValue()) break;
                    builder.enableManagement();
                }
            }
        }

        protected <T> Factory<T> valueAsFactory(String value) {
            try {
                return (Factory)Factory.class.cast(this.classResolver.loadClass(value).newInstance());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new CacheException((Throwable)e);
            }
        }

        protected void processStorageProperties(Map<String, String> properties, CacheConfiguration.Builder builder) {
            String prefix = "storage.";
            Map<String, String> storageProperties = properties.entrySet().stream().filter(kv -> ((String)kv.getKey()).startsWith("storage.")).collect(Collectors.toMap(kv -> ((String)kv.getKey()).substring("storage.".length()), kv -> (String)kv.getValue()));
            if ((long)storageProperties.size() > 0L) {
                Configuration storageConfiguration = Configuration.Default();
                ConfigurationPropertyParser.New().parseProperties(storageProperties, storageConfiguration);
                CacheLoaderWriterFactories factories = CacheLoaderWriterFactories.New(storageConfiguration);
                builder.cacheLoaderFactory(factories.loaderFactory()).cacheWriterFactory(factories.writerFactory()).writeThrough().readThrough();
            }
        }
    }
}

