/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import javax.cache.Cache;
import one.microstream.cache.types.Unwrappable;
import one.microstream.typing.KeyValue;

public interface CacheEntry<K, V>
extends Cache.Entry<K, V>,
KeyValue<K, V>,
Unwrappable {
    default public K key() {
        return (K)this.getKey();
    }

    default public V value() {
        return (V)this.getValue();
    }

    @Override
    default public <T> T unwrap(Class<T> clazz) {
        return Unwrappable.Static.unwrap(this, clazz);
    }

    public static <K, V> CacheEntry<K, V> New(K key, V value) {
        return new Default<K, V>(key, value);
    }

    public static class Default<K, V>
    implements CacheEntry<K, V> {
        private final K key;
        private final V value;

        Default(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

