/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;

public interface CacheEntryListenerRegistration<K, V> {
    public CacheEntryListener<? super K, ? super V> getCacheEntryListener();

    public CacheEntryEventFilter<? super K, ? super V> getCacheEntryFilter();

    public CacheEntryListenerConfiguration<K, V> getConfiguration();

    public boolean isOldValueRequired();

    public boolean isSynchronous();

    public static <K, V> CacheEntryListenerRegistration<K, V> New(CacheEntryListenerConfiguration<K, V> configuration) {
        return new Default<K, V>(configuration);
    }

    public static class Default<K, V>
    implements CacheEntryListenerRegistration<K, V> {
        private final CacheEntryListenerConfiguration<K, V> configuration;
        private final CacheEntryListener<? super K, ? super V> listener;
        private final CacheEntryEventFilter<? super K, ? super V> filter;
        private final boolean oldValueRequired;
        private final boolean synchronous;

        Default(CacheEntryListenerConfiguration<K, V> configuration) {
            this.configuration = configuration;
            this.listener = (CacheEntryListener)configuration.getCacheEntryListenerFactory().create();
            this.filter = configuration.getCacheEntryEventFilterFactory() == null ? null : (CacheEntryEventFilter)configuration.getCacheEntryEventFilterFactory().create();
            this.oldValueRequired = configuration.isOldValueRequired();
            this.synchronous = configuration.isSynchronous();
        }

        @Override
        public CacheEntryListener<? super K, ? super V> getCacheEntryListener() {
            return this.listener;
        }

        @Override
        public CacheEntryEventFilter<? super K, ? super V> getCacheEntryFilter() {
            return this.filter;
        }

        @Override
        public CacheEntryListenerConfiguration<K, V> getConfiguration() {
            return this.configuration;
        }

        @Override
        public boolean isOldValueRequired() {
            return this.oldValueRequired;
        }

        @Override
        public boolean isSynchronous() {
            return this.synchronous;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
            result = 31 * result + (this.oldValueRequired ? 1231 : 1237);
            result = 31 * result + (this.synchronous ? 1231 : 1237);
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof CacheEntryListenerRegistration)) {
                return false;
            }
            CacheEntryListenerRegistration other = (CacheEntryListenerRegistration)object;
            if (this.filter == null ? other.getCacheEntryFilter() != null : !this.filter.equals(other.getCacheEntryFilter())) {
                return false;
            }
            if (this.oldValueRequired != other.isOldValueRequired()) {
                return false;
            }
            if (this.synchronous != other.isSynchronous()) {
                return false;
            }
            return !(this.listener == null ? other.getCacheEntryListener() != null : !this.listener.equals(other.getCacheEntryListener()));
        }
    }
}

