/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import one.microstream.X;
import one.microstream.cache.types.CacheEntryListenerRegistration;
import one.microstream.cache.types.CacheEvent;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XIterable;
import one.microstream.collections.types.XList;
import one.microstream.collections.types.XTable;
import one.microstream.util.cql.CQL;
import one.microstream.util.cql.CqlSelection;

public interface CacheEventDispatcher<K, V> {
    public CacheEventDispatcher<K, V> addEvent(Class<? extends CacheEntryListener> var1, CacheEvent<K, V> var2);

    public void dispatch(XIterable<CacheEntryListenerRegistration<K, V>> var1);

    public static <K, V> CacheEventDispatcher<K, V> New() {
        return new Default();
    }

    public static class Default<K, V>
    implements CacheEventDispatcher<K, V> {
        private XTable<Class<? extends CacheEntryListener>, XList<CacheEvent<K, V>>> eventMap;

        Default() {
        }

        @Override
        public synchronized CacheEventDispatcher<K, V> addEvent(Class<? extends CacheEntryListener> listenerClass, CacheEvent<K, V> event) {
            X.notNull(listenerClass);
            X.notNull(event);
            EqHashTable eventMap = this.eventMap;
            if (eventMap == null) {
                eventMap = this.eventMap = EqHashTable.New();
            }
            ((XList)eventMap.ensure(listenerClass, c -> BulkList.New())).add(event);
            return this;
        }

        @Override
        public synchronized void dispatch(XIterable<CacheEntryListenerRegistration<K, V>> registrations) {
            if (this.eventMap == null) {
                return;
            }
            this.dispatch(registrations, CacheEntryExpiredListener.class, CacheEntryExpiredListener::onExpired, true);
            this.dispatch(registrations, CacheEntryCreatedListener.class, CacheEntryCreatedListener::onCreated, false);
            this.dispatch(registrations, CacheEntryUpdatedListener.class, CacheEntryUpdatedListener::onUpdated, true);
            this.dispatch(registrations, CacheEntryRemovedListener.class, CacheEntryRemovedListener::onRemoved, true);
        }

        private <L extends CacheEntryListener<? super K, ? super V>> void dispatch(XIterable<CacheEntryListenerRegistration<K, V>> registrations, Class<L> type, BiConsumer<L, Iterable<CacheEntryEvent<? extends K, ? extends V>>> logic, boolean oldValueAvailable) {
            XList events = (XList)this.eventMap.get(type);
            if (events != null) {
                registrations.iterate(registration -> {
                    CacheEntryListener listener = registration.getCacheEntryListener();
                    if (type.isInstance(listener)) {
                        logic.accept((CacheEntryListener)type.cast(listener), this.selectEvents((CacheEntryListenerRegistration<K, V>)registration, (XList<CacheEvent<K, V>>)events, oldValueAvailable));
                    }
                });
            }
        }

        private Iterable selectEvents(CacheEntryListenerRegistration<K, V> registration, XList<CacheEvent<K, V>> events, boolean oldValueAvailable) {
            CqlSelection selection = CQL.from(events);
            CacheEntryEventFilter filter = registration.getCacheEntryFilter();
            if (filter != null) {
                selection = selection.select(e -> filter.evaluate((CacheEntryEvent)e));
            }
            return (Iterable)selection.project(e -> this.cloneEvent(registration, (CacheEvent<K, V>)e, oldValueAvailable)).into((Consumer)BulkList.New()).execute();
        }

        private CacheEvent<K, V> cloneEvent(CacheEntryListenerRegistration<K, V> registration, CacheEvent<K, V> event, boolean oldValueAvailable) {
            if (oldValueAvailable && registration.isOldValueRequired()) {
                return new CacheEvent<K, V>(event.getCache(), event.getEventType(), event.getKey(), event.getValue(), event.getOldValue());
            }
            if (event.getEventType() == EventType.REMOVED || event.getEventType() == EventType.EXPIRED) {
                return new CacheEvent<K, Object>(event.getCache(), event.getEventType(), event.getKey(), null);
            }
            return new CacheEvent<K, V>(event.getCache(), event.getEventType(), event.getKey(), event.getValue());
        }
    }
}

