/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import one.microstream.X;
import one.microstream.cache.types.Cache;
import one.microstream.cache.types.CacheConfiguration;
import one.microstream.cache.types.CachingProvider;
import one.microstream.cache.types.Unwrappable;
import one.microstream.chars.XChars;
import one.microstream.collections.EqHashTable;

public interface CacheManager
extends javax.cache.CacheManager {
    public <K, V> Cache<K, V> getCache(String var1);

    public <K, V> Cache<K, V> getCache(String var1, Class<K> var2, Class<V> var3);

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String var1, C var2) throws IllegalArgumentException;

    public CachingProvider getCachingProvider();

    public void removeCache(String var1);

    default public <T> T unwrap(Class<T> clazz) {
        return Unwrappable.Static.unwrap(this, clazz);
    }

    public static CacheManager New(CachingProvider cachingProvider, URI uri, ClassLoader classLoader, Properties properties) {
        return new Default(cachingProvider, uri, classLoader, properties);
    }

    public static class Default
    implements CacheManager {
        private final CachingProvider cachingProvider;
        private final URI uri;
        private final WeakReference<ClassLoader> classLoaderReference;
        private final Properties properties;
        private final EqHashTable<String, Cache<?, ?>> caches = EqHashTable.New();
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        Default(CachingProvider cachingProvider, URI uri, ClassLoader classLoader, Properties properties) {
            this.cachingProvider = (CachingProvider)X.notNull((Object)cachingProvider);
            this.uri = (URI)X.notNull((Object)uri);
            this.classLoaderReference = new WeakReference<ClassLoader>((ClassLoader)X.notNull((Object)classLoader));
            this.properties = new Properties();
            if (properties != null) {
                this.properties.putAll((Map<?, ?>)properties);
            }
        }

        @Override
        public CachingProvider getCachingProvider() {
            return this.cachingProvider;
        }

        public boolean isClosed() {
            return this.isClosed.get();
        }

        public URI getURI() {
            return this.uri;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoaderReference.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
            XChars.notEmpty((CharSequence)cacheName);
            X.notNull(configuration);
            if (this.getCache(cacheName) != null) {
                throw new CacheException("A cache named " + cacheName + " already exists.");
            }
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                Cache cache = Cache.New(cacheName, this, CacheConfiguration.New(configuration));
                this.caches.put((Object)cacheName, cache);
                return cache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V> Cache<K, V> getCache(String cacheName) {
            this.ensureOpen();
            X.notNull((Object)cacheName);
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                return (Cache)this.caches.get((Object)cacheName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
            Cache cache;
            this.ensureOpen();
            X.notNull(keyType);
            X.notNull(valueType);
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                cache = (Cache)this.caches.get((Object)((String)X.notNull((Object)cacheName)));
            }
            if (cache == null) {
                return null;
            }
            CompleteConfiguration configuration = (CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class);
            Class configuredKeyType = configuration.getKeyType();
            Class configuredValueType = configuration.getValueType();
            if (configuredKeyType != null && !configuredKeyType.equals(keyType)) {
                throw new ClassCastException("Incompatible key types: " + keyType + " <> " + configuredKeyType);
            }
            if (configuredValueType != null && !configuredValueType.equals(valueType)) {
                throw new ClassCastException("Incompatible value types: " + valueType + " <> " + configuredValueType);
            }
            return cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<String> getCacheNames() {
            this.ensureOpen();
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                return this.caches.keys().immure();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyCache(String cacheName) {
            Cache cache;
            this.ensureOpen();
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                cache = (Cache)this.caches.get((Object)((String)X.notNull((Object)cacheName)));
            }
            if (cache != null) {
                cache.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCache(String cacheName) {
            X.notNull((Object)cacheName);
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                this.caches.removeFor((Object)cacheName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enableManagement(String cacheName, boolean enabled) {
            this.ensureOpen();
            X.notNull((Object)cacheName);
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                ((Cache)this.caches.get((Object)cacheName)).setManagementEnabled(enabled);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enableStatistics(String cacheName, boolean enabled) {
            this.ensureOpen();
            X.notNull((Object)cacheName);
            EqHashTable<String, Cache<?, ?>> eqHashTable = this.caches;
            synchronized (eqHashTable) {
                ((Cache)this.caches.get((Object)cacheName)).setStatisticsEnabled(enabled);
            }
        }

        public synchronized void close() {
            if (this.isClosed.get()) {
                return;
            }
            this.isClosed.set(true);
            this.cachingProvider.remove(this.getURI(), this.getClassLoader());
            try {
                for (Cache cache : this.caches.values()) {
                    try {
                        cache.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.caches.clear();
            }
        }

        private void ensureOpen() {
            if (this.isClosed.get()) {
                throw new IllegalStateException("CacheManager is closed");
            }
        }
    }
}

