/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XTable;
import one.microstream.reference.Lazy;
import one.microstream.storage.types.StorageManager;

public interface CacheStore<K, V>
extends CacheLoader<K, V>,
CacheWriter<K, V> {
    public Iterator<K> keys();

    public static <K, V> CacheStore<K, V> New(String cacheKey, StorageManager storage) {
        return new Default(cacheKey, storage);
    }

    public static class Default<K, V>
    implements CacheStore<K, V> {
        private final String cacheKey;
        private final StorageManager storage;

        Default(String cacheKey, StorageManager storage) {
            this.cacheKey = (String)XChars.notEmpty((CharSequence)cacheKey);
            this.storage = (StorageManager)X.notNull((Object)storage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XTable<K, Lazy<V>> cacheTable(boolean create) {
            StorageManager storageManager = this.storage;
            synchronized (storageManager) {
                XTable cacheTable;
                if (!this.storage.isRunning()) {
                    this.storage.start();
                }
                boolean storeRoot = false;
                XTable root = (XTable)this.storage.root();
                if (root == null) {
                    root = EqHashTable.New();
                    this.storage.setRoot((Object)root);
                    storeRoot = true;
                }
                if ((cacheTable = (XTable)Lazy.get((Lazy)((Lazy)root.get((Object)this.cacheKey)))) == null && create) {
                    cacheTable = EqHashTable.New();
                    root.put((Object)this.cacheKey, (Object)Lazy.Reference((Object)cacheTable));
                    storeRoot = true;
                }
                if (storeRoot) {
                    this.storage.storeRoot();
                }
                return cacheTable;
            }
        }

        @Override
        public synchronized Iterator<K> keys() {
            XTable<K, Lazy<V>> cacheTable = this.cacheTable(false);
            return cacheTable != null ? cacheTable.keys().iterator() : Collections.emptyIterator();
        }

        public synchronized V load(K key) throws CacheLoaderException {
            try {
                XTable<K, Lazy<V>> cacheTable = this.cacheTable(false);
                return (V)(cacheTable != null ? Lazy.get((Lazy)((Lazy)cacheTable.get(key))) : null);
            }
            catch (Exception e) {
                throw new CacheLoaderException((Throwable)e);
            }
        }

        public synchronized Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
            try {
                HashMap result = new HashMap();
                XTable cacheTable = this.cacheTable(false);
                if (cacheTable != null) {
                    keys.forEach(key -> {
                        Object object = result.put(key, Lazy.get((Lazy)((Lazy)cacheTable.get(key))));
                    });
                }
                return result;
            }
            catch (Exception e) {
                throw new CacheLoaderException((Throwable)e);
            }
        }

        public synchronized void write(Cache.Entry<? extends K, ? extends V> entry) throws CacheWriterException {
            try {
                XTable<K, Lazy<V>> cacheTable = this.cacheTable(true);
                cacheTable.put(entry.getKey(), (Object)Lazy.Reference((Object)entry.getValue()));
                this.storage.store(cacheTable);
            }
            catch (Exception e) {
                throw new CacheWriterException((Throwable)e);
            }
        }

        public synchronized void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) throws CacheWriterException {
            try {
                XTable cacheTable = this.cacheTable(true);
                entries.forEach(entry -> {
                    boolean bl = cacheTable.put(entry.getKey(), (Object)Lazy.Reference((Object)entry.getValue()));
                });
                this.storage.store(cacheTable);
            }
            catch (Exception e) {
                throw new CacheWriterException((Throwable)e);
            }
        }

        public synchronized void delete(Object key) throws CacheWriterException {
            try {
                XTable<K, Lazy<V>> cacheTable = this.cacheTable(false);
                if (cacheTable != null && cacheTable.removeFor(key) != null) {
                    this.storage.store(cacheTable);
                }
            }
            catch (Exception e) {
                throw new CacheWriterException((Throwable)e);
            }
        }

        public synchronized void deleteAll(Collection<?> keys) throws CacheWriterException {
            try {
                XTable<K, Lazy<V>> cacheTable = this.cacheTable(false);
                if (cacheTable != null) {
                    boolean changed = false;
                    Iterator<?> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        Object key = iterator.next();
                        if (cacheTable.removeFor(key) == null) continue;
                        iterator.remove();
                        changed = true;
                    }
                    if (changed) {
                        this.storage.store(cacheTable);
                    }
                }
            }
            catch (Exception e) {
                throw new CacheWriterException((Throwable)e);
            }
        }
    }
}

