/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.cache.types.CachedValue;
import one.microstream.collections.EqHashTable;
import one.microstream.functional.Aggregator;
import one.microstream.typing.KeyValue;

public interface CacheTable {
    public CachedValue get(Object var1);

    public boolean put(Object var1, CachedValue var2);

    public CachedValue remove(Object var1);

    public Iterable<Object> keys();

    public Iterator<KeyValue<Object, CachedValue>> iterator();

    public void iterate(Consumer<KeyValue<Object, CachedValue>> var1);

    public KeyValue<Object, CachedValue> search(Predicate<? super KeyValue<Object, CachedValue>> var1);

    public long size();

    public void clear();

    public KeyValue<Object, CachedValue> min(Comparator<? super KeyValue<Object, CachedValue>> var1);

    public KeyValue<Object, CachedValue> rangeMin(long var1, long var3, Comparator<? super KeyValue<Object, CachedValue>> var5);

    public static CacheTable New() {
        return new Default();
    }

    public static class Default
    implements CacheTable {
        final EqHashTable<Object, CachedValue> table = EqHashTable.New();

        Default() {
        }

        @Override
        public CachedValue get(Object key) {
            return (CachedValue)this.table.get(key);
        }

        @Override
        public boolean put(Object key, CachedValue value) {
            return this.table.put(key, (Object)value);
        }

        @Override
        public CachedValue remove(Object key) {
            return (CachedValue)this.table.removeFor(key);
        }

        @Override
        public Iterable<Object> keys() {
            return this.table.keys();
        }

        @Override
        public Iterator<KeyValue<Object, CachedValue>> iterator() {
            final Iterator it = this.table.iterator();
            return new Iterator<KeyValue<Object, CachedValue>>(){
                KeyValue<Object, CachedValue> next;

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public KeyValue<Object, CachedValue> next() {
                    this.next = (KeyValue)it.next();
                    return this.next;
                }

                @Override
                public void remove() {
                    table.remove(this.next);
                }
            };
        }

        @Override
        public void iterate(Consumer<KeyValue<Object, CachedValue>> procedure) {
            this.table.iterate(procedure);
        }

        @Override
        public KeyValue<Object, CachedValue> search(Predicate<? super KeyValue<Object, CachedValue>> predicate) {
            return this.table.search(predicate);
        }

        @Override
        public long size() {
            return this.table.size();
        }

        @Override
        public void clear() {
            this.table.clear();
        }

        @Override
        public KeyValue<Object, CachedValue> min(Comparator<? super KeyValue<Object, CachedValue>> comparator) {
            return this.table.min(comparator);
        }

        @Override
        public KeyValue<Object, CachedValue> rangeMin(long offset, long length, Comparator<? super KeyValue<Object, CachedValue>> comparator) {
            return (KeyValue)((RangeMin)((Object)this.table.iterate(new RangeMin<KeyValue<Object, CachedValue>>(offset, length, comparator)))).yield();
        }

        static class RangeMin<E>
        implements Aggregator<E, E> {
            private final long offset;
            private final long length;
            private final Comparator<? super E> order;
            private long iterationOffset;
            private long iterationLength;
            private E iterationElement;

            RangeMin(long offset, long length, Comparator<? super E> order) {
                this.offset = offset;
                this.length = length;
                this.order = order;
                this.reset();
            }

            public final RangeMin<E> reset() {
                this.iterationElement = null;
                this.iterationOffset = this.offset;
                this.iterationLength = this.length;
                return this;
            }

            public final void accept(E element) {
                if (this.iterationOffset > 0L) {
                    --this.iterationOffset;
                    return;
                }
                if (this.iterationLength <= 0L) {
                    throw X.BREAK();
                }
                if (this.iterationLength-- == this.length) {
                    this.iterationElement = element;
                    return;
                }
                if (this.order.compare(element, this.iterationElement) < 0) {
                    this.iterationElement = element;
                }
            }

            public final E yield() {
                return this.iterationElement;
            }
        }
    }
}

