/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.cache.configuration.OptionalFeature;
import one.microstream.cache.types.CacheManager;

public class CachingProvider
implements javax.cache.spi.CachingProvider {
    private final WeakHashMap<ClassLoader, HashMap<URI, CacheManager>> cacheManagers = new WeakHashMap();

    public static URI defaultURI() {
        try {
            return new URI("microstream");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        return CachingProvider.defaultURI();
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    public synchronized CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI managerURI = uri == null ? this.getDefaultURI() : uri;
        ClassLoader managerClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        Properties managerProperties = properties == null ? new Properties() : properties;
        return this.cacheManagers.computeIfAbsent(managerClassLoader, cl -> new HashMap()).computeIfAbsent(managerURI, key -> CacheManager.New(this, managerURI, managerClassLoader, managerProperties));
    }

    public synchronized void close() {
        List<CacheManager> managers = this.cacheManagers.values().stream().flatMap(kv -> kv.values().stream()).collect(Collectors.toList());
        managers.forEach(javax.cache.CacheManager::close);
        this.cacheManagers.clear();
    }

    public synchronized void close(ClassLoader classLoader) {
        ClassLoader managerClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        HashMap<URI, CacheManager> cacheManagersByURI = this.cacheManagers.remove(managerClassLoader);
        if (cacheManagersByURI != null) {
            cacheManagersByURI.values().forEach(javax.cache.CacheManager::close);
        }
    }

    public synchronized void close(URI uri, ClassLoader classLoader) {
        CacheManager cacheManager;
        URI managerURI = uri == null ? this.getDefaultURI() : uri;
        ClassLoader managerClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        HashMap<URI, CacheManager> cacheManagersByURI = this.cacheManagers.get(managerClassLoader);
        if (cacheManagersByURI != null && (cacheManager = cacheManagersByURI.remove(managerURI)) != null) {
            cacheManager.close();
            if (cacheManagersByURI.size() == 0) {
                this.cacheManagers.remove(managerClassLoader);
            }
        }
    }

    synchronized void remove(URI uri, ClassLoader classLoader) {
        HashMap<URI, CacheManager> cacheManagersByURI = this.cacheManagers.get(classLoader);
        if (cacheManagersByURI != null && cacheManagersByURI.remove(uri) != null && cacheManagersByURI.size() == 0) {
            this.cacheManagers.remove(classLoader);
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        return false;
    }
}

