/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.lang.management.ManagementFactory;
import javax.cache.CacheException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import one.microstream.cache.types.Cache;

class MBeanServerUtils {
    private static MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    public static void registerCacheObject(Cache<?, ?> cache, Object bean, MBeanType beanType) {
        ObjectName objectName = MBeanServerUtils.createObjectName(cache, bean, beanType);
        try {
            if (mBeanServer.queryNames(objectName, null).isEmpty()) {
                mBeanServer.registerMBean(bean, objectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Error registering cache MXBeans for CacheManager " + objectName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }

    public static void unregisterCacheObject(Cache<?, ?> cache, Object bean, MBeanType beanType) {
        mBeanServer.queryNames(MBeanServerUtils.createObjectName(cache, bean, beanType), null).forEach(MBeanServerUtils::unregisterCacheObject);
    }

    private static void unregisterCacheObject(ObjectName objectName) {
        try {
            mBeanServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            throw new CacheException("Error unregistering object instance " + objectName, (Throwable)e);
        }
    }

    private static ObjectName createObjectName(Cache<?, ?> cache, Object bean, MBeanType beanType) {
        String cacheManagerName = MBeanServerUtils.normalize(cache.getCacheManager().getURI().toString());
        String cacheName = MBeanServerUtils.normalize(cache.getName());
        String name = "javax.cache:type=" + beanType.name() + ",CacheManager=" + cacheManagerName + ",Cache=" + cacheName;
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Illegal ObjectName for Management Bean. CacheManager=[" + cacheManagerName + "], Cache=[" + cacheName + "]", (Throwable)e);
        }
    }

    private static String normalize(String string) {
        return string == null ? "" : string.replaceAll(":|=|\n|,", ".");
    }

    private MBeanServerUtils() {
        throw new Error();
    }

    public static enum MBeanType {
        CacheConfiguration,
        CacheStatistics;

    }
}

