/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import one.microstream.X;
import one.microstream.cache.types.CacheConfigurationBuilderConfigurationBased;
import one.microstream.cache.types.CacheStore;
import one.microstream.cache.types.CachingProvider;
import one.microstream.cache.types.EvictionManager;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationLoader;
import one.microstream.configuration.types.ConfigurationParser;
import one.microstream.configuration.types.ConfigurationParserIni;
import one.microstream.persistence.binary.util.SerializerFoundation;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import one.microstream.storage.types.StorageManager;

public interface CacheConfiguration<K, V>
extends CompleteConfiguration<K, V> {
    public static String PathProperty() {
        return "microstream.cache.configuration.path";
    }

    public static String DefaultResourceName() {
        return "microstream-cache.properties";
    }

    public static CacheConfiguration<?, ?> load() {
        return CacheConfiguration.load(ConfigurationLoader.Defaults.defaultCharset());
    }

    public static CacheConfiguration<?, ?> load(Charset charset) {
        URL url;
        CacheConfiguration<?, ?> configuration;
        String path = System.getProperty(CacheConfiguration.PathProperty());
        if (!XChars.isEmpty((CharSequence)path) && (configuration = CacheConfiguration.load(path, charset)) != null) {
            return configuration;
        }
        String defaultName = CacheConfiguration.DefaultResourceName();
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(defaultName) : javax.cache.configuration.Configuration.class.getResource("/" + defaultName);
        if (url != null) {
            return CacheConfiguration.load(url, charset);
        }
        File file = new File(defaultName);
        if (file.exists()) {
            return CacheConfiguration.load(file, charset);
        }
        file = new File(System.getProperty("user.home"), defaultName);
        if (file.exists()) {
            return CacheConfiguration.load(file, charset);
        }
        return null;
    }

    public static <K, V> CacheConfiguration<K, V> load(Class<K> keyType, Class<V> valueType) {
        return CacheConfiguration.load(ConfigurationLoader.Defaults.defaultCharset(), keyType, valueType);
    }

    public static <K, V> CacheConfiguration<K, V> load(Charset charset, Class<K> keyType, Class<V> valueType) {
        URL url;
        CacheConfiguration<K, V> configuration;
        String path = System.getProperty(CacheConfiguration.PathProperty());
        if (!XChars.isEmpty((CharSequence)path) && (configuration = CacheConfiguration.load(path, charset, keyType, valueType)) != null) {
            return configuration;
        }
        String defaultName = CacheConfiguration.DefaultResourceName();
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(defaultName) : javax.cache.configuration.Configuration.class.getResource("/" + defaultName);
        if (url != null) {
            return CacheConfiguration.load(url, charset, keyType, valueType);
        }
        File file = new File(defaultName);
        if (file.exists()) {
            return CacheConfiguration.load(file, charset, keyType, valueType);
        }
        file = new File(System.getProperty("user.home"), defaultName);
        if (file.exists()) {
            return CacheConfiguration.load(file, charset, keyType, valueType);
        }
        return null;
    }

    public static CacheConfiguration<?, ?> load(String path) {
        return CacheConfiguration.load(path, ConfigurationLoader.Defaults.defaultCharset());
    }

    public static CacheConfiguration<?, ?> load(String path, Charset charset) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((String)path, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(configuration).build();
    }

    public static <K, V> CacheConfiguration<K, V> load(String path, Class<K> keyType, Class<V> valueType) {
        return CacheConfiguration.load(path, ConfigurationLoader.Defaults.defaultCharset(), keyType, valueType);
    }

    public static <K, V> CacheConfiguration<K, V> load(String path, Charset charset, Class<K> keyType, Class<V> valueType) {
        URL url;
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(path) : javax.cache.configuration.Configuration.class.getResource(path);
        if (url != null) {
            return CacheConfiguration.load(url, charset, keyType, valueType);
        }
        try {
            url = new URL(path);
            return CacheConfiguration.load(url, charset, keyType, valueType);
        }
        catch (MalformedURLException e) {
            File file = new File(path);
            if (file.exists()) {
                return CacheConfiguration.load(file, charset, keyType, valueType);
            }
            return null;
        }
    }

    public static CacheConfiguration<?, ?> load(Path path) {
        return CacheConfiguration.load(path, ConfigurationLoader.Defaults.defaultCharset());
    }

    public static CacheConfiguration<?, ?> load(Path path, Charset charset) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((Path)path, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(configuration).build();
    }

    public static CacheConfiguration<?, ?> load(File file) {
        return CacheConfiguration.load(file, ConfigurationLoader.Defaults.defaultCharset());
    }

    public static CacheConfiguration<?, ?> load(File file, Charset charset) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((File)file, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(configuration).build();
    }

    public static CacheConfiguration<?, ?> load(URL url) {
        return CacheConfiguration.load(url, ConfigurationLoader.Defaults.defaultCharset());
    }

    public static CacheConfiguration<?, ?> load(URL url, Charset charset) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((URL)url, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(configuration).build();
    }

    public static CacheConfiguration<?, ?> load(InputStream inputStream) {
        return CacheConfiguration.load(inputStream, ConfigurationLoader.Defaults.defaultCharset());
    }

    public static CacheConfiguration<?, ?> load(InputStream inputStream, Charset charset) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((InputStream)inputStream, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(configuration).build();
    }

    public static <K, V> CacheConfiguration<K, V> load(Path path, Class<K> keyType, Class<V> valueType) {
        return CacheConfiguration.load(path, ConfigurationLoader.Defaults.defaultCharset(), keyType, valueType);
    }

    public static <K, V> CacheConfiguration<K, V> load(Path path, Charset charset, Class<K> keyType, Class<V> valueType) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((Path)path, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(keyType, valueType, configuration).build();
    }

    public static <K, V> CacheConfiguration<K, V> load(File file, Class<K> keyType, Class<V> valueType) {
        return CacheConfiguration.load(file, ConfigurationLoader.Defaults.defaultCharset(), keyType, valueType);
    }

    public static <K, V> CacheConfiguration<K, V> load(File file, Charset charset, Class<K> keyType, Class<V> valueType) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((File)file, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(keyType, valueType, configuration).build();
    }

    public static <K, V> CacheConfiguration<K, V> load(URL url, Class<K> keyType, Class<V> valueType) {
        return CacheConfiguration.load(url, ConfigurationLoader.Defaults.defaultCharset(), keyType, valueType);
    }

    public static <K, V> CacheConfiguration<K, V> load(URL url, Charset charset, Class<K> keyType, Class<V> valueType) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((URL)url, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(keyType, valueType, configuration).build();
    }

    public static <K, V> CacheConfiguration<K, V> load(InputStream inputStream, Class<K> keyType, Class<V> valueType) {
        return CacheConfiguration.load(inputStream, ConfigurationLoader.Defaults.defaultCharset(), keyType, valueType);
    }

    public static <K, V> CacheConfiguration<K, V> load(InputStream inputStream, Charset charset, Class<K> keyType, Class<V> valueType) {
        Configuration configuration = Configuration.Load((ConfigurationLoader)ConfigurationLoader.New((InputStream)inputStream, (Charset)charset), (ConfigurationParser)ConfigurationParserIni.New());
        return CacheConfiguration.Builder(keyType, valueType, configuration).build();
    }

    public Factory<EvictionManager<K, V>> getEvictionManagerFactory();

    public SerializerFoundation<?> getSerializerFoundation();

    public static <K, V> Builder<K, V> Builder(Class<K> keyType, Class<V> valueType) {
        return new Builder.Default<K, V>(keyType, valueType);
    }

    public static <K, V> Builder<K, V> Builder(Class<K> keyType, Class<V> valueType, String cacheName, EmbeddedStorageManager storageManager) {
        return CacheConfiguration.Builder(keyType, valueType, CachingProvider.defaultURI(), cacheName, storageManager);
    }

    public static <K, V> Builder<K, V> Builder(Class<K> keyType, Class<V> valueType, URI uri, String cacheName, EmbeddedStorageManager storageManager) {
        X.notNull((Object)uri);
        XChars.notEmpty((CharSequence)cacheName);
        X.notNull((Object)storageManager);
        String cacheKey = uri.toString() + "::" + cacheName;
        CacheStore cacheStore = CacheStore.New(cacheKey, (StorageManager)storageManager);
        return CacheConfiguration.Builder(keyType, valueType).cacheLoaderFactory((Factory & Serializable)() -> cacheStore).cacheWriterFactory((Factory & Serializable)() -> cacheStore).readThrough().writeThrough();
    }

    public static Builder<?, ?> Builder(Configuration configuration) {
        return CacheConfigurationBuilderConfigurationBased.New().buildCacheConfiguration(configuration);
    }

    public static <K, V> Builder<K, V> Builder(Class<K> keyType, Class<V> valueType, Configuration configuration) {
        return CacheConfigurationBuilderConfigurationBased.New().buildCacheConfiguration(configuration, CacheConfiguration.Builder(keyType, valueType));
    }

    public static Factory<ExpiryPolicy> DefaultExpiryPolicyFactory() {
        return EternalExpiryPolicy.factoryOf();
    }

    public static <K, V> Factory<EvictionManager<K, V>> DefaultEvictionManagerFactory() {
        return (Factory & Serializable)() -> null;
    }

    public static <K, V> CacheConfiguration<K, V> New(javax.cache.configuration.Configuration<K, V> other) {
        HashSet listenerConfigurations = new HashSet();
        if (other instanceof CompleteConfiguration) {
            SerializerFoundation<?> serializerFoundation;
            Factory<EvictionManager<K, V>> evictionManagerFactory;
            CompleteConfiguration complete = (CompleteConfiguration)other;
            for (CacheEntryListenerConfiguration listenerConfig : complete.getCacheEntryListenerConfigurations()) {
                listenerConfigurations.add(listenerConfig);
            }
            Factory expiryPolicyFactory = (Factory)X.coalesce((Object)complete.getExpiryPolicyFactory(), CacheConfiguration.DefaultExpiryPolicyFactory());
            if (other instanceof CacheConfiguration) {
                CacheConfiguration msCacheConfig = (CacheConfiguration)other;
                evictionManagerFactory = msCacheConfig.getEvictionManagerFactory();
                serializerFoundation = msCacheConfig.getSerializerFoundation();
            } else {
                evictionManagerFactory = CacheConfiguration.DefaultEvictionManagerFactory();
                serializerFoundation = SerializerFoundation.New();
            }
            return new Default(complete.getKeyType(), complete.getValueType(), listenerConfigurations, complete.getCacheLoaderFactory(), complete.getCacheWriterFactory(), (Factory<ExpiryPolicy>)expiryPolicyFactory, evictionManagerFactory, complete.isReadThrough(), complete.isWriteThrough(), complete.isStoreByValue(), complete.isStatisticsEnabled(), complete.isManagementEnabled(), serializerFoundation);
        }
        return new Default(other.getKeyType(), other.getValueType(), listenerConfigurations, null, null, CacheConfiguration.DefaultExpiryPolicyFactory(), CacheConfiguration.DefaultEvictionManagerFactory(), false, false, other.isStoreByValue(), false, false, SerializerFoundation.New());
    }

    public static class Default<K, V>
    extends MutableConfiguration<K, V>
    implements CacheConfiguration<K, V> {
        private final Factory<EvictionManager<K, V>> evictionManagerFactory;
        private final SerializerFoundation<?> serializerFoundation;

        Default(Class<K> keyType, Class<V> valueType, HashSet<CacheEntryListenerConfiguration<K, V>> listenerConfigurations, Factory<CacheLoader<K, V>> cacheLoaderFactory, Factory<CacheWriter<? super K, ? super V>> cacheWriterFactory, Factory<ExpiryPolicy> expiryPolicyFactory, Factory<EvictionManager<K, V>> evictionManagerFactory, boolean isReadThrough, boolean isWriteThrough, boolean isStoreByValue, boolean isStatisticsEnabled, boolean isManagementEnabled, SerializerFoundation<?> serializerFoundation) {
            this.keyType = keyType;
            this.valueType = valueType;
            if (listenerConfigurations != null) {
                this.listenerConfigurations.addAll(listenerConfigurations);
            }
            this.cacheLoaderFactory = cacheLoaderFactory;
            this.cacheWriterFactory = cacheWriterFactory;
            this.expiryPolicyFactory = expiryPolicyFactory;
            this.evictionManagerFactory = evictionManagerFactory;
            this.isReadThrough = isReadThrough;
            this.isWriteThrough = isWriteThrough;
            this.isStatisticsEnabled = isStatisticsEnabled;
            this.isStoreByValue = isStoreByValue;
            this.isManagementEnabled = isManagementEnabled;
            this.serializerFoundation = serializerFoundation;
        }

        public Class<K> getKeyType() {
            return this.keyType;
        }

        public Class<V> getValueType() {
            return this.valueType;
        }

        public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
            return this.listenerConfigurations != null ? this.listenerConfigurations : Collections.emptyList();
        }

        @Override
        public Factory<EvictionManager<K, V>> getEvictionManagerFactory() {
            return this.evictionManagerFactory;
        }

        @Override
        public SerializerFoundation<?> getSerializerFoundation() {
            return this.serializerFoundation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cacheLoaderFactory == null ? 0 : this.cacheLoaderFactory.hashCode());
            result = 31 * result + (this.cacheWriterFactory == null ? 0 : this.cacheWriterFactory.hashCode());
            result = 31 * result + (this.expiryPolicyFactory == null ? 0 : this.expiryPolicyFactory.hashCode());
            result = 31 * result + (this.isManagementEnabled ? 1231 : 1237);
            result = 31 * result + (this.isReadThrough ? 1231 : 1237);
            result = 31 * result + (this.isStatisticsEnabled ? 1231 : 1237);
            result = 31 * result + (this.isStoreByValue ? 1231 : 1237);
            result = 31 * result + (this.isWriteThrough ? 1231 : 1237);
            result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
            result = 31 * result + (this.listenerConfigurations == null ? 0 : this.listenerConfigurations.hashCode());
            result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
            result = 31 * result + (this.evictionManagerFactory == null ? 0 : this.evictionManagerFactory.hashCode());
            result = 31 * result + (this.serializerFoundation == null ? 0 : this.serializerFoundation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheConfiguration)) {
                return false;
            }
            CacheConfiguration other = (CacheConfiguration)obj;
            if (this.cacheLoaderFactory == null ? other.getCacheLoaderFactory() != null : !this.cacheLoaderFactory.equals(other.getCacheLoaderFactory())) {
                return false;
            }
            if (this.cacheWriterFactory == null ? other.getCacheWriterFactory() != null : !this.cacheWriterFactory.equals(other.getCacheWriterFactory())) {
                return false;
            }
            if (this.expiryPolicyFactory == null ? other.getExpiryPolicyFactory() != null : !this.expiryPolicyFactory.equals(other.getExpiryPolicyFactory())) {
                return false;
            }
            if (this.isManagementEnabled != other.isManagementEnabled()) {
                return false;
            }
            if (this.isReadThrough != other.isReadThrough()) {
                return false;
            }
            if (this.isStatisticsEnabled != other.isStatisticsEnabled()) {
                return false;
            }
            if (this.isStoreByValue != other.isStoreByValue()) {
                return false;
            }
            if (this.isWriteThrough != other.isWriteThrough()) {
                return false;
            }
            if (this.keyType == null ? other.getKeyType() != null : !this.keyType.equals(other.getKeyType())) {
                return false;
            }
            if (this.listenerConfigurations == null ? other.getCacheEntryListenerConfigurations() != null : !this.listenerConfigurations.equals(other.getCacheEntryListenerConfigurations())) {
                return false;
            }
            if (this.valueType == null ? other.getValueType() != null : !this.valueType.equals(other.getValueType())) {
                return false;
            }
            if (this.evictionManagerFactory == null ? other.getEvictionManagerFactory() != null : !this.evictionManagerFactory.equals(other.getEvictionManagerFactory())) {
                return false;
            }
            return !(this.serializerFoundation == null ? other.getSerializerFoundation() != null : !this.serializerFoundation.equals(other.getSerializerFoundation()));
        }

        public String toString() {
            return VarString.New().add("keyType=").add(this.keyType.toString()).lf().add("valueType=").add(this.valueType.toString()).lf().add("listenerConfigurations=").add((Object)this.listenerConfigurations).lf().add("cacheLoaderFactory=").add((Object)this.cacheLoaderFactory).lf().add("cacheWriterFactory=").add((Object)this.cacheWriterFactory).lf().add("expiryPolicyFactory=").add((Object)this.expiryPolicyFactory).lf().add("isReadThrough=").add(this.isReadThrough).lf().add("isWriteThrough=").add(this.isWriteThrough).lf().add("isStatisticsEnabled=").add(this.isStatisticsEnabled).lf().add("isStoreByValue=").add(this.isStoreByValue).lf().add("isManagementEnabled=").add(this.isManagementEnabled).toString();
        }
    }

    public static interface Builder<K, V> {
        public Builder<K, V> addListenerConfiguration(CacheEntryListenerConfiguration<K, V> var1);

        public Builder<K, V> cacheLoaderFactory(Factory<CacheLoader<K, V>> var1);

        public Builder<K, V> cacheWriterFactory(Factory<CacheWriter<? super K, ? super V>> var1);

        public Builder<K, V> expiryPolicyFactory(Factory<ExpiryPolicy> var1);

        public Builder<K, V> evictionManagerFactory(Factory<EvictionManager<K, V>> var1);

        default public Builder<K, V> readThrough() {
            return this.readThrough(true);
        }

        public Builder<K, V> readThrough(boolean var1);

        default public Builder<K, V> writeThrough() {
            return this.writeThrough(true);
        }

        public Builder<K, V> writeThrough(boolean var1);

        default public Builder<K, V> storeByValue() {
            return this.storeByValue(true);
        }

        default public Builder<K, V> storeByReference() {
            return this.storeByValue(false);
        }

        public Builder<K, V> storeByValue(boolean var1);

        default public Builder<K, V> enableStatistics() {
            return this.enableStatistics(true);
        }

        default public Builder<K, V> disableStatistics() {
            return this.enableStatistics(false);
        }

        public Builder<K, V> enableStatistics(boolean var1);

        default public Builder<K, V> enableManagement() {
            return this.enableManagement(true);
        }

        default public Builder<K, V> disableManagement() {
            return this.enableManagement(false);
        }

        public Builder<K, V> enableManagement(boolean var1);

        public Builder<K, V> serializerFoundation(SerializerFoundation<?> var1);

        public CacheConfiguration<K, V> build();

        public static class Default<K, V>
        implements Builder<K, V> {
            private final Class<K> keyType;
            private final Class<V> valueType;
            private HashSet<CacheEntryListenerConfiguration<K, V>> listenerConfigurations;
            private Factory<CacheLoader<K, V>> cacheLoaderFactory;
            private Factory<CacheWriter<? super K, ? super V>> cacheWriterFactory;
            private Factory<ExpiryPolicy> expiryPolicyFactory;
            private Factory<EvictionManager<K, V>> evictionManagerFactory;
            private boolean readThrough;
            private boolean writeThrough;
            private boolean storeByValue;
            private boolean statisticsEnabled;
            private boolean managementEnabled;
            private SerializerFoundation<?> serializerFoundation;

            Default(Class<K> keyType, Class<V> valueType) {
                this.keyType = (Class)X.notNull(keyType);
                this.valueType = (Class)X.notNull(valueType);
            }

            @Override
            public Builder<K, V> addListenerConfiguration(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
                this.listenerConfigurations.add(listenerConfiguration);
                return this;
            }

            @Override
            public Builder<K, V> cacheLoaderFactory(Factory<CacheLoader<K, V>> cacheLoaderFactory) {
                this.cacheLoaderFactory = cacheLoaderFactory;
                return this;
            }

            @Override
            public Builder<K, V> cacheWriterFactory(Factory<CacheWriter<? super K, ? super V>> cacheWriterFactory) {
                this.cacheWriterFactory = cacheWriterFactory;
                return this;
            }

            @Override
            public Builder<K, V> expiryPolicyFactory(Factory<ExpiryPolicy> expiryPolicyFactory) {
                this.expiryPolicyFactory = expiryPolicyFactory;
                return this;
            }

            @Override
            public Builder<K, V> evictionManagerFactory(Factory<EvictionManager<K, V>> evictionManagerFactory) {
                this.evictionManagerFactory = evictionManagerFactory;
                return this;
            }

            @Override
            public Builder<K, V> readThrough(boolean readThrough) {
                this.readThrough = readThrough;
                return this;
            }

            @Override
            public Builder<K, V> writeThrough(boolean writeThrough) {
                this.writeThrough = writeThrough;
                return this;
            }

            @Override
            public Builder<K, V> storeByValue(boolean storeByValue) {
                this.storeByValue = storeByValue;
                return this;
            }

            @Override
            public Builder<K, V> enableStatistics(boolean statisticsEnabled) {
                this.statisticsEnabled = statisticsEnabled;
                return this;
            }

            @Override
            public Builder<K, V> enableManagement(boolean managementEnabled) {
                this.managementEnabled = managementEnabled;
                return this;
            }

            @Override
            public Builder<K, V> serializerFoundation(SerializerFoundation<?> serializerFoundation) {
                this.serializerFoundation = serializerFoundation;
                return this;
            }

            @Override
            public CacheConfiguration<K, V> build() {
                Factory expiryPolicyFactory = (Factory)X.coalesce(this.expiryPolicyFactory, CacheConfiguration.DefaultExpiryPolicyFactory());
                Factory evictionManagerFactory = (Factory)X.coalesce(this.evictionManagerFactory, CacheConfiguration.DefaultEvictionManagerFactory());
                SerializerFoundation serializerFoundation = (SerializerFoundation)X.coalesce(this.serializerFoundation, (Object)SerializerFoundation.New());
                return new one.microstream.cache.types.CacheConfiguration$Default<K, V>(this.keyType, this.valueType, this.listenerConfigurations, this.cacheLoaderFactory, this.cacheWriterFactory, (Factory<ExpiryPolicy>)expiryPolicyFactory, evictionManagerFactory, this.readThrough, this.writeThrough, this.storeByValue, this.statisticsEnabled, this.managementEnabled, serializerFoundation);
            }
        }
    }
}

