/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

public interface CacheValueValidator {
    public void validate(Object var1);

    public static CacheValueValidator New(String slot, Class<?> expectedType) {
        return expectedType == null || Object.class.equals(expectedType) ? new Simple(slot) : new Typed(slot, expectedType);
    }

    public static class Typed
    extends Simple {
        final Class<?> expectedType;

        Typed(String slot, Class<?> expectedType) {
            super(slot);
            this.expectedType = expectedType;
        }

        @Override
        public void validate(Object value) {
            super.validate(value);
            if (!this.expectedType.isInstance(value)) {
                throw new ClassCastException("Type mismatch for " + this.slot + ": " + value + " <> " + this.expectedType.getName());
            }
        }
    }

    public static class Simple
    implements CacheValueValidator {
        final String slot;

        Simple(String slot) {
            this.slot = slot;
        }

        @Override
        public void validate(Object value) {
            if (value == null) {
                throw new NullPointerException(this.slot + " cannot be null");
            }
        }
    }
}

