/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import one.microstream.cache.types.ByteSized;

public interface CachedValue {
    public long creationTime();

    public long accessTime();

    public long accessCount();

    public long modificationTime();

    public long modificationCount();

    public long expiryTime();

    public CachedValue expiryTime(long var1);

    public boolean isExpiredAt(long var1);

    public Object value();

    public Object value(long var1);

    public CachedValue value(Object var1);

    public CachedValue value(Object var1, long var2);

    public long byteSizeEstimate();

    public static CachedValue New(Object value, long creationTime, long expiryTime) {
        return new Default(value, creationTime, expiryTime);
    }

    public static class Default
    implements CachedValue {
        private Object value;
        private final long creationTime;
        private long accessTime;
        private long accessCount;
        private long modificationTime;
        private long modificationCount;
        private long expiryTime;

        Default(Object value, long creationTime, long expiryTime) {
            this.value = value;
            this.creationTime = creationTime;
            this.accessTime = creationTime;
            this.modificationTime = creationTime;
            this.expiryTime = expiryTime;
            this.accessCount = 0L;
            this.modificationCount = 0L;
        }

        @Override
        public long creationTime() {
            return this.creationTime;
        }

        @Override
        public long accessTime() {
            return this.accessTime;
        }

        @Override
        public long accessCount() {
            return this.accessCount;
        }

        @Override
        public long modificationTime() {
            return this.modificationTime;
        }

        @Override
        public long modificationCount() {
            return this.modificationCount;
        }

        @Override
        public long expiryTime() {
            return this.expiryTime;
        }

        @Override
        public CachedValue expiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        @Override
        public boolean isExpiredAt(long now) {
            long expiryTime = this.expiryTime;
            return expiryTime > -1L && expiryTime <= now;
        }

        @Override
        public Object value() {
            return this.value;
        }

        @Override
        public Object value(long accessTime) {
            this.accessTime = accessTime;
            ++this.accessCount;
            return this.value;
        }

        @Override
        public CachedValue value(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public CachedValue value(Object value, long modificationTime) {
            this.modificationTime = modificationTime;
            this.value = value;
            ++this.modificationCount;
            return this;
        }

        @Override
        public long byteSizeEstimate() {
            return this.value instanceof ByteSized ? ((ByteSized)this.value).byteSize() : -1L;
        }
    }
}

