/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.cache.types;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import one.microstream.X;
import one.microstream.cache.types.Cache;
import one.microstream.cache.types.CacheTable;
import one.microstream.cache.types.CachedValue;
import one.microstream.cache.types.EvictionPolicy;
import one.microstream.reference._longReference;
import one.microstream.typing.KeyValue;

public interface EvictionManager<K, V> {
    public void install(Cache<K, V> var1, CacheTable var2);

    public void uninstall(Cache<K, V> var1, CacheTable var2);

    public static <K, V> EvictionManager<K, V> OnEntryCreation(EvictionPolicy evictionPolicy) {
        return new OnEntryCreation(evictionPolicy);
    }

    public static <K, V> EvictionManager<K, V> Interval(EvictionPolicy evictionPolicy, long milliTimeInterval) {
        return new Interval(evictionPolicy, () -> milliTimeInterval);
    }

    public static <K, V> EvictionManager<K, V> Interval(EvictionPolicy evictionPolicy, _longReference milliTimeIntervalProvider) {
        return new Interval(evictionPolicy, milliTimeIntervalProvider);
    }

    public static class Interval<K, V>
    extends Abstract<K, V> {
        private final _longReference milliTimeIntervalProvider;
        private Cache<K, V> cache;
        private CacheTable cacheTable;
        private AtomicBoolean running = new AtomicBoolean();

        Interval(EvictionPolicy evictionPolicy, _longReference milliTimeIntervalProvider) {
            super(evictionPolicy);
            this.milliTimeIntervalProvider = milliTimeIntervalProvider;
        }

        @Override
        public void install(Cache<K, V> cache, CacheTable cacheTable) {
            this.cache = cache;
            this.cacheTable = cacheTable;
            if (!this.running.get()) {
                this.running.set(true);
                new IntervalThread(new WeakReference(this), this.milliTimeIntervalProvider).start();
            }
        }

        @Override
        public void uninstall(Cache<K, V> cache, CacheTable cacheTable) {
            this.running.set(false);
            this.cache = null;
            this.cacheTable = null;
        }

        void evict() {
            this.evict(this.cache, this.cacheTable);
        }

        static final class IntervalThread
        extends Thread {
            private final WeakReference<Interval<?, ?>> parent;
            private final _longReference milliTimeIntervalProvider;

            IntervalThread(WeakReference<Interval<?, ?>> parent, _longReference milliTimeIntervalProvider) {
                super(EvictionManager.class.getSimpleName() + "@" + System.identityHashCode(parent));
                this.parent = parent;
                this.milliTimeIntervalProvider = milliTimeIntervalProvider;
            }

            @Override
            public void run() {
                Interval parent;
                while ((parent = (Interval)this.parent.get()) != null) {
                    try {
                        if (!parent.running.get()) break;
                        parent.evict();
                        parent = null;
                        try {
                            Thread.sleep(this.milliTimeIntervalProvider.get());
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static class OnEntryCreation<K, V>
    extends Abstract<K, V> {
        private CacheEntryListenerConfiguration<K, V> listenerConfiguration;

        OnEntryCreation(EvictionPolicy evictionPolicy) {
            super(evictionPolicy);
        }

        @Override
        public void install(Cache<K, V> cache, CacheTable cacheTable) {
            if (this.listenerConfiguration == null) {
                CacheEntryCreatedListener entryCreatedListener = events -> events.forEach(event -> this.evict(cache, cacheTable));
                this.listenerConfiguration = new MutableCacheEntryListenerConfiguration((Factory & Serializable)() -> entryCreatedListener, null, false, true);
                cache.registerCacheEntryListener(this.listenerConfiguration);
            }
        }

        @Override
        public void uninstall(Cache<K, V> cache, CacheTable cacheTable) {
            if (this.listenerConfiguration != null) {
                cache.deregisterCacheEntryListener(this.listenerConfiguration);
                this.listenerConfiguration = null;
            }
        }
    }

    public static abstract class Abstract<K, V>
    implements EvictionManager<K, V> {
        final EvictionPolicy evictionPolicy;

        Abstract(EvictionPolicy evictionPolicy) {
            this.evictionPolicy = (EvictionPolicy)X.notNull((Object)evictionPolicy);
        }

        void evict(Cache<K, V> cache, CacheTable cacheTable) {
            Iterable<KeyValue<Object, CachedValue>> entriesToEvict = this.evictionPolicy.pickEntriesToEvict(cacheTable);
            if (entriesToEvict != null) {
                cache.evict(entriesToEvict);
            }
        }
    }
}

