/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingTable;
import one.microstream.configuration.exceptions.ConfigurationExceptionNoValueMapperFound;
import one.microstream.configuration.types.ConfigurationAssembler;
import one.microstream.configuration.types.ConfigurationLoader;
import one.microstream.configuration.types.ConfigurationMapper;
import one.microstream.configuration.types.ConfigurationParser;
import one.microstream.configuration.types.ConfigurationStorer;
import one.microstream.configuration.types.ConfigurationValueMapper;
import one.microstream.configuration.types.ConfigurationValueMapperProvider;
import one.microstream.typing.KeyValue;
import one.microstream.util.cql.CQL;

public interface Configuration {
    public static final char KEY_SEPARATOR = '.';

    public static Builder Builder() {
        return new Builder.Default();
    }

    public static Configuration Load(ConfigurationLoader loader, ConfigurationParser parser) {
        return Configuration.Builder().load(loader, parser).buildConfiguration();
    }

    public String get(String var1);

    default public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    default public Byte getByte(String key) {
        return this.get(key, Byte.class);
    }

    default public Short getShort(String key) {
        return this.get(key, Short.class);
    }

    default public Integer getInteger(String key) {
        return this.get(key, Integer.class);
    }

    default public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    default public Float getFloat(String key) {
        return this.get(key, Float.class);
    }

    default public Double getDouble(String key) {
        return this.get(key, Double.class);
    }

    public <T> T get(String var1, Class<T> var2);

    default public Optional<String> opt(String key) {
        return Optional.ofNullable(this.get(key));
    }

    default public Optional<Boolean> optBoolean(String key) {
        return this.opt(key, Boolean.class);
    }

    default public Optional<Byte> optByte(String key) {
        return this.opt(key, Byte.class);
    }

    default public Optional<Short> optShort(String key) {
        return this.opt(key, Short.class);
    }

    default public Optional<Integer> optInteger(String key) {
        return this.opt(key, Integer.class);
    }

    default public Optional<Long> optLong(String key) {
        return this.opt(key, Long.class);
    }

    default public Optional<Float> optFloat(String key) {
        return this.opt(key, Float.class);
    }

    default public Optional<Double> optDouble(String key) {
        return this.opt(key, Double.class);
    }

    default public <T> Optional<T> opt(String key, Class<T> type) {
        return Optional.ofNullable(this.get(key, type));
    }

    public boolean contains(String var1);

    public String key();

    public Iterable<String> keys();

    public Configuration child(String var1);

    public Iterable<? extends Configuration> children();

    public Configuration parent();

    default public boolean isRoot() {
        return this.parent() == null;
    }

    default public Configuration root() {
        Configuration parent;
        Configuration root = this;
        while ((parent = root.parent()) != null) {
            root = parent;
        }
        return root;
    }

    public void traverse(Consumer<Configuration> var1);

    public XGettingTable<String, String> table();

    public XGettingTable<String, String> coalescedTable();

    public Map<String, String> map();

    public Map<String, String> coalescedMap();

    public ConfigurationValueMapperProvider valueMapperProvider();

    public Configuration detach();

    default public void store(ConfigurationStorer storer, ConfigurationAssembler assembler) {
        storer.storeConfiguration(assembler.assemble(this).toString());
    }

    public static interface Builder {
        default public <S> Builder map(ConfigurationMapper<S> mapper, S source) {
            return mapper.mapConfiguration(this, source);
        }

        default public Builder load(ConfigurationLoader loader, ConfigurationParser parser) {
            return parser.parseConfiguration(this, loader.loadConfiguration());
        }

        public Builder valueMapperProvider(ConfigurationValueMapperProvider var1);

        public Builder set(String var1, String var2);

        public Builder setAll(XGettingCollection<KeyValue<String, String>> var1);

        public Builder setAll(KeyValue<String, String> ... var1);

        public Builder child(String var1);

        default public Builder child(String key, Consumer<Builder> childBuilder) {
            childBuilder.accept(this.child(key));
            return this;
        }

        public Configuration buildConfiguration();

        public static class Default
        implements Builder {
            private final String key;
            private ConfigurationValueMapperProvider valueMapperProvider;
            private final EqHashTable<String, Default> children = EqHashTable.New();
            private final EqHashTable<String, String> properties = EqHashTable.New();

            Default() {
                this(null);
            }

            private Default(String key) {
                this.key = key;
            }

            private Default ensureChild(String key) {
                XChars.notEmpty((CharSequence)key);
                return (Default)this.children.ensure((Object)key, Default::new);
            }

            @Override
            public Builder valueMapperProvider(ConfigurationValueMapperProvider valueMapperProvider) {
                this.valueMapperProvider = valueMapperProvider;
                return this;
            }

            @Override
            public Builder set(String key, String value) {
                XChars.notEmpty((CharSequence)key);
                X.notNull((Object)value);
                int separator = key.lastIndexOf(46);
                if (separator > 0) {
                    this.child(key.substring(0, separator)).set(key.substring(separator + 1), value);
                } else {
                    this.properties.put((Object)key, (Object)value);
                }
                return this;
            }

            @Override
            public Builder child(String key) {
                XChars.notEmpty((CharSequence)key);
                int separator = key.indexOf(46);
                if (separator > 0) {
                    return this.ensureChild(key.substring(0, separator)).child(key.substring(separator + 1));
                }
                return this.ensureChild(key);
            }

            @Override
            public Builder setAll(XGettingCollection<KeyValue<String, String>> properties) {
                properties.iterate(kv -> {
                    Builder builder = this.set((String)kv.key(), (String)kv.value());
                });
                return this;
            }

            @Override
            public Builder setAll(KeyValue<String, String> ... properties) {
                KeyValue<String, String>[] keyValueArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyValue<String, String> kv = keyValueArray[n2];
                    this.set((String)kv.key(), (String)kv.value());
                    ++n2;
                }
                return this;
            }

            @Override
            public one.microstream.configuration.types.Configuration$Default buildConfiguration() {
                ConfigurationValueMapperProvider valueMapperProvider = this.valueMapperProvider != null ? this.valueMapperProvider : ConfigurationValueMapperProvider.Default().build();
                EqHashTable children = (EqHashTable)CQL.from(this.children).project(kv -> X.KeyValue((Object)((String)kv.key()), (Object)((Default)kv.value()).buildConfiguration())).executeInto((Consumer)EqHashTable.New());
                one.microstream.configuration.types.Configuration$Default config = new one.microstream.configuration.types.Configuration$Default(this.key, (XGettingTable<String, ? extends Configuration>)children.immure(), (XGettingTable<String, String>)this.properties.immure(), valueMapperProvider);
                children.values().iterate(child -> child.setParent(config));
                return config;
            }
        }
    }

    public static class Default
    implements Configuration {
        private final String key;
        private Configuration parent;
        private final XGettingTable<String, ? extends Configuration> children;
        private final XGettingTable<String, String> properties;
        private final ConfigurationValueMapperProvider valueMapperProvider;
        private volatile transient XGettingTable<String, String> coalescedTable;

        Default(String key, XGettingTable<String, ? extends Configuration> children, XGettingTable<String, String> properties, ConfigurationValueMapperProvider valueMapperProvider) {
            this.key = key;
            this.children = children;
            this.properties = properties;
            this.valueMapperProvider = valueMapperProvider;
        }

        void setParent(Configuration parent) {
            this.parent = parent;
        }

        @Override
        public String get(String key) {
            XChars.notEmpty((CharSequence)key);
            int separator = key.lastIndexOf(46);
            if (separator > 0) {
                Configuration child = this.child(key.substring(0, separator));
                return child == null ? null : child.get(key.substring(separator + 1));
            }
            return (String)this.properties.get((Object)key);
        }

        @Override
        public Configuration child(String key) {
            XChars.notEmpty((CharSequence)key);
            int separator = key.indexOf(46);
            if (separator > 0) {
                Configuration child = (Configuration)this.children.get((Object)key.substring(0, separator));
                return child == null ? null : child.child(key.substring(separator + 1));
            }
            return (Configuration)this.children.get((Object)key);
        }

        @Override
        public <T> T get(String key, Class<T> type) {
            X.notNull(type);
            String value = this.get(key);
            if (value == null) {
                return null;
            }
            ConfigurationValueMapper<T> mapper = this.valueMapperProvider.get(type);
            if (mapper == null) {
                throw new ConfigurationExceptionNoValueMapperFound((Configuration)this, type);
            }
            return mapper.map(this, key, value);
        }

        @Override
        public boolean contains(String key) {
            return this.get(key) != null;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Iterable<String> keys() {
            return this.properties.keys();
        }

        @Override
        public Iterable<? extends Configuration> children() {
            return this.children.values();
        }

        @Override
        public Configuration parent() {
            return this.parent;
        }

        @Override
        public void traverse(Consumer<Configuration> consumer) {
            consumer.accept(this);
            this.children.values().forEach(child -> child.traverse(consumer));
        }

        @Override
        public XGettingTable<String, String> table() {
            return this.properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XGettingTable<String, String> coalescedTable() {
            XGettingTable<String, String> coalescedTable = this.coalescedTable;
            if (coalescedTable == null) {
                Default default_ = this;
                synchronized (default_) {
                    coalescedTable = this.coalescedTable;
                    if (coalescedTable == null) {
                        coalescedTable = this.coalescedTable = this.createCoalescedTable();
                    }
                }
            }
            return coalescedTable;
        }

        private XGettingTable<String, String> createCoalescedTable() {
            EqHashTable coalescedTable = EqHashTable.New();
            if (this.key == null) {
                coalescedTable.putAll(this.properties);
            } else {
                this.properties.iterate(kv -> coalescedTable.put((Object)VarString.New().add(this.key).add('.').add((String)kv.key()).toString(), (Object)((String)kv.value())));
            }
            this.children.values().iterate(child -> {
                XGettingTable<String, String> childTable = child.coalescedTable();
                childTable.iterate(kv -> {
                    String coalescedKey = this.key == null ? (String)kv.key() : VarString.New().add(this.key).add('.').add((String)kv.key()).toString();
                    coalescedTable.put((Object)coalescedKey, (Object)((String)kv.value()));
                });
            });
            return coalescedTable.immure();
        }

        @Override
        public Map<String, String> map() {
            return this.toMap(this.properties);
        }

        @Override
        public Map<String, String> coalescedMap() {
            return this.toMap(this.coalescedTable());
        }

        private Map<String, String> toMap(XGettingTable<String, String> table) {
            HashMap<String, String> map = new HashMap<String, String>(table.intSize());
            table.iterate(kv -> {
                String string = map.put((String)kv.key(), (String)kv.value());
            });
            return map;
        }

        @Override
        public ConfigurationValueMapperProvider valueMapperProvider() {
            return this.valueMapperProvider;
        }

        @Override
        public Configuration detach() {
            return new Default(this.key, this.children, this.properties, this.valueMapperProvider);
        }
    }
}

