/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import one.microstream.chars.VarString;
import one.microstream.configuration.exceptions.ConfigurationException;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationAssembler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface ConfigurationAssemblerXml
extends ConfigurationAssembler {
    public static ConfigurationAssemblerXml New() {
        return new Default();
    }

    public static class Default
    implements ConfigurationAssemblerXml {
        Default() {
        }

        @Override
        public VarString assemble(VarString vs, Configuration configuration) {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element rootElement = document.createElement("configuration");
                document.appendChild(rootElement);
                this.assemble(document, rootElement, configuration);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(new DOMSource(document), new StreamResult(new VarStringWriter(vs)));
            }
            catch (ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError e) {
                throw new ConfigurationException(configuration, e);
            }
            return vs;
        }

        private void assemble(Document document, Element parent, Configuration configuration) {
            configuration.keys().forEach(key -> {
                Element element2 = document.createElement((String)key);
                element2.appendChild(document.createTextNode(configuration.get((String)key)));
                parent.appendChild(element2);
            });
            configuration.children().forEach(child -> {
                Element element2 = document.createElement(child.key());
                parent.appendChild(element2);
                this.assemble(document, element2, (Configuration)child);
            });
        }

        static class VarStringWriter
        extends Writer {
            final VarString vs;

            VarStringWriter(VarString vs) {
                this.vs = vs;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.vs.add(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }
    }
}

