/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.configuration.exceptions.ConfigurationExceptionNoConfigurationFound;
import one.microstream.exceptions.IORuntimeException;

@FunctionalInterface
public interface ConfigurationLoader {
    public String loadConfiguration();

    public static ConfigurationLoader New(String path) {
        return ConfigurationLoader.New(path, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(String path, Charset charset) {
        URL url;
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(path) : ConfigurationLoader.class.getResource(path);
        if (url != null) {
            return ConfigurationLoader.New(url, charset);
        }
        try {
            return ConfigurationLoader.New(new URL(path), charset);
        }
        catch (MalformedURLException e) {
            File file = new File(path);
            if (file.exists()) {
                return ConfigurationLoader.New(file, charset);
            }
            throw new ConfigurationExceptionNoConfigurationFound("No configuration found at: " + path);
        }
    }

    public static ConfigurationLoader New(Path path) {
        return ConfigurationLoader.New(path, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(Path path, Charset charset) {
        return new PathLoader((Path)X.notNull((Object)path), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationLoader New(File file) {
        return ConfigurationLoader.New(file, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(File file, Charset charset) {
        return new FileLoader((File)X.notNull((Object)file), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationLoader New(URL url) {
        return ConfigurationLoader.New(url, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(URL url, Charset charset) {
        return new UrlLoader((URL)X.notNull((Object)url), (Charset)X.notNull((Object)charset));
    }

    public static ConfigurationLoader New(InputStream inputStream) {
        return ConfigurationLoader.New(inputStream, Defaults.defaultCharset());
    }

    public static ConfigurationLoader New(InputStream inputStream, Charset charset) {
        return new InputStreamLoader((InputStream)X.notNull((Object)inputStream), (Charset)X.notNull((Object)charset));
    }

    public static interface Defaults {
        public static Charset defaultCharset() {
            return StandardCharsets.UTF_8;
        }
    }

    public static class FileLoader
    implements ConfigurationLoader {
        private final File file;
        private final Charset charset;

        FileLoader(File file, Charset charset) {
            this.file = file;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (FileInputStream in = new FileInputStream(this.file);){
                    return XChars.readStringFromInputStream((InputStream)in, (Charset)this.charset);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static class InputStreamLoader
    implements ConfigurationLoader {
        private final InputStream inputStream;
        private final Charset charset;

        InputStreamLoader(InputStream inputStream, Charset charset) {
            this.inputStream = inputStream;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            try {
                return XChars.readStringFromInputStream((InputStream)this.inputStream, (Charset)this.charset);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static class PathLoader
    implements ConfigurationLoader {
        private final Path path;
        private final Charset charset;

        PathLoader(Path path, Charset charset) {
            this.path = path;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream in = Files.newInputStream(this.path, new OpenOption[0]);){
                    return XChars.readStringFromInputStream((InputStream)in, (Charset)this.charset);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }

    public static class UrlLoader
    implements ConfigurationLoader {
        private final URL url;
        private final Charset charset;

        UrlLoader(URL url, Charset charset) {
            this.url = url;
            this.charset = charset;
        }

        @Override
        public String loadConfiguration() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream in = this.url.openStream();){
                    return XChars.readStringFromInputStream((InputStream)in, (Charset)this.charset);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }
}

