/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import java.util.function.Function;
import one.microstream.X;
import one.microstream.collections.types.XGettingTable;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationMapper;

public interface ConfigurationMapperTable<V>
extends ConfigurationMapper<XGettingTable<String, V>> {
    public static <V> ConfigurationMapperTable<V> New() {
        return new Default(Object::toString);
    }

    public static <V> ConfigurationMapperTable<V> New(Function<Object, String> toStringMapper) {
        return new Default((Function)X.notNull(toStringMapper));
    }

    public static class Default<V>
    implements ConfigurationMapperTable<V> {
        private final Function<Object, String> toStringMapper;

        Default(Function<Object, String> toStringMapper) {
            this.toStringMapper = toStringMapper;
        }

        @Override
        public Configuration.Builder mapConfiguration(Configuration.Builder builder, XGettingTable<String, V> source) {
            this.mapConfiguration(builder, source, "");
            return builder;
        }

        private void mapConfiguration(Configuration.Builder builder, XGettingTable<String, V> source, String prefix) {
            source.iterate(kv -> {
                String key = prefix.concat((String)kv.key());
                Object value = kv.value();
                if (value instanceof XGettingTable) {
                    this.mapConfiguration(builder, (XGettingTable)value, String.valueOf(key) + '.');
                } else if (value != null) {
                    builder.set(key, this.toStringMapper.apply(value));
                }
            });
        }
    }
}

