/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import one.microstream.chars.XChars;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationMapper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public interface ConfigurationMapperXml
extends ConfigurationMapper<Element> {
    public static ConfigurationMapperXml New() {
        return new Default();
    }

    public static class Default
    implements ConfigurationMapperXml {
        Default() {
        }

        @Override
        public Configuration.Builder mapConfiguration(Configuration.Builder builder, Element source) {
            if (this.isFlatLayout(source)) {
                this.mapFlat(builder, source);
            } else {
                this.mapDeep(builder, source, "");
            }
            return builder;
        }

        private boolean isFlatLayout(Element source) {
            if (!source.getTagName().equalsIgnoreCase("properties")) {
                return false;
            }
            NodeList childNodes = source.getChildNodes();
            int i = 0;
            int c = childNodes.getLength();
            while (i < c) {
                Element element;
                Node node = childNodes.item(i);
                if (node instanceof Element && !(element = (Element)node).getTagName().equalsIgnoreCase("property")) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void mapFlat(Configuration.Builder builder, Element source) {
            NodeList propertyNodes = source.getElementsByTagName("property");
            int i = 0;
            int c = propertyNodes.getLength();
            while (i < c) {
                Element propertyElement = (Element)propertyNodes.item(i);
                String name = (String)XChars.notEmpty((CharSequence)propertyElement.getAttribute("name").trim());
                String value = (String)XChars.notEmpty((CharSequence)propertyElement.getAttribute("value").trim());
                builder.set(name, value);
                ++i;
            }
        }

        private void mapDeep(Configuration.Builder builder, Element documentElement, String prefix) {
            NodeList childNodes = documentElement.getChildNodes();
            int i = 0;
            int c = childNodes.getLength();
            while (i < c) {
                Node node = childNodes.item(i);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    String tagName = element.getTagName();
                    String key = prefix.concat(tagName);
                    String value = this.getTextValue(element);
                    if (value != null) {
                        builder.set(key, value);
                    }
                    this.mapDeep(builder, element, String.valueOf(key) + '.');
                }
                ++i;
            }
        }

        private String getTextValue(Element element) {
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            int c = childNodes.getLength();
            while (i < c) {
                String text;
                Node node = childNodes.item(i);
                if (node instanceof Text && !XChars.isEmpty((CharSequence)(text = node.getTextContent().trim()))) {
                    return text;
                }
                ++i;
            }
            return null;
        }
    }
}

