/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import one.microstream.X;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationMapperXml;
import one.microstream.configuration.types.ConfigurationParser;
import one.microstream.exceptions.IORuntimeException;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public interface ConfigurationParserXml
extends ConfigurationParser {
    public static ConfigurationParserXml New() {
        return new Default(ConfigurationMapperXml.New());
    }

    public static ConfigurationParserXml New(ConfigurationMapperXml mapper) {
        return new Default((ConfigurationMapperXml)X.notNull((Object)mapper));
    }

    public static class Default
    implements ConfigurationParserXml {
        private final ConfigurationMapperXml mapper;

        Default(ConfigurationMapperXml mapper) {
            this.mapper = mapper;
        }

        @Override
        public Configuration.Builder parseConfiguration(Configuration.Builder builder, String input) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Element element = factory.newDocumentBuilder().parse(new InputSource(new StringReader(input))).getDocumentElement();
                return this.mapper.mapConfiguration(builder, element);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }
}

