/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.microstream.X;
import one.microstream.configuration.types.ByteSize;
import one.microstream.configuration.types.ByteUnit;

@FunctionalInterface
public interface ByteSizeParser {
    public ByteSize parse(String var1);

    public static ByteSizeParser New() {
        return new Default(ByteUnit.B);
    }

    public static ByteSizeParser New(ByteUnit defaultUnit) {
        return new Default((ByteUnit)((Object)X.notNull((Object)((Object)defaultUnit))));
    }

    public static class Default
    implements ByteSizeParser {
        private final Pattern pattern = Pattern.compile("(?<amount>[0-9]*\\.?[0-9]*([eE][-+]?[0-9]+)?)(?:\\s*)(?<unit>[a-z]+)", 2);
        private final ByteUnit defaultUnit;

        Default(ByteUnit defaultUnit) {
            this.defaultUnit = defaultUnit;
        }

        @Override
        public ByteSize parse(String text) {
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.find()) {
                return this.parseWithUnit(matcher.group("amount"), matcher.group("unit"));
            }
            try {
                return ByteSize.New(Double.parseDouble(text), this.defaultUnit);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid byte size: " + text, nfe);
            }
        }

        private ByteSize parseWithUnit(String amountText, String unitText) {
            double amount;
            try {
                amount = Double.parseDouble(amountText);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid byte size: " + amountText + unitText, nfe);
            }
            ByteUnit byteMultiple = ByteUnit.ofName(unitText);
            if (byteMultiple == null) {
                throw new IllegalArgumentException("Invalid byte size: " + amountText + unitText + ", unknown unit: " + unitText);
            }
            return ByteSize.New(amount, byteMultiple);
        }
    }
}

