/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.configuration.types;

import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import one.microstream.X;
import one.microstream.configuration.types.Configuration;

public interface ConfigurationBasedCreator<T> {
    public Class<?> resultType();

    public T create(Configuration var1);

    public static <T> List<ConfigurationBasedCreator<T>> registeredCreators(Class<T> resultType) {
        return StreamSupport.stream(ServiceLoader.load(ConfigurationBasedCreator.class).spliterator(), false).filter(creator -> resultType.isAssignableFrom(creator.resultType())).collect(Collectors.toList());
    }

    public static abstract class Abstract<T>
    implements ConfigurationBasedCreator<T> {
        private final Class<T> resultType;

        protected Abstract(Class<T> resultType) {
            this.resultType = (Class)X.notNull(resultType);
        }

        @Override
        public Class<?> resultType() {
            return this.resultType;
        }
    }
}

