/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;

public enum ConfigurationCoreProperties {
    STORAGE_DIRECTORY("one.microstream.storage.directory", "storage-directory"),
    STORAGE_FILESYSTEM("one.microstream.storage.filesystem", "storage-filesystem"),
    DELETION_DIRECTORY("one.microstream.deletion.directory", "deletion-directory"),
    TRUNCATION_DIRECTORY("one.microstream.truncation.directory", "truncation-directory"),
    BACKUP_DIRECTORY("one.microstream.backup.directory", "backup-directory"),
    BACKUP_FILESYSTEM("one.microstream.backup.filesystem", "backup-filesystem"),
    CHANNEL_COUNT("one.microstream.channel.count", "channel-count"),
    CHANNEL_DIRECTORY_PREFIX("one.microstream.channel.directory.prefix", "channel-directory-prefix"),
    DATA_FILE_PREFIX("one.microstream.data.file.prefix", "data-file-prefix"),
    DATA_FILE_SUFFIX("one.microstream.data.file.suffix", "data-file-suffix"),
    TRANSACTION_FILE_PREFIX("one.microstream.transaction.file.prefix", "transaction-file-prefix"),
    TRANSACTION_FILE_SUFFIX("one.microstream.transaction.file.suffix", "transaction-file-suffix"),
    TYPE_DICTIONARY_FILE_NAME("one.microstream.type.dictionary.file.name", "type-dictionary-file-name"),
    RESCUED_FILE_SUFFIX("one.microstream.rescued.file.suffix", "rescued-file-suffix"),
    LOCK_FILE_NAME("one.microstream.lock.file.name", "lock-file-name"),
    HOUSEKEEPING_INTERVAL("one.microstream.housekeeping.interval", "housekeeping-interval"),
    HOUSEKEEPING_TIME_BUDGET("one.microstream.housekeeping.time.budget", "housekeeping-time-budget"),
    ENTITY_CACHE_THRESHOLD("one.microstream.entity.cache.threshold", "entity-cache-threshold"),
    ENTITY_CACHE_TIMEOUT("one.microstream.entity.cache.timeout", "entity-cache-timeout"),
    DATA_FILE_MINIMUM_SIZE("one.microstream.data.file.minimum.size", "data-file-minimum-size"),
    DATA_FILE_MAXIMUM_SIZE("one.microstream.data.file.maximum.size", "data-file-maximum-size"),
    DATA_FILE_MINIMUM_USE_RATIO("one.microstream.data.file.minimum.use.ratio", "data-file-minimum-use-ratio"),
    DATA_FILE_CLEANUP_HEAD_FILE("one.microstream.data.file.cleanup.head.file", "data-file-cleanup-head-file"),
    CUSTOM("one.microstream.property", "");

    private final String microprofile;
    private final String microstream;

    private ConfigurationCoreProperties(String microprofile, String microstream) {
        this.microprofile = microprofile;
        this.microstream = microstream;
    }

    public String getMicroprofile() {
        return this.microprofile;
    }

    public String getMicrostream() {
        return this.microstream;
    }

    public boolean isCustom() {
        return this.microstream.isBlank();
    }

    boolean isMapped() {
        return !this.isCustom();
    }

    public static Map<String, String> getProperties(Config config) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Arrays.stream(ConfigurationCoreProperties.values()).filter(ConfigurationCoreProperties::isMapped).forEach(p -> ConfigurationCoreProperties.addProperty(config, properties, p));
        StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(k -> k.contains(CUSTOM.getMicroprofile())).forEach(k -> {
            String key = k.split(String.valueOf(CUSTOM.getMicroprofile()) + ".")[1];
            String value = (String)config.getValue(k, String.class);
            properties.put(key, value);
        });
        return properties;
    }

    private static void addProperty(Config config, Map<String, String> properties, ConfigurationCoreProperties property) {
        config.getOptionalValue(property.getMicroprofile(), String.class).ifPresent(v -> {
            String string = properties.put(property.getMicrostream(), (String)v);
        });
    }

    private static class Constants {
        static final String PREFIX = "one.microstream.";

        private Constants() {
        }
    }
}

