/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types;

import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import one.microstream.integrations.cdi.types.ConfigurationCoreProperties;
import one.microstream.storage.embedded.configuration.types.EmbeddedStorageConfigurationBuilder;
import one.microstream.storage.types.StorageManager;
import org.eclipse.microprofile.config.Config;

@ApplicationScoped
class StorageManagerProducer {
    private static final Logger LOGGER = Logger.getLogger(StorageManagerProducer.class.getName());
    @Inject
    private Config config;

    StorageManagerProducer() {
    }

    @Produces
    @ApplicationScoped
    public StorageManager getStoreManager() {
        Map<String, String> properties = ConfigurationCoreProperties.getProperties(this.config);
        LOGGER.info("Loading default StorageManager loading from MicroProfile Config properties. The keys: " + properties.keySet());
        EmbeddedStorageConfigurationBuilder builder = EmbeddedStorageConfigurationBuilder.New();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            builder.set(entry.getKey(), entry.getValue());
        }
        return builder.createEmbeddedStorageFoundation().start();
    }

    public void dispose(@Disposes StorageManager manager) {
        LOGGER.info("Closing the default StorageManager");
        manager.close();
    }
}

