/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.cache;

import java.util.Objects;
import java.util.function.Supplier;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import one.microstream.reflect.XReflect;
import org.eclipse.microprofile.config.Config;

public enum CacheProperties implements Supplier<String>
{
    PREFIX("one.microstream."),
    CACHE_LOADER_FACTORY(PREFIX + "cache.loader.factory"),
    CACHE_WRITER_FACTORY(PREFIX + "cache.writer.factory"),
    CACHE_EXPIRES_FACTORY(PREFIX + "cache.expires.factory"),
    CACHE_READ_THROUGH(PREFIX + "cache.read.through"),
    CACHE_WRITE_THROUGH(PREFIX + "cache.write.through"),
    CACHE_STORE_VALUE(PREFIX + "cache.store.value"),
    CACHE_STATISTICS(PREFIX + "cache.statistics"),
    CACHE_MANAGEMENT(PREFIX + "cache.management"),
    STORAGE(PREFIX + "store");

    private final String value;

    private CacheProperties(String value) {
        this.value = value;
    }

    static boolean isStoreByValue(Config config) {
        return CacheProperties.getBoolean(config, CACHE_STORE_VALUE);
    }

    static boolean isWriteThrough(Config config) {
        return CacheProperties.getBoolean(config, CACHE_WRITE_THROUGH);
    }

    static boolean isReadThrough(Config config) {
        return CacheProperties.getBoolean(config, CACHE_READ_THROUGH);
    }

    static boolean isManagementEnabled(Config config) {
        return CacheProperties.getBoolean(config, CACHE_MANAGEMENT);
    }

    static boolean isStatisticsEnabled(Config config) {
        return CacheProperties.getBoolean(config, CACHE_STATISTICS);
    }

    static boolean isStorage(Config config) {
        return CacheProperties.getBoolean(config, STORAGE);
    }

    static <V, K> Factory<CacheLoader<K, V>> getLoaderFactory(Config config) {
        Objects.requireNonNull(config, "Config is required");
        String factoryClass = config.getOptionalValue(CACHE_LOADER_FACTORY.get(), String.class).orElse("");
        return (Factory)CacheProperties.getFactoryClass(factoryClass);
    }

    static <V, K> Factory<CacheWriter<K, V>> getWriterFactory(Config config) {
        Objects.requireNonNull(config, "Config is required");
        String factoryClass = config.getOptionalValue(CACHE_WRITER_FACTORY.get(), String.class).orElse("");
        return (Factory)CacheProperties.getFactoryClass(factoryClass);
    }

    static Factory<ExpiryPolicy> getExpiryFactory(Config config) {
        Objects.requireNonNull(config, "Config is required");
        String factoryClass = config.getOptionalValue(CACHE_EXPIRES_FACTORY.get(), String.class).orElse("");
        return (Factory)CacheProperties.getFactoryClass(factoryClass);
    }

    private static Boolean getBoolean(Config config, CacheProperties cacheStatistics) {
        Objects.requireNonNull(config, "Config is required");
        return config.getOptionalValue(cacheStatistics.get(), Boolean.TYPE).orElse(false);
    }

    private static <T> T getFactoryClass(String className) {
        if (className.isBlank()) {
            return null;
        }
        try {
            Class<?> factory = Class.forName(className);
            Object instance = XReflect.defaultInstantiate(factory);
            if (instance instanceof Factory) {
                return (T)instance;
            }
            throw new IllegalArgumentException("The instance class must be a " + Factory.class.getName() + " implementation, please check the class: " + className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String get() {
        return this.value;
    }
}

