/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.cache;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.enterprise.inject.Instance;
import one.microstream.integrations.cdi.types.cache.CacheProperties;
import one.microstream.integrations.cdi.types.cache.StorageCacheProperty;
import one.microstream.storage.types.StorageManager;
import org.eclipse.microprofile.config.Config;

class MutableConfigurationSupplier<K, V>
implements Supplier<MutableConfiguration<K, V>> {
    private static final Logger LOGGER = Logger.getLogger(MutableConfigurationSupplier.class.getName());
    private final StorageCacheProperty<K, V> cacheProperty;
    private final boolean storeByValue;
    private final boolean writeThrough;
    private final boolean readThrough;
    private final boolean managementEnabled;
    private final boolean statisticsEnabled;
    private final boolean storage;
    private final Factory<CacheLoader<K, V>> loaderFactory;
    private final Factory<CacheWriter<K, V>> writerFactory;
    private final Factory<ExpiryPolicy> expiryFactory;
    private final Instance<StorageManager> storageManager;

    private MutableConfigurationSupplier(StorageCacheProperty<K, V> cacheProperty, boolean storeByValue, boolean writeThrough, boolean readThrough, boolean managementEnabled, boolean statisticsEnabled, boolean storage, Factory<CacheLoader<K, V>> loaderFactory, Factory<CacheWriter<K, V>> writerFactory, Factory<ExpiryPolicy> expiryFactory, Instance<StorageManager> storageManager) {
        this.cacheProperty = cacheProperty;
        this.storeByValue = storeByValue;
        this.writeThrough = writeThrough;
        this.readThrough = readThrough;
        this.managementEnabled = managementEnabled;
        this.statisticsEnabled = statisticsEnabled;
        this.loaderFactory = loaderFactory;
        this.writerFactory = writerFactory;
        this.expiryFactory = expiryFactory;
        this.storage = storage;
        this.storageManager = storageManager;
    }

    public static <K, V> MutableConfigurationSupplier<K, V> of(StorageCacheProperty<K, V> cacheProperty, Config config, Instance<StorageManager> storageManager) {
        boolean storeByValue = CacheProperties.isStoreByValue(config);
        boolean writeThrough = CacheProperties.isWriteThrough(config);
        boolean readThrough = CacheProperties.isReadThrough(config);
        boolean managementEnabled = CacheProperties.isManagementEnabled(config);
        boolean statisticsEnabled = CacheProperties.isStatisticsEnabled(config);
        boolean storage = CacheProperties.isStorage(config);
        Factory loaderFactory = CacheProperties.getLoaderFactory(config);
        Factory writerFactory = CacheProperties.getWriterFactory(config);
        Factory<ExpiryPolicy> expiryFactory = CacheProperties.getExpiryFactory(config);
        return new MutableConfigurationSupplier<K, V>(cacheProperty, storeByValue, writeThrough, readThrough, managementEnabled, statisticsEnabled, storage, loaderFactory, writerFactory, expiryFactory, storageManager);
    }

    @Override
    public MutableConfiguration<K, V> get() {
        Class<K> key = this.cacheProperty.getKey();
        Class<V> value = this.cacheProperty.getValue();
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(key, value);
        configuration.setStoreByValue(this.storeByValue).setWriteThrough(this.writeThrough).setReadThrough(this.readThrough).setManagementEnabled(this.managementEnabled).setStatisticsEnabled(this.statisticsEnabled);
        if (Objects.nonNull(this.loaderFactory)) {
            configuration.setCacheLoaderFactory(this.loaderFactory);
        }
        if (Objects.nonNull(this.writerFactory)) {
            configuration.setCacheWriterFactory(this.writerFactory);
        }
        if (Objects.nonNull(this.expiryFactory)) {
            configuration.setExpiryPolicyFactory(this.expiryFactory);
        }
        if (this.storage) {
            LOGGER.warning("The storage option is disable so, we'll ignore this option");
        }
        return configuration;
    }

    public String toString() {
        return "MutableConfigurationSupplier{cacheProperty=" + this.cacheProperty + ", storeByValue=" + this.storeByValue + ", writeThrough=" + this.writeThrough + ", readThrough=" + this.readThrough + ", managementEnabled=" + this.managementEnabled + ", statisticsEnabled=" + this.statisticsEnabled + ", storage=" + this.storage + ", loaderFactory=" + this.loaderFactory + ", writerFactory=" + this.writerFactory + ", expiryFactory=" + this.expiryFactory + '}';
    }
}

