/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.cache;

import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import one.microstream.integrations.cdi.types.cache.MutableConfigurationSupplier;
import one.microstream.integrations.cdi.types.cache.StorageCache;
import one.microstream.integrations.cdi.types.cache.StorageCacheProperty;
import one.microstream.storage.types.StorageManager;
import org.eclipse.microprofile.config.Config;

@ApplicationScoped
class StorageCacheProducer {
    private static final Logger LOGGER = Logger.getLogger(StorageCacheProducer.class.getName());
    private static final String CACHE_PROVIDER = "one.microstream.cache.types.CachingProvider";
    private CachingProvider provider;
    private CacheManager cacheManager;
    @Inject
    private Config config;
    @Inject
    private Instance<StorageManager> storageManager;

    StorageCacheProducer() {
    }

    @PostConstruct
    void setUp() {
        this.provider = Caching.getCachingProvider((String)CACHE_PROVIDER);
        this.cacheManager = this.provider.getCacheManager();
    }

    @Produces
    @StorageCache
    @ApplicationScoped
    CachingProvider getProvider() {
        return this.provider;
    }

    @Produces
    @StorageCache
    @ApplicationScoped
    CacheManager getManager() {
        return this.cacheManager;
    }

    @Produces
    @StorageCache
    public <K, V> Cache<K, V> producer(InjectionPoint injectionPoint) {
        Cache cache;
        StorageCacheProperty cacheProperty = StorageCacheProperty.of(injectionPoint);
        String name = cacheProperty.getName();
        Class key = cacheProperty.getKey();
        Class value = cacheProperty.getValue();
        LOGGER.info("Loading cache: " + name + " the current caches: " + this.cacheManager.getCacheNames());
        if (Objects.isNull(this.cacheManager.getCache(name, key, value))) {
            MutableConfigurationSupplier supplier = MutableConfigurationSupplier.of(cacheProperty, this.config, this.storageManager);
            LOGGER.info("Cache " + name + " does not exist. Creating with configuration: " + supplier);
            MutableConfiguration configuration = supplier.get();
            cache = this.cacheManager.createCache(name, configuration);
        } else {
            cache = this.cacheManager.getCache(name);
        }
        return cache;
    }

    public void close(@Disposes @StorageCache CachingProvider provider) {
        provider.close();
    }

    public void close(@Disposes @StorageCache CacheManager manager) {
        manager.close();
    }
}

