/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import one.microstream.integrations.cdi.types.cache.StorageCache;

class StorageCacheProperty<K, V> {
    private final Class<K> key;
    private final Class<V> value;
    private final String name;

    private StorageCacheProperty(Class<K> key, Class<V> value, String name) {
        this.key = key;
        this.value = value;
        this.name = name;
    }

    public Class<K> getKey() {
        return this.key;
    }

    public Class<V> getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageCacheProperty that = (StorageCacheProperty)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.name);
    }

    public String toString() {
        return "StorageCacheProperty{key=" + this.key + ", value=" + this.value + ", name='" + this.name + '\'' + '}';
    }

    public static <K, V> StorageCacheProperty<K, V> of(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        StorageCache storageCache = (StorageCache)annotated.getAnnotation(StorageCache.class);
        String cacheName = storageCache.value();
        Member member = injectionPoint.getMember();
        if (member instanceof Field) {
            Field field = (Field)member;
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] arguments = genericType.getActualTypeArguments();
            Class key = (Class)arguments[0];
            Class value = (Class)arguments[1];
            return new StorageCacheProperty<K, V>(key, value, cacheName);
        }
        throw new IllegalArgumentException("");
    }
}

