/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.integrations.cdi.types.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import one.microstream.storage.embedded.configuration.types.EmbeddedStorageConfiguration;
import one.microstream.storage.types.StorageManager;
import org.eclipse.microprofile.config.spi.Converter;

public class StorageManagerConverter
implements Converter<StorageManager> {
    private static final Logger LOGGER = Logger.getLogger(StorageManagerConverter.class.getName());
    private static final Map<String, StorageManager> MAP = new ConcurrentHashMap<String, StorageManager>();

    public StorageManager convert(String value) throws IllegalArgumentException, NullPointerException {
        return MAP.computeIfAbsent(value, this::createStorageManager);
    }

    private StorageManager createStorageManager(String value) {
        LOGGER.info("Loading configuration to start the class StorageManager from the key: " + value);
        return EmbeddedStorageConfiguration.load((String)value).createEmbeddedStorageFoundation().createEmbeddedStorageManager().start();
    }
}

